/*
 * Decompiled with CFR 0.152.
 */
package me.andy.shopshelves.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import me.andy.shopshelves.Shopshelves;
import me.andy.shopshelves.config.MessageFormattingManager;
import me.andy.shopshelves.config.ShopPricing;
import me.andy.shopshelves.config.ShopshelvesConfig;
import me.andy.shopshelves.logic.ShopHelper;
import me.andy.shopshelves.util.AdminModeManager;
import me.andy.shopshelves.util.MessageFormatter;
import me.andy.shopshelves.util.MessageUtil;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class ShopshelvesCommand {
    private static final List<String> HELP_PAGE_1 = List.of(" ", "&6&m               &r  &6ShopShelves Helpful Commands &6&m               ", "&a/shops{Opens this help page.}<action:suggest_command,/shops>", "&a/shops itemprice{See the current settings for this item.}<action:suggest_command,/shops itemprice>", "&a/shops itemprice 'price' 'buy/sell/both' 'amount'{Sets global price for held item.}<action:suggest_command,/shops itemprice >", "&a/shops price 'price' 'buy/sell/both' 'amount'{Sets a custom one-time price for the held item.}<action:suggest_command,/shops price >", "&7\u27a1                                                                         {click the commands to auto fill your chat}<action:suggest_command,:)>", "&a/shops reload{Reloads configs.}<action:suggest_command,/shops reload>", "&a/shops update{Forces a refresh of all shop displays.}<action:suggest_command,/shops update>", "&7\u27a1                                                                         {click the commands to auto fill your chat}<action:suggest_command,:)>", "&a/shops mode{See the messages and shelf display mode.}<action:suggest_command,/shops mode>", "&a/shops mode 'mode'{Set messages or shelf display mode.}<action:suggest_command,/shops mode >", "&a/shops admin{Toggles shop setup mode.}<action:suggest_command,/shops admin>", "&7\u27a1                                                                         {click the commands to auto fill your chat}<action:suggest_command,:)>", "&e/shops is an Alias :)                  &6[ShopShelves Help Link]{This is my discord i dont have a github etc yet will look into it :)}<action:open_url,https://discord.gg/GpryZU8QHK>", "&7\u27a1                                                                         {click the commands to auto fill your chat}<action:suggest_command,:)>");
    public static final String PRICE_STAMP_KEY = "shopshelves:price_stamp";
    public static final String MESSAGE_KEY_ITEM_PRICE_NOT_SET = "item_price_not_set";
    public static final String MESSAGE_KEY_ITEM_PRICE_STATUS = "item_price_status";
    public static final String MESSAGE_KEY_CURRENT_MODES_STATUS = "current_modes_status";

    public static void init() {
        CommandRegistrationCallback.EVENT.register(ShopshelvesCommand::register);
    }

    private static LiteralArgumentBuilder<class_2168> addCoreSubcommands(LiteralArgumentBuilder<class_2168> builder) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"admin").requires(source -> Shopshelves.checkPermission(source, "shopshelves.admin", 2))).executes(ShopshelvesCommand::toggleAdminMode))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(source -> Shopshelves.checkPermission(source, "shopshelves.reload", 2))).executes(ShopshelvesCommand::reloadConfigsAndUpdate))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"update").requires(source -> Shopshelves.checkPermission(source, "shopshelves.update", 4))).executes(ShopshelvesCommand::updateAllShopsCommand))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"mode").requires(source -> Shopshelves.checkPermission(source, "shopshelves.mode", 4))).executes(ShopshelvesCommand::showCurrentModes)).then(class_2170.method_9244((String)"mode_name", (ArgumentType)StringArgumentType.word()).suggests(ShopshelvesCommand::suggestAllModes).executes(ShopshelvesCommand::setMode)))).then(ShopshelvesCommand.buildItemPriceCommand())).then(ShopshelvesCommand.buildPriceStampCommand());
    }

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7225.class_7874 registryAccess, class_2170.class_5364 environment) {
        LiteralArgumentBuilder<class_2168> shopshelvesCommand = (LiteralArgumentBuilder<class_2168>)((LiteralArgumentBuilder)class_2170.method_9247((String)"shopshelves").requires(source -> Shopshelves.checkPermission(source, "shopshelves.command", 0))).executes(ShopshelvesCommand::showHelp);
        shopshelvesCommand = ShopshelvesCommand.addCoreSubcommands(shopshelvesCommand);
        dispatcher.register(shopshelvesCommand);
        LiteralArgumentBuilder<class_2168> shopsAliasCommand = (LiteralArgumentBuilder<class_2168>)((LiteralArgumentBuilder)class_2170.method_9247((String)"shops").requires(source -> Shopshelves.checkPermission(source, "shopshelves.command", 0))).executes(ShopshelvesCommand::showHelp);
        shopsAliasCommand = ShopshelvesCommand.addCoreSubcommands(shopsAliasCommand);
        dispatcher.register(shopsAliasCommand);
    }

    private static LiteralArgumentBuilder<class_2168> buildPriceStampCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"price").requires(source -> Shopshelves.checkPermission(source, "shopshelves.price", 2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"price", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(ctx -> ShopshelvesCommand.executePriceStamp((CommandContext<class_2168>)ctx, "sell", -1))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> builder.suggest("sell").suggest("buy").suggest("both").buildFuture()).executes(ctx -> ShopshelvesCommand.executePriceStamp((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"type"), -1))).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> ShopshelvesCommand.executePriceStamp((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"type"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount"))))));
    }

    private static int executePriceStamp(CommandContext<class_2168> context, String type, int amount) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        class_1799 heldStack = player.method_6047();
        if (heldStack.method_7960()) {
            MessageUtil.sendError((class_2168)context.getSource(), "error_must_hold_item");
            return 0;
        }
        class_9279 customData = (class_9279)heldStack.method_58694(class_9334.field_49628);
        class_2487 mutableNbt = customData != null ? customData.method_57461() : new class_2487();
        Optional existingStampOpt = mutableNbt.method_10562(PRICE_STAMP_KEY);
        class_2487 priceStampNbt = existingStampOpt.orElse(new class_2487());
        boolean heldStackHasStamp = existingStampOpt.isPresent();
        if (!heldStackHasStamp) {
            for (int i = 0; i < player.method_31548().method_5439(); ++i) {
                class_1799 stack = player.method_31548().method_5438(i);
                if (stack == heldStack || !Shopshelves.hasPriceStamp(stack)) continue;
                MessageUtil.sendError((class_2168)context.getSource(), "error_existing_price_stamp");
                return 0;
            }
        }
        double price = DoubleArgumentType.getDouble(context, (String)"price");
        int currentAmount = priceStampNbt.method_10545("amount") ? priceStampNbt.method_10550("amount").orElse(1) : (heldStack.method_7947() > 0 ? heldStack.method_7947() : 1);
        int finalAmount = amount > 0 ? amount : currentAmount;
        Double sellPrice = priceStampNbt.method_10545("sell") ? (Double)priceStampNbt.method_10574("sell").orElse(null) : null;
        Double buyPrice = priceStampNbt.method_10545("buy") ? (Double)priceStampNbt.method_10574("buy").orElse(null) : null;
        switch (type.toLowerCase()) {
            case "s": 
            case "sell": {
                priceStampNbt.method_10549("sell", price);
                sellPrice = price;
                break;
            }
            case "b": 
            case "buy": {
                priceStampNbt.method_10549("buy", price);
                buyPrice = price;
                break;
            }
            case "sb": 
            case "both": {
                priceStampNbt.method_10549("sell", price);
                priceStampNbt.method_10549("buy", price);
                sellPrice = price;
                buyPrice = price;
                break;
            }
            default: {
                MessageUtil.sendError((class_2168)context.getSource(), "error_invalid_price_type");
                return 0;
            }
        }
        priceStampNbt.method_10569("amount", finalAmount);
        mutableNbt.method_10566(PRICE_STAMP_KEY, (class_2520)priceStampNbt);
        heldStack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)mutableNbt));
        MessageUtil.sendMessage((class_2168)context.getSource(), "item_price_updated", Map.of("%item%", "Held " + heldStack.method_7909().method_63680().getString(), "%amount%", String.valueOf(finalAmount), "%sell_price%", sellPrice != null ? ShopHelper.formatPrice(sellPrice) : "N/A", "%buy_price%", buyPrice != null ? ShopHelper.formatPrice(buyPrice) : "N/A"));
        return 1;
    }

    private static int showHelp(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        List<class_2561> formattedLines = MessageFormatter.formatLines(HELP_PAGE_1, source.method_44023(), source.method_9211());
        formattedLines.forEach(line -> source.method_9226(() -> line, false));
        return 1;
    }

    private static int updateAllShopsCommand(CommandContext<class_2168> context) {
        MessageUtil.sendMessage((class_2168)context.getSource(), "update_start");
        Shopshelves.updateAllShops(((class_2168)context.getSource()).method_9211());
        MessageUtil.sendMessage((class_2168)context.getSource(), "update_complete");
        return 1;
    }

    private static int reloadConfigsAndUpdate(CommandContext<class_2168> context) {
        ShopshelvesConfig.load();
        MessageFormattingManager.load();
        ShopPricing.load();
        MessageUtil.sendMessage((class_2168)context.getSource(), "reload_success");
        return ShopshelvesCommand.updateAllShopsCommand(context);
    }

    private static LiteralArgumentBuilder<class_2168> buildItemPriceCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"itemprice").requires(source -> Shopshelves.checkPermission(source, "shopshelves.itemprice", 2))).executes(ShopshelvesCommand::showItemPrice)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"price", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(ctx -> ShopshelvesCommand.executeItemPrice((CommandContext<class_2168>)ctx, "sell", -1))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> builder.suggest("sell").suggest("buy").suggest("both").buildFuture()).executes(ctx -> ShopshelvesCommand.executeItemPrice((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"type"), -1))).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> ShopshelvesCommand.executeItemPrice((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"type"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount"))))));
    }

    private static int showItemPrice(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        class_1799 heldStack = player.method_6047();
        if (heldStack.method_7960()) {
            MessageUtil.sendError((class_2168)context.getSource(), "error_must_hold_item");
            return 0;
        }
        ShopPricing.PriceEntry entry = ShopPricing.getPriceEntry(heldStack).orElse(null);
        if (entry == null) {
            MessageUtil.sendMessage((class_2168)context.getSource(), MESSAGE_KEY_ITEM_PRICE_NOT_SET, Map.of("%item%", heldStack.method_7964().getString()));
            return 1;
        }
        String sellPrice = entry.sellPrice() != null ? ShopHelper.formatPrice(entry.sellPrice()) : "N/A";
        String buyPrice = entry.buyPrice() != null ? ShopHelper.formatPrice(entry.buyPrice()) : "N/A";
        MessageUtil.sendMessage((class_2168)context.getSource(), MESSAGE_KEY_ITEM_PRICE_STATUS, Map.of("%item%", heldStack.method_7964().getString(), "%amount%", String.valueOf(entry.amount()), "%sell_price%", sellPrice, "%buy_price%", buyPrice));
        return 1;
    }

    private static int executeItemPrice(CommandContext<class_2168> context, String type, int amount) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        class_1799 heldStack = player.method_6047();
        if (heldStack.method_7960()) {
            MessageUtil.sendError((class_2168)context.getSource(), "error_must_hold_item");
            return 0;
        }
        double price = DoubleArgumentType.getDouble(context, (String)"price");
        ShopPricing.PriceEntry existingEntry = ShopPricing.getPriceEntry(heldStack).orElse(new ShopPricing.PriceEntry(1, null, null));
        int finalAmount = amount > 0 ? amount : existingEntry.amount();
        Double sellPrice = existingEntry.sellPrice();
        Double buyPrice = existingEntry.buyPrice();
        switch (type.toLowerCase()) {
            case "s": 
            case "sell": {
                sellPrice = price;
                break;
            }
            case "b": 
            case "buy": {
                buyPrice = price;
                break;
            }
            case "sb": 
            case "both": {
                sellPrice = price;
                buyPrice = price;
                break;
            }
            default: {
                MessageUtil.sendError((class_2168)context.getSource(), "error_invalid_price_type");
                return 0;
            }
        }
        ShopPricing.setPrice(heldStack, finalAmount, sellPrice, buyPrice);
        ShopPricing.save();
        MessageUtil.sendMessage((class_2168)context.getSource(), "item_price_updated", Map.of("%item%", heldStack.method_7964().getString(), "%amount%", String.valueOf(finalAmount), "%sell_price%", sellPrice != null ? ShopHelper.formatPrice(sellPrice) : "N/A", "%buy_price%", buyPrice != null ? ShopHelper.formatPrice(buyPrice) : "N/A"));
        return 1;
    }

    private static int showCurrentModes(CommandContext<class_2168> context) {
        ShopshelvesConfig config = ShopshelvesConfig.get();
        String messageMode = config.getMessageDeliveryMode().name();
        String priceMode = config.getPriceDisplayMode().name();
        MessageUtil.sendMessage((class_2168)context.getSource(), MESSAGE_KEY_CURRENT_MODES_STATUS, Map.of("%message_mode%", messageMode, "%price_mode%", priceMode));
        return 1;
    }

    private static int setMode(CommandContext<class_2168> context) {
        String modeStr = StringArgumentType.getString(context, (String)"mode_name").toUpperCase();
        try {
            ShopshelvesConfig.MessageDeliveryMode newMode = ShopshelvesConfig.MessageDeliveryMode.valueOf(modeStr);
            ShopshelvesConfig.get().setMessageDeliveryMode(newMode);
            ShopshelvesConfig.save();
            MessageUtil.sendMessage((class_2168)context.getSource(), "message_mode_set", Map.of("%mode%", newMode.name()));
            return 1;
        }
        catch (IllegalArgumentException newMode) {
            try {
                ShopshelvesConfig.PriceDisplayMode newMode2 = ShopshelvesConfig.PriceDisplayMode.valueOf(modeStr);
                ShopshelvesConfig.get().setPriceDisplayMode(newMode2);
                ShopshelvesConfig.save();
                MessageUtil.sendMessage((class_2168)context.getSource(), "price_display_mode_set", Map.of("%mode%", newMode2.name()));
                return ShopshelvesCommand.updateAllShopsCommand(context);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                MessageUtil.sendError((class_2168)context.getSource(), "error_invalid_message_mode", Map.of("%mode%", modeStr));
                return 0;
            }
        }
    }

    private static CompletableFuture<Suggestions> suggestAllModes(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        Arrays.stream(ShopshelvesConfig.MessageDeliveryMode.values()).map(Enum::name).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        Arrays.stream(ShopshelvesConfig.PriceDisplayMode.values()).map(Enum::name).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    private static int toggleAdminMode(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        boolean isAdmin = AdminModeManager.toggleAdminMode(player);
        if (isAdmin) {
            MessageUtil.sendPlayerMessage(player, "admin_mode_enabled", Map.of());
        } else {
            MessageUtil.sendPlayerMessage(player, "admin_mode_disabled", Map.of());
        }
        return 1;
    }
}

