/*
 * Decompiled with CFR 0.152.
 */
package me.andy.shopshelves.logic;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import me.andy.shopshelves.config.ShopPricing;
import me.andy.shopshelves.config.ShopshelvesConfig;
import me.andy.shopshelves.util.EconomyManager;
import me.andy.shopshelves.util.MessageUtil;
import me.andy.shopshelves.util.ShopShelf;
import net.minecraft.class_10129;
import net.minecraft.class_10710;
import net.minecraft.class_11597;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import net.minecraft.class_9296;
import net.minecraft.class_9298;
import net.minecraft.class_9304;
import net.minecraft.class_9334;

public class ShopHelper {
    public static String formatPrice(double price) {
        if (ShopshelvesConfig.get().shouldRoundOffDisplayPrices()) {
            long roundedPrice = Math.round(price);
            return String.valueOf(roundedPrice);
        }
        String formatted = String.format(Locale.ROOT, "%.2f", price);
        if (formatted.endsWith(".00")) {
            return formatted.substring(0, formatted.length() - 3);
        }
        if (formatted.endsWith("0")) {
            return formatted.substring(0, formatted.length() - 1);
        }
        return formatted;
    }

    public static String formatAccuratePrice(double price) {
        return String.format(Locale.ROOT, "%.2f", price);
    }

    public static Optional<Double> getUnitPrice(class_11597 blockEntity, int slot, boolean isBuy) {
        Optional<class_2487> customPriceNbtOpt;
        ShopShelf shopShelf = (ShopShelf)blockEntity;
        ShopMode mode = shopShelf.getShopMode();
        class_1799 shelfStack = blockEntity.method_5438(slot);
        if (shelfStack.method_7960()) {
            return Optional.empty();
        }
        Optional<class_2487> optional = customPriceNbtOpt = mode == ShopMode.PLAYERSHELF ? shopShelf.getCustomPrice(0) : shopShelf.getCustomPrice(slot);
        if (customPriceNbtOpt.isPresent()) {
            Optional basePriceOpt;
            String priceKey;
            class_2487 customPriceNbt = customPriceNbtOpt.get();
            String string = priceKey = isBuy ? "buy" : "sell";
            if (customPriceNbt.method_10545(priceKey) && (basePriceOpt = customPriceNbt.method_10574(priceKey)).isPresent()) {
                double basePrice = (Double)basePriceOpt.get();
                int customAmount = customPriceNbt.method_10550("amount").orElse(1);
                if (customAmount <= 0) {
                    return Optional.of(0.0);
                }
                return Optional.of(basePrice / (double)customAmount);
            }
            if (mode == ShopMode.PLAYERSHELF) {
                return Optional.empty();
            }
        }
        ShopMode pricingMode = isBuy ? ShopMode.BUY : ShopMode.SELL;
        return ShopPricing.getPriceEntry(shelfStack).flatMap(configEntry -> {
            Double basePrice;
            switch (pricingMode.ordinal()) {
                case 1: {
                    Double d = configEntry.buyPrice();
                    break;
                }
                case 2: {
                    Double d = configEntry.sellPrice();
                    break;
                }
                default: {
                    Double d = basePrice = null;
                }
            }
            if (basePrice == null) {
                return Optional.empty();
            }
            int configBaseAmount = configEntry.amount();
            if (configBaseAmount <= 0) {
                return Optional.of(0.0);
            }
            return Optional.of(basePrice / (double)configBaseAmount);
        });
    }

    public static void handleAdminSetup(class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_11597 blockEntity, int slot) {
        ShopShelf shopShelf = (ShopShelf)blockEntity;
        class_1799 heldStack = player.method_5998(hand);
        if (player.method_5715()) {
            ShopMode currentMode = shopShelf.getShopMode();
            if (currentMode == ShopMode.PLAYERSHELF) {
                shopShelf.setShopMode(ShopMode.NONE);
            } else {
                ShopMode nextMode = switch (currentMode.ordinal()) {
                    case 0 -> ShopMode.BUY;
                    case 1 -> ShopMode.SELL;
                    case 2 -> ShopMode.DUAL;
                    case 3 -> ShopMode.NONE;
                    default -> ShopMode.NONE;
                };
                shopShelf.setShopMode(nextMode);
            }
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                MessageUtil.sendPlayerMessage(serverPlayer, "shop_mode_set", Map.of("%mode%", shopShelf.getShopMode().name()));
            }
            world.method_8396(null, pos, (class_3414)class_3417.field_15015.comp_349(), class_3419.field_15245, 0.5f, 1.2f);
            return;
        }
        if (!heldStack.method_7960()) {
            class_2487 mutableNbt;
            Optional stampOpt;
            class_9279 customData = (class_9279)heldStack.method_58694(class_9334.field_49628);
            if (customData != null && (stampOpt = (mutableNbt = customData.method_57461()).method_10562("shopshelves:price_stamp")).isPresent() && !((class_2487)stampOpt.get()).method_33133()) {
                class_2487 stamp = (class_2487)stampOpt.get();
                shopShelf.setCustomPrice(slot, stamp.method_10553());
                mutableNbt.method_10551("shopshelves:price_stamp");
                if (mutableNbt.method_33133()) {
                    heldStack.method_57381(class_9334.field_49628);
                } else {
                    heldStack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)mutableNbt));
                }
            }
            class_1799 shopItem = heldStack.method_7972();
            blockEntity.method_5447(slot, shopItem);
            shopShelf.setOwner(player.method_5667());
            if (shopShelf.getShopMode() == ShopMode.NONE) {
                shopShelf.setShopMode(ShopMode.BUY);
            }
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                MessageUtil.sendPlayerMessage(serverPlayer, "shop_slot_set", Map.of("%slot%", String.valueOf(slot + 1), "%item%", shopItem.method_7964().getString(), "%count%", String.valueOf(shopItem.method_7947())));
            }
            world.method_8396(null, pos, class_3417.field_40970, class_3419.field_15245, 1.0f, 1.0f);
        } else {
            blockEntity.method_5447(slot, class_1799.field_8037);
            shopShelf.setCustomPrice(slot, null);
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                MessageUtil.sendPlayerMessage(serverPlayer, "shop_slot_cleared", Map.of("%slot%", String.valueOf(slot + 1)));
            }
            world.method_8396(null, pos, class_3417.field_40973, class_3419.field_15245, 1.0f, 1.0f);
            if (blockEntity.method_5442() && shopShelf.getLinkedContainerPos().isEmpty()) {
                shopShelf.setShopMode(ShopMode.NONE);
                shopShelf.setOwner(null);
                shopShelf.setLinkedContainerPos(null);
            }
        }
    }

    public static void applyAndCleanPlayerShopPriceStamp(class_11597 blockEntity, class_1799 heldStack, class_1657 player) {
        double price;
        if (heldStack.method_7960()) {
            return;
        }
        class_9279 customData = (class_9279)heldStack.method_58694(class_9334.field_49628);
        if (customData == null) {
            return;
        }
        ShopShelf shopShelf = (ShopShelf)blockEntity;
        class_2487 mutableNbt = customData.method_57461();
        Optional stampOpt = mutableNbt.method_10562("shopshelves:price_stamp");
        if (stampOpt.isEmpty() || ((class_2487)stampOpt.get()).method_33133()) {
            return;
        }
        class_2487 stamp = (class_2487)stampOpt.get();
        class_2487 existingPrices = shopShelf.getCustomPrice(0).orElse(new class_2487());
        Optional stampSellPrice = stamp.method_10574("sell");
        Optional stampBuyPrice = stamp.method_10574("buy");
        OptionalInt stampAmount = stamp.method_10550("amount").map(OptionalInt::of).orElseGet(OptionalInt::empty);
        if (stampSellPrice.isPresent()) {
            price = (Double)stampSellPrice.get();
            if (price > 0.0) {
                existingPrices.method_10549("sell", price);
            } else {
                existingPrices.method_10551("sell");
            }
        }
        if (stampBuyPrice.isPresent()) {
            price = (Double)stampBuyPrice.get();
            if (price > 0.0) {
                existingPrices.method_10549("buy", price);
            } else {
                existingPrices.method_10551("buy");
            }
        }
        if (stampAmount.isPresent() && stampAmount.getAsInt() > 0) {
            existingPrices.method_10569("amount", stampAmount.getAsInt());
        } else if (!existingPrices.method_10545("amount")) {
            existingPrices.method_10569("amount", 1);
        }
        if (!existingPrices.method_33133()) {
            for (i = 0; i < 3; ++i) {
                shopShelf.setCustomPrice(i, existingPrices.method_10553());
            }
        } else {
            for (i = 0; i < 3; ++i) {
                shopShelf.setCustomPrice(i, null);
            }
        }
        mutableNbt.method_10551("shopshelves:price_stamp");
        if (mutableNbt.method_33133()) {
            heldStack.method_57381(class_9334.field_49628);
        } else {
            heldStack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)mutableNbt));
        }
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            MessageUtil.sendPlayerMessage(serverPlayer, "playershop_price_set", Collections.emptyMap());
        }
        player.method_73183().method_8396(null, player.method_24515(), class_3417.field_14627, class_3419.field_15248, 0.5f, 1.5f);
    }

    public static Optional<Double> getPrice(class_11597 blockEntity, int slot, ShopMode mode, boolean isBuy) {
        Optional<class_2487> customPriceNbtOpt;
        ShopShelf shopShelf = (ShopShelf)blockEntity;
        class_1799 shelfStack = blockEntity.method_5438(slot);
        if (shelfStack.method_7960()) {
            return Optional.empty();
        }
        Optional<class_2487> optional = customPriceNbtOpt = mode == ShopMode.PLAYERSHELF ? shopShelf.getCustomPrice(0) : shopShelf.getCustomPrice(slot);
        if (customPriceNbtOpt.isPresent()) {
            Optional basePriceOpt;
            String priceKey;
            class_2487 customPriceNbt = customPriceNbtOpt.get();
            String string = priceKey = isBuy ? "buy" : "sell";
            if (customPriceNbt.method_10545(priceKey) && (basePriceOpt = customPriceNbt.method_10574(priceKey)).isPresent()) {
                double basePrice = (Double)basePriceOpt.get();
                int customAmount = customPriceNbt.method_10550("amount").orElse(1);
                int shelfAmount = shelfStack.method_7947();
                if (customAmount <= 0) {
                    return Optional.of(0.0);
                }
                double finalPrice = basePrice / (double)customAmount * (double)shelfAmount;
                return Optional.of(finalPrice);
            }
            if (mode == ShopMode.PLAYERSHELF) {
                return Optional.empty();
            }
        }
        ShopMode pricingMode = isBuy ? ShopMode.BUY : ShopMode.SELL;
        return ShopPricing.calculatePrice(shelfStack, pricingMode);
    }

    public static Optional<class_1263> getLinkedContainerInventory(class_3218 world, ShopShelf shopShelf) {
        Optional<class_2338> posOpt = shopShelf.getLinkedContainerPos();
        if (posOpt.isEmpty()) {
            return Optional.empty();
        }
        class_2338 pos = posOpt.get();
        if (!world.method_22340(pos)) {
            return Optional.empty();
        }
        class_2586 be = world.method_8321(pos);
        if (be instanceof class_1263) {
            class_1263 inventory = (class_1263)be;
            return Optional.of(inventory);
        }
        return Optional.empty();
    }

    public static boolean isPlayerShelfOutOfOrder(class_3218 world, ShopShelf shopShelf) {
        return shopShelf.getShopMode() == ShopMode.PLAYERSHELF && ShopHelper.getLinkedContainerInventory(world, shopShelf).isEmpty();
    }

    public static void handlePlayerShelfBuy(class_3218 world, class_3222 buyer, class_11597 blockEntity, int slot) {
        ShopShelf shopShelf = (ShopShelf)blockEntity;
        Optional<UUID> ownerUuidOpt = shopShelf.getOwner();
        class_1799 shelfStack = blockEntity.method_5438(slot);
        if (shelfStack.method_7960() || ownerUuidOpt.isEmpty()) {
            return;
        }
        if (!EconomyManager.isEconomyEnabled()) {
            MessageUtil.sendError(buyer.method_64396(), "error_economy_not_enabled");
            return;
        }
        int amountToBuy = shelfStack.method_7947();
        class_1799 itemToGive = shelfStack.method_7972();
        if (ownerUuidOpt.get().equals(buyer.method_5667())) {
            return;
        }
        Optional<Double> priceOpt = ShopHelper.getPrice(blockEntity, slot, ShopMode.PLAYERSHELF, true);
        if (priceOpt.isEmpty()) {
            MessageUtil.sendError(buyer.method_64396(), "error_item_not_for_sale");
            return;
        }
        double price = priceOpt.get();
        Optional<class_1263> containerOpt = ShopHelper.getLinkedContainerInventory(world, shopShelf);
        if (containerOpt.isEmpty()) {
            MessageUtil.sendError(buyer.method_64396(), "error_container_missing");
            return;
        }
        class_1263 container = containerOpt.get();
        if (ShopHelper.countItems(container, itemToGive) < itemToGive.method_7947()) {
            MessageUtil.sendError(buyer.method_64396(), "error_shop_out_of_stock");
            return;
        }
        if (EconomyManager.hasEnough(buyer, price)) {
            if (ShopHelper.removeItems(container, itemToGive)) {
                if (buyer.method_31548().method_7394(itemToGive.method_7972())) {
                    EconomyManager.withdraw(buyer, price);
                    EconomyManager.deposit(ownerUuidOpt.get(), price, world.method_8503());
                    MessageUtil.sendPlayerMessage(buyer, "item_bought", Map.of("%amount%", String.valueOf(amountToBuy), "%item%", itemToGive.method_7964().getString(), "%price%", ShopHelper.formatAccuratePrice(price)));
                    world.method_8396(null, buyer.method_24515(), class_3417.field_14933, class_3419.field_15248, 0.5f, 1.0f);
                } else {
                    ShopHelper.addItems(container, itemToGive);
                    MessageUtil.sendError(buyer.method_64396(), "error_inventory_full");
                }
            } else {
                MessageUtil.sendError(buyer.method_64396(), "error_shop_out_of_stock");
            }
        } else {
            MessageUtil.sendError(buyer.method_64396(), "error_insufficient_funds", Map.of("%price%", ShopHelper.formatAccuratePrice(price)));
        }
    }

    public static void handlePlayerShelfSell(class_3218 world, class_3222 seller, class_11597 blockEntity, int slot) {
        ShopShelf shopShelf = (ShopShelf)blockEntity;
        Optional<UUID> ownerUuidOpt = shopShelf.getOwner();
        class_1799 itemToSell = blockEntity.method_5438(slot).method_7972();
        if (itemToSell.method_7960() || ownerUuidOpt.isEmpty()) {
            return;
        }
        if (!EconomyManager.isEconomyEnabled()) {
            MessageUtil.sendError(seller.method_64396(), "error_economy_not_enabled");
            return;
        }
        if (ownerUuidOpt.get().equals(seller.method_5667())) {
            return;
        }
        Optional<Double> priceOpt = ShopHelper.getPrice(blockEntity, slot, ShopMode.PLAYERSHELF, false);
        if (priceOpt.isEmpty()) {
            MessageUtil.sendError(seller.method_64396(), "error_shop_not_buying");
            return;
        }
        double price = priceOpt.get();
        Optional<class_1263> containerOpt = ShopHelper.getLinkedContainerInventory(world, shopShelf);
        if (containerOpt.isEmpty()) {
            MessageUtil.sendError(seller.method_64396(), "error_container_missing");
            return;
        }
        class_1263 container = containerOpt.get();
        if (!EconomyManager.hasEnough(ownerUuidOpt.get(), price, world.method_8503())) {
            MessageUtil.sendError(seller.method_64396(), "error_owner_insufficient_funds");
            return;
        }
        if (ShopHelper.countItems((class_1263)seller.method_31548(), itemToSell) < itemToSell.method_7947()) {
            MessageUtil.sendError(seller.method_64396(), "error_not_enough_items_to_sell", Map.of("%amount%", String.valueOf(itemToSell.method_7947()), "%item%", itemToSell.method_7964().getString()));
            return;
        }
        if (!ShopHelper.hasEnoughSpace(container, itemToSell)) {
            MessageUtil.sendError(seller.method_64396(), "error_shop_container_full");
            return;
        }
        if (ShopHelper.removeItems((class_1263)seller.method_31548(), itemToSell)) {
            EconomyManager.withdraw(ownerUuidOpt.get(), price, world.method_8503());
            EconomyManager.deposit(seller, price);
            ShopHelper.addItems(container, itemToSell);
            MessageUtil.sendPlayerMessage(seller, "item_sold", Map.of("%amount%", String.valueOf(itemToSell.method_7947()), "%item%", itemToSell.method_7964().getString(), "%price%", ShopHelper.formatAccuratePrice(price)));
            world.method_8396(null, seller.method_24515(), class_3417.field_14933, class_3419.field_15248, 0.5f, 1.0f);
        } else {
            MessageUtil.sendError(seller.method_64396(), "error_not_enough_items_to_sell", Map.of("%amount%", String.valueOf(itemToSell.method_7947()), "%item%", itemToSell.method_7964().getString()));
        }
    }

    public static void handleBuyInteraction(class_3218 world, class_3222 player, class_11597 blockEntity, int slot, boolean isShiftClick) {
        int amountToBuy;
        class_1799 shelfStack = blockEntity.method_5438(slot);
        if (shelfStack.method_7960()) {
            return;
        }
        if (!EconomyManager.isEconomyEnabled()) {
            MessageUtil.sendError(player.method_64396(), "error_economy_not_enabled");
            return;
        }
        int n = amountToBuy = isShiftClick ? shelfStack.method_7914() : shelfStack.method_7947();
        if (amountToBuy <= 0) {
            return;
        }
        Optional<Double> unitPriceOpt = ShopHelper.getUnitPrice(blockEntity, slot, true);
        if (unitPriceOpt.isEmpty()) {
            MessageUtil.sendError(player.method_64396(), "error_item_not_for_sale");
            return;
        }
        double price = unitPriceOpt.get() * (double)amountToBuy;
        class_1799 itemToGive = shelfStack.method_46651(amountToBuy);
        if (EconomyManager.hasEnough(player, price)) {
            if (player.method_31548().method_7394(itemToGive)) {
                EconomyManager.withdraw(player, price);
                MessageUtil.sendPlayerMessage(player, "item_bought", Map.of("%amount%", String.valueOf(amountToBuy), "%item%", shelfStack.method_7964().getString(), "%price%", ShopHelper.formatAccuratePrice(price)));
                world.method_8396(null, player.method_24515(), class_3417.field_14933, class_3419.field_15248, 0.5f, 1.0f);
            } else {
                MessageUtil.sendError(player.method_64396(), "error_inventory_full");
            }
        } else {
            MessageUtil.sendError(player.method_64396(), "error_insufficient_funds", Map.of("%price%", ShopHelper.formatAccuratePrice(price)));
        }
    }

    public static void handleSellInteraction(class_3218 world, class_3222 player, class_11597 blockEntity, int slot, boolean isShiftClick) {
        int desiredAmountToSell;
        class_1799 shelfStack = blockEntity.method_5438(slot);
        if (shelfStack.method_7960()) {
            return;
        }
        if (!EconomyManager.isEconomyEnabled()) {
            MessageUtil.sendError(player.method_64396(), "error_economy_not_enabled");
            return;
        }
        Optional<Double> unitPriceOpt = ShopHelper.getUnitPrice(blockEntity, slot, false);
        if (unitPriceOpt.isEmpty()) {
            MessageUtil.sendError(player.method_64396(), "error_shop_not_buying");
            return;
        }
        double unitPrice = unitPriceOpt.get();
        int n = desiredAmountToSell = isShiftClick ? shelfStack.method_7914() : shelfStack.method_7947();
        if (desiredAmountToSell <= 0) {
            return;
        }
        int playerItemCount = ShopHelper.countItems((class_1263)player.method_31548(), shelfStack);
        int actualAmountToSell = isShiftClick ? Math.min(desiredAmountToSell, playerItemCount) : desiredAmountToSell;
        if (actualAmountToSell <= 0 || playerItemCount < actualAmountToSell) {
            MessageUtil.sendError(player.method_64396(), "error_not_enough_items_to_sell", Map.of("%amount%", String.valueOf(desiredAmountToSell), "%item%", shelfStack.method_7964().getString()));
            return;
        }
        double price = unitPrice * (double)actualAmountToSell;
        class_1799 transactionStack = shelfStack.method_46651(actualAmountToSell);
        if (ShopHelper.removeItems((class_1263)player.method_31548(), transactionStack)) {
            EconomyManager.deposit(player, price);
            MessageUtil.sendPlayerMessage(player, "item_sold", Map.of("%amount%", String.valueOf(transactionStack.method_7947()), "%item%", shelfStack.method_7964().getString(), "%price%", ShopHelper.formatAccuratePrice(price)));
            world.method_8396(null, player.method_24515(), class_3417.field_14933, class_3419.field_15248, 0.5f, 1.0f);
        } else {
            MessageUtil.sendError(player.method_64396(), "error_not_enough_items_to_sell", Map.of("%amount%", String.valueOf(transactionStack.method_7947()), "%item%", shelfStack.method_7964().getString()));
        }
    }

    public static int countItems(class_1263 inventory, class_1799 stackToCount) {
        int amountFound = 0;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 currentStack = inventory.method_5438(i);
            if (!ShopHelper.canStack(stackToCount, currentStack)) continue;
            amountFound += currentStack.method_7947();
        }
        return amountFound;
    }

    private static boolean removeItems(class_1263 inventory, class_1799 stackToRemove) {
        int amountNeeded = stackToRemove.method_7947();
        ArrayList<Integer> matchingSlots = new ArrayList<Integer>();
        int amountFound = 0;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 currentStack = inventory.method_5438(i);
            if (!ShopHelper.canStack(stackToRemove, currentStack)) continue;
            amountFound += currentStack.method_7947();
            matchingSlots.add(i);
        }
        if (amountFound < amountNeeded) {
            return false;
        }
        int amountRemoved = 0;
        Iterator iterator = matchingSlots.iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            class_1799 currentStack = inventory.method_5438(slot);
            int amountToTake = Math.min(currentStack.method_7947(), amountNeeded - amountRemoved);
            currentStack.method_7934(amountToTake);
            if ((amountRemoved += amountToTake) < amountNeeded) continue;
            inventory.method_5431();
            return true;
        }
        return false;
    }

    private static void addItems(class_1263 inventory, class_1799 stackToAdd) {
        int transferable;
        class_1799 slotStack;
        int i;
        if (stackToAdd.method_7960()) {
            return;
        }
        int amountToAdd = stackToAdd.method_7947();
        for (i = 0; i < inventory.method_5439(); ++i) {
            slotStack = inventory.method_5438(i);
            if (!class_1799.method_31577((class_1799)slotStack, (class_1799)stackToAdd) || !slotStack.method_7946() || (transferable = Math.min(amountToAdd, slotStack.method_7914() - slotStack.method_7947())) <= 0) continue;
            slotStack.method_7933(transferable);
            inventory.method_5431();
            if ((amountToAdd -= transferable) > 0) continue;
            return;
        }
        for (i = 0; i < inventory.method_5439(); ++i) {
            slotStack = inventory.method_5438(i);
            if (!slotStack.method_7960()) continue;
            transferable = Math.min(amountToAdd, stackToAdd.method_7914());
            class_1799 newStack = stackToAdd.method_7972();
            newStack.method_7939(transferable);
            inventory.method_5447(i, newStack);
            inventory.method_5431();
            if ((amountToAdd -= transferable) > 0) continue;
            return;
        }
    }

    private static boolean hasEnoughSpace(class_1263 inventory, class_1799 stackToCheck) {
        int amountToFit = stackToCheck.method_7947();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 slotStack = inventory.method_5438(i);
            if (slotStack.method_7960()) {
                amountToFit -= stackToCheck.method_7914();
            } else if (class_1799.method_31577((class_1799)slotStack, (class_1799)stackToCheck)) {
                amountToFit -= slotStack.method_7914() - slotStack.method_7947();
            }
            if (amountToFit > 0) continue;
            return true;
        }
        return false;
    }

    private static boolean canStack(class_1799 a, class_1799 b) {
        return class_1799.method_31577((class_1799)a, (class_1799)b);
    }

    public static String getVariationId(class_1799 stack) {
        class_6880 variant;
        String baseId = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString();
        if (stack.method_31574(class_1802.field_8574) || stack.method_31574(class_1802.field_8436) || stack.method_31574(class_1802.field_8150) || stack.method_31574(class_1802.field_8087)) {
            class_1844 potionContents = (class_1844)stack.method_58694(class_9334.field_49651);
            if (potionContents == null) {
                return baseId;
            }
            String potionName = potionContents.comp_2378().flatMap(class_6880::method_40230).map(k -> k.method_29177().method_12832()).orElse("unknown");
            if (potionName.equals("water") || potionName.equals("mundane") || potionName.equals("thick") || potionName.equals("awkward")) {
                return baseId + ":" + potionName;
            }
            Iterable effects = potionContents.method_57397();
            boolean isTurtleMaster = false;
            for (class_1293 effect : effects) {
                if (!((class_1291)effect.method_5579().comp_349()).equals(class_1294.field_5907.comp_349())) continue;
                isTurtleMaster = true;
                break;
            }
            if (isTurtleMaster) {
                potionName = "turtle_master";
            }
            String suffix = ShopHelper.getPotionSuffix(effects, potionName);
            return baseId + ":" + suffix;
        }
        if (stack.method_31574(class_1802.field_8598)) {
            Optional firstEntry;
            class_9304 enchantmentsComponent = (class_9304)stack.method_58694(class_9334.field_49643);
            if (enchantmentsComponent != null && !enchantmentsComponent.method_57543() && (firstEntry = enchantmentsComponent.method_57539().stream().findFirst()).isPresent()) {
                Object2IntMap.Entry entry = (Object2IntMap.Entry)firstEntry.get();
                class_6880 enchantment = (class_6880)entry.getKey();
                int level = entry.getIntValue();
                String enchantmentId = enchantment.method_40230().map(k -> k.method_29177().method_12832()).orElse("unknown");
                return baseId + ":" + enchantmentId.toLowerCase(Locale.ROOT) + level;
            }
            return baseId + ":unenchanted";
        }
        if (stack.method_31574(class_1802.field_50140)) {
            class_10129 amplifierComponent = (class_10129)stack.method_58694(class_9334.field_50238);
            if (amplifierComponent == null) {
                return baseId;
            }
            int amplifier = amplifierComponent.comp_3090();
            String romanLevel = switch (amplifier) {
                case 1 -> "I";
                case 2 -> "II";
                case 3 -> "III";
                case 4 -> "IV";
                default -> "";
            };
            return romanLevel.isEmpty() ? baseId : baseId + ":" + romanLevel;
        }
        if (stack.method_31574(class_1802.field_39057)) {
            class_10710 component = (class_10710)stack.method_58694(class_9334.field_49612);
            String sound = "";
            if (component != null) {
                sound = component.comp_3598().method_67385().map(k -> k.method_29177().method_12832()).orElse("");
            }
            if (!sound.isEmpty()) {
                return baseId + ":" + sound;
            }
        }
        if (stack.method_31574(class_1802.field_8575)) {
            String playerName;
            class_9296 profileComponent = (class_9296)stack.method_58694(class_9334.field_49617);
            String string = playerName = profileComponent != null ? profileComponent.method_73317().orElse("") : "";
            if (!playerName.isEmpty()) {
                return baseId + ":" + playerName;
            }
        }
        if (stack.method_31574(class_1802.field_8766)) {
            class_9298 effectsComponent = (class_9298)stack.method_58695(class_9334.field_49652, (Object)class_9298.field_49362);
            ArrayList<class_1293> effects = new ArrayList<class_1293>();
            for (class_9298.class_8751 stewEffect : effectsComponent.comp_2416()) {
                effects.add(new class_1293(stewEffect.comp_1838(), stewEffect.comp_1839(), 0));
            }
            if (!effects.isEmpty()) {
                class_1293 effect = (class_1293)effects.get(0);
                class_1291 statusEffect = (class_1291)effect.method_5579().comp_349();
                boolean hasResistance = false;
                for (class_1293 e : effects) {
                    if (!((class_1291)e.method_5579().comp_349()).equals(class_1294.field_5907.comp_349())) continue;
                    hasResistance = true;
                    break;
                }
                String effectId = class_7923.field_41174.method_10221((Object)statusEffect).method_12832();
                if (hasResistance) {
                    effectId = "turtle_master";
                }
                String suffix = ShopHelper.getPotionSuffix(effects, effectId);
                return baseId + ":" + suffix;
            }
        }
        if (stack.method_31574(class_1802.field_8892) && (variant = (class_6880)stack.method_58694(class_9334.field_56138)) != null) {
            Optional variantKeyOpt = variant.method_40230();
            if (variantKeyOpt.isPresent()) {
                String variantId = ((class_5321)variantKeyOpt.get()).method_29177().method_12832();
                return baseId + ":" + variantId;
            }
            return baseId + ":unknown";
        }
        return baseId;
    }

    private static String getPotionSuffix(Iterable<class_1293> effects, String basePotionName) {
        String durationStr;
        class_1293 effect;
        Iterator<class_1293> iterator;
        class_1293 primaryEffect = null;
        if (basePotionName.equals("turtle_master")) {
            iterator = effects.iterator();
            while (iterator.hasNext()) {
                effect = iterator.next();
                if (!((class_1291)effect.method_5579().comp_349()).equals(class_1294.field_5907.comp_349())) continue;
                primaryEffect = effect;
                break;
            }
        }
        if (primaryEffect == null && (iterator = effects.iterator()).hasNext()) {
            primaryEffect = effect = iterator.next();
        }
        if (primaryEffect == null) {
            return basePotionName;
        }
        class_1291 statusEffect = (class_1291)primaryEffect.method_5579().comp_349();
        String effectId = class_7923.field_41174.method_10221((Object)statusEffect).method_12832();
        if (basePotionName.equals("turtle_master")) {
            effectId = "turtle_master";
        }
        int amplifier = primaryEffect.method_5578() + 1;
        int durationTicks = primaryEffect.method_5584();
        if (statusEffect.method_5561()) {
            return effectId.toLowerCase(Locale.ROOT) + amplifier + "_instant";
        }
        if (durationTicks < 20) {
            durationStr = durationTicks + "t";
        } else {
            long seconds = durationTicks / 20;
            if (seconds % 60L == 0L) {
                durationStr = seconds / 60L + "min";
            } else if (seconds >= 60L) {
                long minutes = seconds / 60L;
                long remainingSeconds = seconds % 60L;
                durationStr = minutes + "min" + remainingSeconds + "s";
            } else {
                durationStr = seconds + "s";
            }
        }
        return effectId.toLowerCase(Locale.ROOT) + amplifier + "_" + durationStr;
    }

    public static enum ShopMode {
        NONE,
        BUY,
        SELL,
        DUAL,
        PLAYERSHELF;

    }
}

