/*
 * Decompiled with CFR 0.152.
 */
package me.andy.shopshelves.mixin;

import java.util.Map;
import java.util.UUID;
import me.andy.shopshelves.logic.ShopHelper;
import me.andy.shopshelves.util.AdminModeManager;
import me.andy.shopshelves.util.MessageUtil;
import me.andy.shopshelves.util.ShopDataManager;
import me.andy.shopshelves.util.ShopShelf;
import net.minecraft.class_10225;
import net.minecraft.class_11585;
import net.minecraft.class_11586;
import net.minecraft.class_11597;
import net.minecraft.class_11598;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_11586.class})
public abstract class ShelfBlockMixin
extends class_2237
implements class_11585 {
    private static final float SHOP_BLAST_RESISTANCE = 3600.0f;

    protected ShelfBlockMixin(class_4970.class_2251 settings) {
        super(settings);
    }

    @Inject(method={"getFluidState"}, at={@At(value="HEAD")}, cancellable=true)
    private void shopshelves$preventFluidState(class_2680 state, CallbackInfoReturnable<class_3610> cir) {
        if (state.method_28498((class_2769)class_11586.field_61427) && ((Boolean)state.method_11654((class_2769)class_11586.field_61427)).booleanValue()) {
            cir.setReturnValue((Object)class_3612.field_15906.method_15785());
        }
    }

    @Inject(method={"onStateReplaced(Lnet/minecraft/block/BlockState;Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/util/math/BlockPos;Z)V"}, at={@At(value="TAIL")})
    private void onShopBroken(class_2680 state, class_3218 world, class_2338 pos, boolean moved, CallbackInfo ci) {
        class_2680 newState = world.method_8320(pos);
        if (state.method_27852(newState.method_26204())) {
            return;
        }
        ShopDataManager.get().removeShopDisplayUuids(world, pos).ifPresent(uuids -> {
            for (UUID uuid : uuids) {
                class_1297 entity = world.method_66347(uuid);
                if (entity == null) continue;
                entity.method_31472();
            }
        });
    }

    @Inject(method={"onUseWithItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void preVanillaUseWithItem(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit, CallbackInfoReturnable<class_1269> cir) {
        if (world.method_8608() || hand == class_1268.field_5810) {
            return;
        }
        class_2586 be = world.method_8321(pos);
        if (!(be instanceof class_11597)) {
            return;
        }
        class_11597 blockEntity = (class_11597)be;
        ShopShelf shopShelf = (ShopShelf)be;
        if (shopShelf.getShopMode() != ShopHelper.ShopMode.NONE && ((Boolean)state.method_11654((class_2769)class_11586.field_61424)).booleanValue()) {
            cir.setReturnValue((Object)class_1269.field_5814);
            return;
        }
        boolean isOwner = shopShelf.getOwner().map(uuid -> uuid.equals(player.method_5667())).orElse(false);
        boolean isAdmin = AdminModeManager.isAdmin(player);
        ShopHelper.ShopMode shopMode = shopShelf.getShopMode();
        if (state.method_11654((class_2769)class_11586.field_61425) != hit.method_17780()) {
            return;
        }
        int slot = this.method_72611(hit, (class_2350)state.method_11654((class_2769)class_11586.field_61425)).orElse(-1);
        if (slot == -1) {
            return;
        }
        if (isAdmin && shopMode != ShopHelper.ShopMode.PLAYERSHELF) {
            ShopHelper.handleAdminSetup(world, pos, player, hand, blockEntity, slot);
            cir.setReturnValue((Object)class_1269.field_5812);
            return;
        }
        if (shopMode == ShopHelper.ShopMode.PLAYERSHELF) {
            if (isOwner) {
                ShopHelper.applyAndCleanPlayerShopPriceStamp(blockEntity, stack, player);
                if (!stack.method_7960()) {
                    class_1792 firstItem = null;
                    for (int i = 0; i < blockEntity.method_5439(); ++i) {
                        class_1799 slotStack = blockEntity.method_5438(i);
                        if (slotStack.method_7960()) continue;
                        firstItem = slotStack.method_7909();
                        break;
                    }
                    if (firstItem != null && !stack.method_31574(firstItem)) {
                        if (player instanceof class_3222) {
                            class_3222 serverPlayer = (class_3222)player;
                            MessageUtil.sendError(serverPlayer.method_64396(), "error_item_type_mismatch", Map.of("%item%", firstItem.method_63680().getString()));
                        }
                        cir.setReturnValue((Object)class_1269.field_5814);
                        return;
                    }
                }
                return;
            }
            cir.setReturnValue((Object)class_1269.field_5814);
            return;
        }
        if (shopShelf.getOwner().isPresent()) {
            cir.setReturnValue((Object)class_1269.field_5814);
        }
    }

    @Inject(method={"onUseWithItem"}, at={@At(value="RETURN")})
    private void postVanillaUseWithItem(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit, CallbackInfoReturnable<class_1269> cir) {
        if (world.method_8608() || !((class_1269)cir.getReturnValue()).method_23665()) {
            return;
        }
        class_2586 be = world.method_8321(pos);
        if (!(be instanceof class_11597)) {
            return;
        }
        class_11597 blockEntity = (class_11597)be;
        ShopShelf shopShelf = (ShopShelf)be;
        boolean isOwner = shopShelf.getOwner().map(uuid -> uuid.equals(player.method_5667())).orElse(false);
        ShopHelper.ShopMode shopMode = shopShelf.getShopMode();
        if (shopMode == ShopHelper.ShopMode.PLAYERSHELF && isOwner) {
            blockEntity.method_5431();
        }
    }

    @Inject(method={"getStateForNeighborUpdate"}, at={@At(value="RETURN")}, cancellable=true)
    private void preventShopShelfChaining(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random, CallbackInfoReturnable<class_2680> cir) {
        ShopShelf shopShelf;
        class_2586 be = world.method_8321(pos);
        if (be instanceof ShopShelf && (shopShelf = (ShopShelf)be).getShopMode() != ShopHelper.ShopMode.NONE) {
            cir.setReturnValue((Object)((class_2680)((class_2680)cir.getReturnValue()).method_11657((class_2769)class_11586.field_61426, (Comparable)class_11598.field_61446)));
        }
    }
}

