/*
 * Decompiled with CFR 0.152.
 */
package me.andy.shopshelves.util;

import java.util.UUID;
import me.andy.shopshelves.Shopshelves;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class EconomyManager {
    public static boolean isEconomyEnabled() {
        try {
            Class.forName("me.andy.ecobal.api.EconomyManager");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean hasEnough(class_3222 player, double amount) {
        MinecraftServer server = player.method_51469().method_8503();
        return EconomyManager.hasEnough(player.method_5667(), amount, server);
    }

    public static boolean hasEnough(UUID uuid, double amount, @Nullable MinecraftServer server) {
        if (amount < 0.0) {
            return true;
        }
        if (!EconomyManager.isEconomyEnabled()) {
            return false;
        }
        return me.andy.ecobal.api.EconomyManager.getBalance((UUID)uuid) >= amount;
    }

    public static void deposit(class_3222 player, double amount) {
        MinecraftServer server = player.method_51469().method_8503();
        EconomyManager.deposit(player.method_5667(), amount, server);
    }

    public static void deposit(UUID uuid, double amount, @Nullable MinecraftServer server) {
        if (!EconomyManager.isEconomyEnabled()) {
            Shopshelves.LOGGER.warn("Attempted to deposit funds to {} but EcoBal is not available.", (Object)uuid);
            return;
        }
        me.andy.ecobal.api.EconomyManager.silentDeposit((UUID)uuid, (double)amount);
    }

    public static boolean withdraw(class_3222 player, double amount) {
        MinecraftServer server = player.method_51469().method_8503();
        return EconomyManager.withdraw(player.method_5667(), amount, server);
    }

    public static boolean withdraw(UUID uuid, double amount, @Nullable MinecraftServer server) {
        if (!EconomyManager.isEconomyEnabled()) {
            Shopshelves.LOGGER.warn("Attempted to withdraw funds from {} but EcoBal is not available.", (Object)uuid);
            return false;
        }
        return me.andy.ecobal.api.EconomyManager.silentWithdraw((UUID)uuid, (double)amount);
    }
}

