/*
 * Decompiled with CFR 0.152.
 */
package me.andy.shopshelves.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.andy.shopshelves.Shopshelves;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class MessageFormatter {
    private static final Pattern TOKENIZER_PATTERN = Pattern.compile("(?:&#([0-9a-fA-F]{6}))|(?:&([0-9a-fk-orA-FK-OR]))|(\\{(.*?)\\})|(<action:(\\w+),([^>]*?)>)|([^&{<]+)");

    private static String ensureUrlScheme(String url) {
        if (url == null) {
            return "";
        }
        String trimmedUrl = url.trim();
        if (trimmedUrl.matches("(?i)^(https?|ftp)://.*")) {
            return trimmedUrl;
        }
        return "http://" + trimmedUrl;
    }

    public static List<class_2561> formatLines(List<String> rawLines, @Nullable class_3222 player, @Nullable MinecraftServer server) {
        ArrayList<class_2561> formattedTexts = new ArrayList<class_2561>();
        if (rawLines == null) {
            return formattedTexts;
        }
        for (String rawLine : rawLines) {
            formattedTexts.add((class_2561)MessageFormatter.parseSingleLine(rawLine, player, server, false));
        }
        return formattedTexts;
    }

    public static class_5250 parseSingleLine(String rawLine, @Nullable class_3222 player, @Nullable MinecraftServer server, boolean isParsingForHoverText) {
        class_5250 baseComponent = class_2561.method_43470((String)"");
        if (rawLine == null || rawLine.isEmpty()) {
            return baseComponent;
        }
        Matcher matcher = TOKENIZER_PATTERN.matcher(rawLine);
        class_2583 currentStyle = class_2583.field_24360;
        class_5250 activeInteractiveTarget = null;
        StringBuilder pendingPlainText = new StringBuilder();
        while (matcher.find()) {
            String hexColor = matcher.group(1);
            String legacyFormat = matcher.group(2);
            String hoverContent = matcher.group(4);
            String actionType = matcher.group(6);
            String actionValue = matcher.group(7);
            String plainText = matcher.group(8);
            if (hexColor != null) {
                try {
                    currentStyle = currentStyle.method_27703((class_5251)class_5251.method_27719((String)("#" + hexColor)).getOrThrow());
                }
                catch (Exception e) {
                    Shopshelves.LOGGER.warn("Invalid hex color code: {}", (Object)hexColor, (Object)e);
                }
                activeInteractiveTarget = null;
            } else if (legacyFormat != null) {
                char code = legacyFormat.toLowerCase().charAt(0);
                if (code == 'r') {
                    currentStyle = class_2583.field_24360;
                } else {
                    class_124 mcFormatting = class_124.method_544((char)code);
                    if (mcFormatting != null) {
                        currentStyle = MessageFormatter.applyMinecraftFormatting(currentStyle, mcFormatting);
                    }
                }
                activeInteractiveTarget = null;
            } else if (hoverContent != null) {
                if (isParsingForHoverText) continue;
                if (activeInteractiveTarget != null) {
                    class_5250 parsedHover = MessageFormatter.parseSingleLine(hoverContent, player, server, true);
                    activeInteractiveTarget.method_10862(activeInteractiveTarget.method_10866().method_10949((class_2568)new class_2568.class_10613((class_2561)parsedHover)));
                }
            } else if (actionType != null && actionValue != null) {
                if (isParsingForHoverText) continue;
                if (activeInteractiveTarget != null) {
                    class_2558 ce = MessageFormatter.createClickEvent(actionType, actionValue);
                    if (ce != null) {
                        activeInteractiveTarget.method_10862(activeInteractiveTarget.method_10866().method_10958(ce));
                    }
                    activeInteractiveTarget = null;
                }
            } else if (plainText != null) {
                pendingPlainText.append(plainText);
            }
            if (pendingPlainText.length() <= 0) continue;
            class_5250 segment = class_2561.method_43470((String)pendingPlainText.toString()).method_10862(currentStyle);
            baseComponent.method_10852((class_2561)segment);
            if (!pendingPlainText.toString().trim().isEmpty()) {
                activeInteractiveTarget = segment;
            }
            pendingPlainText.setLength(0);
        }
        return baseComponent;
    }

    private static class_2558 createClickEvent(String actionType, String value) {
        String lowerActionType = actionType.toLowerCase().trim();
        try {
            return switch (lowerActionType) {
                case "run_command" -> new class_2558.class_10609(value);
                case "suggest_command" -> new class_2558.class_10610(value);
                case "open_url" -> new class_2558.class_10608(new URI(MessageFormatter.ensureUrlScheme(value)));
                case "copy_to_clipboard" -> new class_2558.class_10606(value);
                default -> null;
            };
        }
        catch (URISyntaxException e) {
            Shopshelves.LOGGER.warn("Error creating ClickEvent for URL '{}': {}", (Object)value, (Object)e.getMessage());
            return null;
        }
    }

    private static class_2583 applyMinecraftFormatting(class_2583 style, class_124 formatting) {
        if (formatting.method_543()) {
            return style.method_10977(formatting);
        }
        return switch (formatting) {
            case class_124.field_1051 -> style.method_36141(Boolean.valueOf(true));
            case class_124.field_1067 -> style.method_10982(Boolean.valueOf(true));
            case class_124.field_1055 -> style.method_36140(Boolean.valueOf(true));
            case class_124.field_1073 -> style.method_30938(Boolean.valueOf(true));
            case class_124.field_1056 -> style.method_10978(Boolean.valueOf(true));
            default -> style;
        };
    }
}

