/*
 * Decompiled with CFR 0.152.
 */
package me.andy.shopShelvesSpigot;

import java.util.logging.Level;
import me.andy.shopShelvesSpigot.ShopListener;
import me.andy.shopShelvesSpigot.command.ShopshelvesCommand;
import me.andy.shopShelvesSpigot.config.MessageFormattingManager;
import me.andy.shopShelvesSpigot.config.ShopPricing;
import me.andy.shopShelvesSpigot.config.ShopshelvesConfig;
import me.andy.shopShelvesSpigot.util.ShopDataManager;
import me.andy.shopShelvesSpigot.util.TextDisplayManager;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public final class ShopShelvesSpigot
extends JavaPlugin {
    private static ShopShelvesSpigot instance;
    private static Economy economy;
    private boolean initializationSuccessful = false;

    public void onEnable() {
        instance = this;
        try {
            ShopshelvesConfig.load();
            MessageFormattingManager.initialize();
            ShopPricing.load();
            ShopDataManager.get().load();
            this.getServer().getScheduler().runTaskLater((Plugin)this, () -> {
                if (!this.setupEconomy()) {
                    this.getLogger().log(Level.SEVERE, "Vault dependency not found. Economy features will be disabled. (Checked after 100 ticks)");
                }
                TextDisplayManager.updateAllShops(this.getServer());
            }, 100L);
            this.getServer().getPluginManager().registerEvents((Listener)new ShopListener(this), (Plugin)this);
            this.getCommand("shopshelves").setExecutor((CommandExecutor)new ShopshelvesCommand(this));
            this.initializationSuccessful = true;
            this.getLogger().info("ShopShelvesSpigot v" + this.getDescription().getVersion() + " enabled successfully!");
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "ShopShelves failed critical initialization and will be disabled. Check that the plugin has write access to its folder.", e);
        }
    }

    public void onDisable() {
        if (this.initializationSuccessful) {
            TextDisplayManager.cleanupAllDisplays();
            ShopDataManager.get().save();
        }
        this.getLogger().info("ShopShelvesSpigot disabled.");
    }

    public static ShopShelvesSpigot getInstance() {
        return instance;
    }

    public boolean isInitializationSuccessful() {
        return this.initializationSuccessful;
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        economy = (Economy)rsp.getProvider();
        return economy != null;
    }

    public static Economy getEconomy() {
        return economy;
    }

    static {
        economy = null;
    }
}

