/*
 * Decompiled with CFR 0.152.
 */
package me.andy.shopShelvesSpigot.api;

import java.util.Optional;
import java.util.UUID;
import me.andy.shopShelvesSpigot.logic.ShopHelper;
import org.bukkit.block.BlockState;
import org.bukkit.block.Shelf;
import org.jetbrains.annotations.Nullable;

public final class ShopshelvesApi {
    private static final ShopshelvesApi INSTANCE = new ShopshelvesApi();

    private ShopshelvesApi() {
    }

    public static ShopshelvesApi getInstance() {
        return INSTANCE;
    }

    public boolean isShopShelf(@Nullable BlockState blockState) {
        if (!(blockState instanceof Shelf) || !ShopHelper.isShelf(blockState.getType())) {
            return false;
        }
        return ShopHelper.getShopMode(blockState) != ShopHelper.ShopMode.NONE;
    }

    public Optional<ShopHelper.ShopMode> getShopMode(@Nullable BlockState blockState) {
        if (blockState != null && this.isShopShelf(blockState)) {
            return Optional.of(ShopHelper.getShopMode(blockState));
        }
        return Optional.empty();
    }

    public Optional<UUID> getShopOwner(@Nullable BlockState blockState) {
        if (blockState != null && this.isShopShelf(blockState)) {
            return ShopHelper.getOwner(blockState);
        }
        return Optional.empty();
    }
}

