/*
 * Decompiled with CFR 0.152.
 */
package me.andy.shopShelvesSpigot.config;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.stream.Collectors;
import me.andy.shopShelvesSpigot.ShopShelvesSpigot;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MusicInstrumentMeta;
import org.bukkit.inventory.meta.OminousBottleMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SuspiciousStewMeta;
import org.bukkit.potion.PotionType;

public class ShopPricing {
    private static final String FILE_NAME = "pricing.yml";
    private static Map<String, PriceEntry> prices = new HashMap<String, PriceEntry>();
    private static File CONFIG_FILE;
    private static final PriceEntry P_DIRT;
    private static final PriceEntry P_STONE;
    private static final PriceEntry P_LOG;
    private static final PriceEntry P_IRON_INGOT;
    private static final PriceEntry P_COPPER_INGOT;
    private static final PriceEntry P_GOLD_INGOT;
    private static final PriceEntry P_DIAMOND;
    private static final PriceEntry P_EMERALD;
    private static final PriceEntry P_NETHERITE;
    private static final PriceEntry P_UTILITY_LOW;
    private static final PriceEntry P_MECH_MID;
    private static final PriceEntry P_FARMABLE_NONE;
    private static final PriceEntry P_UNTRADEABLE;
    private static final PriceEntry P_GEAR_DIAMOND;

    public static void load() {
        CONFIG_FILE = new File(ShopShelvesSpigot.getInstance().getDataFolder(), FILE_NAME);
        if (!CONFIG_FILE.exists()) {
            try {
                ShopShelvesSpigot.getInstance().getDataFolder().mkdirs();
                CONFIG_FILE.createNewFile();
                ShopPricing.createDefaultConfig();
                ShopPricing.save();
                ShopShelvesSpigot.getInstance().getLogger().info("Generated expanded default pricing.yml.");
                return;
            }
            catch (IOException e) {
                ShopShelvesSpigot.getInstance().getLogger().log(Level.SEVERE, "Could not create default pricing.yml: " + e.getMessage());
                throw new RuntimeException("Failed to generate ShopPricing.yml", e);
            }
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)CONFIG_FILE);
        prices.clear();
        ConfigurationSection pricesSection = config.getConfigurationSection("prices");
        if (pricesSection != null) {
            for (String key : pricesSection.getKeys(false)) {
                ConfigurationSection entrySection = pricesSection.getConfigurationSection(key);
                if (entrySection == null) continue;
                int amount = entrySection.getInt("amount", 1);
                Double sellPrice = entrySection.isSet("sell_price") ? Double.valueOf(entrySection.getDouble("sell_price")) : null;
                Double buyPrice = entrySection.isSet("buy_price") ? Double.valueOf(entrySection.getDouble("buy_price")) : null;
                prices.put(key, new PriceEntry(amount, sellPrice, buyPrice));
            }
        }
        ShopShelvesSpigot.getInstance().getLogger().info("ShopShelves pricing loaded successfully.");
    }

    public static void save() {
        if (CONFIG_FILE == null) {
            return;
        }
        try {
            ShopShelvesSpigot.getInstance().getDataFolder().mkdirs();
            YamlConfiguration config = new YamlConfiguration();
            ConfigurationSection pricesSection = config.createSection("prices");
            prices.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
                String key = (String)entry.getKey();
                PriceEntry priceEntry = (PriceEntry)entry.getValue();
                ConfigurationSection entrySection = pricesSection.createSection(key);
                entrySection.set("amount", (Object)priceEntry.amount());
                if (priceEntry.sellPrice() != null) {
                    entrySection.set("sell_price", (Object)priceEntry.sellPrice());
                }
                if (priceEntry.buyPrice() != null) {
                    entrySection.set("buy_price", (Object)priceEntry.buyPrice());
                }
            });
            config.save(CONFIG_FILE);
        }
        catch (IOException e) {
            ShopShelvesSpigot.getInstance().getLogger().severe("Failed to save ShopShelves pricing.yml");
            e.printStackTrace();
        }
    }

    private static void createDefaultConfig() {
        prices.clear();
        BiConsumer<Material, PriceEntry> applyPrice = (material, entry) -> {
            if (material != Material.AIR) {
                prices.put(material.getKey().toString(), (PriceEntry)entry);
            }
        };
        for (Material material2 : Material.values()) {
            if (material2.isLegacy()) continue;
            String id = material2.getKey().toString();
            applyPrice.accept(material2, P_STONE);
            if (material2 == Material.AIR || material2 == Material.BEDROCK || id.contains("portal") || id.contains("fire") || id.contains("jigsaw") || id.contains("structure_") || id.contains("command_block") || id.contains("moving_piston") || id.contains("barrier") || id.contains("light") || material2 == Material.DRAGON_EGG) {
                applyPrice.accept(material2, P_UNTRADEABLE);
                continue;
            }
            if (id.contains("ore") || id.contains("raw_") || id.contains("ingot") || id.contains("nugget") || id.contains("scrap") || id.contains("shard")) {
                if (id.contains("iron")) {
                    applyPrice.accept(material2, P_IRON_INGOT);
                    continue;
                }
                if (id.contains("copper")) {
                    applyPrice.accept(material2, P_COPPER_INGOT);
                    continue;
                }
                if (id.contains("gold")) {
                    applyPrice.accept(material2, P_GOLD_INGOT);
                    continue;
                }
                if (id.contains("diamond")) {
                    applyPrice.accept(material2, P_DIAMOND);
                    continue;
                }
                if (id.contains("emerald")) {
                    applyPrice.accept(material2, P_EMERALD);
                    continue;
                }
                if (id.contains("netherite")) {
                    applyPrice.accept(material2, P_NETHERITE);
                    continue;
                }
                if (id.contains("coal")) {
                    applyPrice.accept(material2, new PriceEntry(1, 2.5, 8.0));
                    continue;
                }
                if (id.contains("lapis")) {
                    applyPrice.accept(material2, new PriceEntry(1, 1.5, 5.0));
                    continue;
                }
                if (!id.contains("redstone")) continue;
                applyPrice.accept(material2, new PriceEntry(1, 1.0, 3.0));
                continue;
            }
            if (id.contains("dirt") || id.contains("sand") || id.contains("gravel") || id.contains("mud") || id.contains("clay")) {
                prices.put(id, P_DIRT);
                continue;
            }
            if (id.contains("_log") || id.contains("_wood") || id.contains("bamboo_block") || id.contains("stem") || id.contains("hyphae")) {
                prices.put(id, P_LOG);
                continue;
            }
            if (id.contains("_planks")) {
                prices.put(id, new PriceEntry(4, null, ShopPricing.P_LOG.buyPrice));
                continue;
            }
            if (id.contains("piston") || id.contains("dispenser") || id.contains("dropper") || id.contains("observer") || id.contains("comparator") || id.contains("repeater")) {
                prices.put(id, P_MECH_MID);
                continue;
            }
            if (id.contains("furnace") || id.contains("smoker") || id.contains("blast_furnace") || id.contains("crafting_table") || id.contains("barrel") || id.contains("loom") || id.contains("grindstone")) {
                prices.put(id, P_UTILITY_LOW);
                continue;
            }
            if (id.contains("_sword") || id.contains("_pickaxe") || id.contains("_axe") || id.contains("_hoe") || id.contains("_shovel") || id.contains("boots") || id.contains("helmet") || id.contains("chestplate") || id.contains("leggings")) {
                if (id.contains("diamond")) {
                    prices.put(id, P_GEAR_DIAMOND);
                    continue;
                }
                if (id.contains("netherite")) {
                    prices.put(id, new PriceEntry(1, ShopPricing.P_NETHERITE.sellPrice * 1.5, ShopPricing.P_NETHERITE.buyPrice * 1.5));
                    continue;
                }
                if (id.contains("iron")) {
                    prices.put(id, new PriceEntry(1, ShopPricing.P_IRON_INGOT.sellPrice * 4.0, ShopPricing.P_IRON_INGOT.buyPrice * 4.0));
                    continue;
                }
                if (id.contains("copper")) {
                    prices.put(id, new PriceEntry(1, ShopPricing.P_COPPER_INGOT.sellPrice * 4.0, ShopPricing.P_COPPER_INGOT.buyPrice * 4.0));
                    continue;
                }
                if (!id.contains("golden")) continue;
                prices.put(id, new PriceEntry(1, ShopPricing.P_GOLD_INGOT.sellPrice * 3.0, ShopPricing.P_GOLD_INGOT.buyPrice * 3.0));
                continue;
            }
            if (id.contains("copper_golem_statue")) {
                prices.put(id, new PriceEntry(1, 35.0, 120.0));
                continue;
            }
            if (id.contains("copper_chest")) {
                prices.put(id, new PriceEntry(1, 40.0, 130.0));
                continue;
            }
            if (id.contains("copper_bulb") || id.contains("copper_torch") || id.contains("copper_lantern") || id.contains("copper_chain") || id.contains("copper_bars") || id.contains("copper_grate") || id.contains("lightning_rod")) {
                prices.put(id, new PriceEntry(1, 2.0, 8.0));
                continue;
            }
            if (id.contains("seeds") || id.contains("wheat") || id.contains("carrot") || id.contains("melon") || id.contains("leaves") || id.contains("grass") || id.contains("sugar_cane") || id.contains("bamboo") || id.contains("string") || id.contains("feather") || id.contains("rotten_flesh") || id.contains("spider_eye")) {
                prices.put(id, P_FARMABLE_NONE);
                continue;
            }
            if (id.contains("end_rod") || id.contains("chorus_fruit") || id.contains("shulker_shell") || id.contains("totem_of_undying") || id.contains("ender_pearl") || id.contains("blaze_rod") || id.contains("ghast_tear")) {
                prices.put(id, new PriceEntry(1, 50.0, 150.0));
                continue;
            }
            if (id.contains("_slab") || id.contains("_stairs") || id.contains("_wall") || id.contains("_fence") || id.contains("_door") || id.contains("_trapdoor")) {
                prices.put(id, new PriceEntry(1, ShopPricing.P_STONE.sellPrice * 0.75, ShopPricing.P_STONE.buyPrice * 0.75));
                continue;
            }
            if (!id.contains("_sign") && !id.contains("_head") && !id.contains("_skull") && !id.contains("_pot") && !id.contains("potted") && !id.contains("candle") && !id.contains("banner")) continue;
            prices.put(id, P_UTILITY_LOW);
        }
    }

    public static String getVariationId(ItemStack stack) {
        if (stack == null || stack.getType() == Material.AIR) {
            return "minecraft:air";
        }
        String baseId = stack.getType().getKey().toString();
        ItemMeta meta = stack.getItemMeta();
        if (meta == null) {
            return baseId;
        }
        if (stack.getType() == Material.OMINOUS_BOTTLE && meta instanceof OminousBottleMeta) {
            OminousBottleMeta ominousMeta = (OminousBottleMeta)meta;
            if (ominousMeta.hasAmplifier()) {
                int level = ominousMeta.getAmplifier() + 1;
                return baseId + ":level" + level;
            }
            return baseId + ":level1";
        }
        if (stack.getType() == Material.SUSPICIOUS_STEW && meta instanceof SuspiciousStewMeta) {
            SuspiciousStewMeta stewMeta = (SuspiciousStewMeta)meta;
            if (!stewMeta.getCustomEffects().isEmpty()) {
                return stewMeta.getCustomEffects().stream().map(effect -> effect.getType().getName().toLowerCase(Locale.ROOT) + effect.getDuration()).sorted().collect(Collectors.joining("_", baseId + ":", ""));
            }
            return baseId + ":no_effects";
        }
        if (stack.getType() == Material.GOAT_HORN && meta instanceof MusicInstrumentMeta) {
            MusicInstrumentMeta instrumentMeta = (MusicInstrumentMeta)meta;
            if (instrumentMeta.getInstrument() != null) {
                return instrumentMeta.getInstrument().getKey().toString();
            }
            return baseId + ":default";
        }
        if (meta instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta bookMeta = (EnchantmentStorageMeta)meta;
            if (!bookMeta.hasStoredEnchants()) {
                return baseId + ":unenchanted";
            }
            return bookMeta.getStoredEnchants().entrySet().stream().findFirst().map(entry -> {
                String enchantId = ((Enchantment)entry.getKey()).getKey().getKey();
                int level = (Integer)entry.getValue();
                return baseId + ":" + enchantId + level;
            }).orElse(baseId + ":multiple_enchants");
        }
        if (meta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)meta;
            PotionType type = potionMeta.getBasePotionType();
            String suffix = type.name().toLowerCase(Locale.ROOT);
            return baseId + ":" + suffix;
        }
        return baseId;
    }

    public static Optional<PriceEntry> getPriceEntry(ItemStack stack) {
        String pricingKey = ShopPricing.getVariationId(stack);
        return Optional.ofNullable(prices.get(pricingKey));
    }

    public static Optional<PriceEntry> getPriceEntry(Material material) {
        return Optional.ofNullable(prices.get(material.getKey().toString()));
    }

    public static void setPrice(ItemStack stack, int amount, Double sellPrice, Double buyPrice) {
        String pricingKey = ShopPricing.getVariationId(stack);
        prices.put(pricingKey, new PriceEntry(amount, sellPrice, buyPrice));
    }

    static {
        P_DIRT = new PriceEntry(1, 0.25, 1.0);
        P_STONE = new PriceEntry(1, 1.0, 4.0);
        P_LOG = new PriceEntry(1, 1.0, 3.0);
        P_IRON_INGOT = new PriceEntry(1, 6.0, 20.0);
        P_COPPER_INGOT = new PriceEntry(1, 4.0, 12.0);
        P_GOLD_INGOT = new PriceEntry(1, 15.0, 50.0);
        P_DIAMOND = new PriceEntry(1, 60.0, 200.0);
        P_EMERALD = new PriceEntry(1, 80.0, 250.0);
        P_NETHERITE = new PriceEntry(1, 540.0, 1800.0);
        P_UTILITY_LOW = new PriceEntry(1, 1.0, 5.0);
        P_MECH_MID = new PriceEntry(1, 4.0, 15.0);
        P_FARMABLE_NONE = new PriceEntry(1, 0.0, 1.0);
        P_UNTRADEABLE = new PriceEntry(1, null, null);
        P_GEAR_DIAMOND = new PriceEntry(1, ShopPricing.P_DIAMOND.sellPrice * 4.0, ShopPricing.P_DIAMOND.buyPrice * 4.0);
    }

    public static class PriceEntry {
        public final Double sellPrice;
        public final Double buyPrice;
        public final int amount;

        public PriceEntry(int amount, Double sellPrice, Double buyPrice) {
            this.amount = amount;
            this.sellPrice = sellPrice;
            this.buyPrice = buyPrice;
        }

        public Double sellPrice() {
            return this.sellPrice;
        }

        public Double buyPrice() {
            return this.buyPrice;
        }

        public int amount() {
            return this.amount;
        }
    }
}

