/*
 * Decompiled with CFR 0.152.
 */
package me.andy.shopShelvesSpigot.config;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import me.andy.shopShelvesSpigot.ShopShelvesSpigot;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ShopshelvesConfig {
    private static ShopshelvesConfig instance;
    private static FileConfiguration config;
    private static File configFile;
    public static final float BASE_ENTITY_RENDER_DISTANCE = 96.0f;
    private MessageDeliveryMode messageDeliveryMode = MessageDeliveryMode.ACTIONBAR;
    private int textDisplayRenderDistanceBlocks = 16;
    private int priceDisplayRenderDistanceBlocks = 5;
    private PriceDisplayMode priceDisplayMode = PriceDisplayMode.TRIPLEPRICE;
    private boolean roundOffDisplayPrices = true;
    private int mainDisplayScale = 5;
    private int amountDisplayScale = 5;
    private int priceDisplayScale = 5;
    private int defaultPlayerShelfLimit = 2;

    private ShopshelvesConfig() {
    }

    public static void load() {
        ShopShelvesSpigot plugin;
        if (instance == null) {
            instance = new ShopshelvesConfig();
        }
        if (!(configFile = new File((plugin = ShopShelvesSpigot.getInstance()).getDataFolder(), "config.yml")).exists()) {
            try {
                plugin.getDataFolder().mkdirs();
                configFile.createNewFile();
                config = new YamlConfiguration();
                config.set("message_delivery_mode", (Object)ShopshelvesConfig.instance.messageDeliveryMode.name());
                config.set("text_display_render_distance_blocks", (Object)ShopshelvesConfig.instance.textDisplayRenderDistanceBlocks);
                config.set("price_display_render_distance_blocks", (Object)ShopshelvesConfig.instance.priceDisplayRenderDistanceBlocks);
                config.set("price_display_mode", (Object)ShopshelvesConfig.instance.priceDisplayMode.name());
                config.set("round_off_display_prices", (Object)ShopshelvesConfig.instance.roundOffDisplayPrices);
                config.set("default_player_shelf_limit", (Object)ShopshelvesConfig.instance.defaultPlayerShelfLimit);
                config.set("main_display_scale", (Object)ShopshelvesConfig.instance.mainDisplayScale);
                config.set("amount_display_scale", (Object)ShopshelvesConfig.instance.amountDisplayScale);
                config.set("price_display_scale", (Object)ShopshelvesConfig.instance.priceDisplayScale);
                config.save(configFile);
                plugin.getLogger().info("Generated default config.yml.");
            }
            catch (IOException e) {
                plugin.getLogger().log(Level.SEVERE, "Could not create default config.yml: " + e.getMessage());
                throw new RuntimeException("Failed to generate ShopshelvesConfig.yml", e);
            }
        }
        config = YamlConfiguration.loadConfiguration((File)configFile);
        ShopshelvesConfig.instance.messageDeliveryMode = ShopshelvesConfig.getEnum(MessageDeliveryMode.class, "message_delivery_mode", MessageDeliveryMode.ACTIONBAR);
        ShopshelvesConfig.instance.textDisplayRenderDistanceBlocks = config.getInt("text_display_render_distance_blocks", 16);
        ShopshelvesConfig.instance.priceDisplayRenderDistanceBlocks = config.getInt("price_display_render_distance_blocks", 5);
        ShopshelvesConfig.instance.priceDisplayMode = ShopshelvesConfig.getEnum(PriceDisplayMode.class, "price_display_mode", PriceDisplayMode.TRIPLEPRICE);
        ShopshelvesConfig.instance.roundOffDisplayPrices = config.getBoolean("round_off_display_prices", true);
        ShopshelvesConfig.instance.defaultPlayerShelfLimit = config.getInt("default_player_shelf_limit", 2);
        ShopshelvesConfig.instance.mainDisplayScale = ShopshelvesConfig.clampScale(config.getInt("main_display_scale", 5));
        ShopshelvesConfig.instance.amountDisplayScale = ShopshelvesConfig.clampScale(config.getInt("amount_display_scale", 5));
        ShopshelvesConfig.instance.priceDisplayScale = ShopshelvesConfig.clampScale(config.getInt("price_display_scale", 5));
    }

    private static <T extends Enum<T>> T getEnum(Class<T> enumClass, String path, T defaultValue) {
        String value = config.getString(path);
        try {
            if (value != null) {
                return Enum.valueOf(enumClass, value.toUpperCase());
            }
        }
        catch (IllegalArgumentException ignored) {
            ShopShelvesSpigot.getInstance().getLogger().warning("Invalid value for " + path + ": " + value + ". Using default: " + defaultValue.name());
        }
        return defaultValue;
    }

    public static void save() {
        try {
            config.set("message_delivery_mode", (Object)ShopshelvesConfig.instance.messageDeliveryMode.name());
            config.set("price_display_mode", (Object)ShopshelvesConfig.instance.priceDisplayMode.name());
            config.save(configFile);
        }
        catch (IOException e) {
            ShopShelvesSpigot.getInstance().getLogger().severe("Could not save config.yml: " + e.getMessage());
        }
    }

    private static int clampScale(int value) {
        return Math.max(1, Math.min(10, value));
    }

    public static ShopshelvesConfig get() {
        if (instance == null) {
            ShopshelvesConfig.load();
        }
        return instance;
    }

    public MessageDeliveryMode getMessageDeliveryMode() {
        return this.messageDeliveryMode;
    }

    public void setMessageDeliveryMode(MessageDeliveryMode mode) {
        this.messageDeliveryMode = mode;
    }

    public int getTextDisplayRenderDistanceBlocks() {
        return this.textDisplayRenderDistanceBlocks;
    }

    public int getPriceDisplayRenderDistanceBlocks() {
        return this.priceDisplayRenderDistanceBlocks;
    }

    public PriceDisplayMode getPriceDisplayMode() {
        return this.priceDisplayMode;
    }

    public void setPriceDisplayMode(PriceDisplayMode mode) {
        this.priceDisplayMode = mode;
    }

    public boolean shouldRoundOffDisplayPrices() {
        return this.roundOffDisplayPrices;
    }

    public int getMainDisplayScale() {
        return this.mainDisplayScale;
    }

    public int getAmountDisplayScale() {
        return this.amountDisplayScale;
    }

    public int getPriceDisplayScale() {
        return this.priceDisplayScale;
    }

    public int getDefaultPlayerShelfLimit() {
        return this.defaultPlayerShelfLimit;
    }

    public static enum MessageDeliveryMode {
        CHAT,
        ACTIONBAR,
        BOTH;

    }

    public static enum PriceDisplayMode {
        SINGLEPRICE,
        TRIPLEPRICE;

    }
}

