/*
 * Decompiled with CFR 0.152.
 */
package me.andy.shopShelvesSpigot.logic;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import me.andy.shopShelvesSpigot.ShopListener;
import me.andy.shopShelvesSpigot.ShopShelvesSpigot;
import me.andy.shopShelvesSpigot.config.MessageFormattingManager;
import me.andy.shopShelvesSpigot.config.ShopPricing;
import me.andy.shopShelvesSpigot.config.ShopshelvesConfig;
import me.andy.shopShelvesSpigot.util.MessageUtil;
import me.andy.shopShelvesSpigot.util.ShopDataManager;
import me.andy.shopShelvesSpigot.util.ShopEconomy;
import me.andy.shopShelvesSpigot.util.ShopUtility;
import me.andy.shopShelvesSpigot.util.TextDisplayManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.block.Shelf;
import org.bukkit.block.TileState;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class ShopHelper {
    public static final NamespacedKey SHOPSHELF_TAG_KEY = new NamespacedKey((Plugin)ShopShelvesSpigot.getInstance(), "is_shopshelf");
    private static final NamespacedKey PRICE_STAMP_PDC_KEY = new NamespacedKey((Plugin)ShopShelvesSpigot.getInstance(), "price_stamp");
    private static final NamespacedKey SHOP_MODE_KEY = new NamespacedKey((Plugin)ShopShelvesSpigot.getInstance(), "shop_mode");
    private static final NamespacedKey OWNER_UUID_KEY = new NamespacedKey((Plugin)ShopShelvesSpigot.getInstance(), "owner_uuid");
    private static final NamespacedKey OWNER_NAME_KEY = new NamespacedKey((Plugin)ShopShelvesSpigot.getInstance(), "owner_name");
    private static final NamespacedKey LINKED_POS_KEY = new NamespacedKey((Plugin)ShopShelvesSpigot.getInstance(), "linked_pos");
    private static final NamespacedKey PRICE_SLOT_PREFIX = new NamespacedKey((Plugin)ShopShelvesSpigot.getInstance(), "price_slot_");

    public static boolean isShelf(Material material) {
        return material.name().endsWith("_SHELF");
    }

    public static Optional<PersistentDataContainer> getPDC(BlockState state) {
        if (state instanceof TileState) {
            TileState tileState = (TileState)state;
            return Optional.of(tileState.getPersistentDataContainer());
        }
        return Optional.empty();
    }

    public static ShopMode getShopMode(BlockState state) {
        return ShopHelper.getPDC(state).flatMap(pdc -> Optional.ofNullable((String)pdc.get(SHOP_MODE_KEY, PersistentDataType.STRING))).flatMap(s -> {
            try {
                return Optional.of(ShopMode.valueOf(s));
            }
            catch (IllegalArgumentException e) {
                return Optional.of(ShopMode.NONE);
            }
        }).orElse(ShopMode.NONE);
    }

    public static void setShopMode(BlockState state, ShopMode mode) {
        ShopHelper.getPDC(state).ifPresent(pdc -> {
            pdc.set(SHOP_MODE_KEY, PersistentDataType.STRING, (Object)mode.name());
            if (mode != ShopMode.NONE) {
                pdc.set(SHOPSHELF_TAG_KEY, PersistentDataType.BYTE, (Object)1);
                ShopListener.setShelfSideChainSafely(state, true);
            } else {
                pdc.remove(SHOPSHELF_TAG_KEY);
                ShopListener.setShelfSideChainSafely(state, false);
            }
        });
    }

    public static boolean hasShopData(BlockState state) {
        if (ShopHelper.getShopMode(state) != ShopMode.NONE) {
            return true;
        }
        if (ShopHelper.getOwner(state).isPresent()) {
            return true;
        }
        if (ShopHelper.getLinkedContainerPos(state).isPresent()) {
            return true;
        }
        for (int i = 0; i < 3; ++i) {
            if (!ShopHelper.getCustomPriceData(state, i).isPresent()) continue;
            return true;
        }
        return false;
    }

    public static Optional<UUID> getOwner(BlockState state) {
        if (ShopHelper.getShopMode(state) != ShopMode.PLAYERSHELF) {
            return Optional.empty();
        }
        return ShopHelper.getPDC(state).flatMap(pdc -> Optional.ofNullable((String)pdc.get(OWNER_UUID_KEY, PersistentDataType.STRING))).flatMap(s -> {
            try {
                return Optional.of(UUID.fromString(s));
            }
            catch (IllegalArgumentException e) {
                return Optional.empty();
            }
        });
    }

    public static void setOwner(BlockState state, @Nullable UUID owner, @Nullable String name) {
        ShopHelper.getPDC(state).ifPresent(pdc -> {
            if (owner == null) {
                pdc.remove(OWNER_UUID_KEY);
                pdc.remove(OWNER_NAME_KEY);
            } else {
                pdc.set(OWNER_UUID_KEY, PersistentDataType.STRING, (Object)owner.toString());
                pdc.set(OWNER_NAME_KEY, PersistentDataType.STRING, (Object)(name != null ? name : "Unknown"));
            }
        });
    }

    public static Optional<String> getOwnerName(BlockState state) {
        if (ShopHelper.getShopMode(state) != ShopMode.PLAYERSHELF) {
            return Optional.empty();
        }
        return ShopHelper.getPDC(state).flatMap(pdc -> Optional.ofNullable((String)pdc.get(OWNER_NAME_KEY, PersistentDataType.STRING))).filter(name -> !name.equals("Unknown"));
    }

    public static Optional<Location> getLinkedContainerPos(BlockState state) {
        return ShopHelper.getPDC(state).flatMap(pdc -> Optional.ofNullable((String)pdc.get(LINKED_POS_KEY, PersistentDataType.STRING))).flatMap(s -> ShopDataManager.get().keyToLocation((String)s));
    }

    public static void setLinkedContainerPos(BlockState state, Location pos) {
        ShopHelper.getPDC(state).ifPresent(pdc -> {
            if (pos == null) {
                pdc.remove(LINKED_POS_KEY);
            } else {
                pdc.set(LINKED_POS_KEY, PersistentDataType.STRING, (Object)ShopDataManager.get().locationToKey(pos));
            }
        });
    }

    public static Optional<Inventory> getLinkedContainerInventory(BlockState shelfState) {
        return ShopHelper.getLinkedContainerPos(shelfState).map(Location::getBlock).map(Block::getState).filter(s -> s instanceof Container).map(s -> ((Container)s).getInventory());
    }

    public static Optional<Map<String, String>> getCustomPriceData(BlockState shelfState, int slot) {
        boolean isPlayerShelfMode = ShopHelper.getShopMode(shelfState) == ShopMode.PLAYERSHELF;
        int priceSlot = isPlayerShelfMode ? 0 : slot;
        NamespacedKey slotKey = new NamespacedKey((Plugin)ShopShelvesSpigot.getInstance(), PRICE_SLOT_PREFIX.getKey() + priceSlot);
        return ShopHelper.getPDC(shelfState).flatMap(pdc -> Optional.ofNullable((String)pdc.get(slotKey, PersistentDataType.STRING))).map(ShopUtility::deserializeStamp);
    }

    public static void setCustomPriceData(BlockState shelfState, int slot, @Nullable Map<String, String> data) {
        NamespacedKey slotKey = new NamespacedKey((Plugin)ShopShelvesSpigot.getInstance(), PRICE_SLOT_PREFIX.getKey() + slot);
        ShopHelper.getPDC(shelfState).ifPresent(pdc -> {
            if (data == null || data.isEmpty()) {
                pdc.remove(slotKey);
            } else {
                pdc.set(slotKey, PersistentDataType.STRING, (Object)ShopUtility.serializeStamp(data));
            }
            shelfState.update(true);
            Bukkit.getScheduler().runTask((Plugin)ShopShelvesSpigot.getInstance(), () -> TextDisplayManager.updateShopDisplay(shelfState.getWorld(), shelfState.getLocation(), shelfState));
        });
    }

    public static Optional<Double> getUnitPrice(BlockState blockState, int slot, boolean isBuy) {
        ItemStack shelfStack;
        ShopMode mode = ShopHelper.getShopMode(blockState);
        if (blockState instanceof Shelf) {
            Shelf shelf = (Shelf)blockState;
            v0 = shelf.getInventory().getItem(slot);
        } else {
            v0 = shelfStack = null;
        }
        if (shelfStack == null || shelfStack.getType().isAir()) {
            return Optional.empty();
        }
        Optional<Map<String, String>> customPriceDataOpt = ShopHelper.getCustomPriceData(blockState, slot);
        if (customPriceDataOpt.isPresent()) {
            String priceKey;
            Map<String, String> customPriceData = customPriceDataOpt.get();
            String string = priceKey = isBuy ? "buy" : "sell";
            if (customPriceData.containsKey(priceKey)) {
                try {
                    double basePrice = Double.parseDouble(customPriceData.get(priceKey));
                    int customAmount = Integer.parseInt(customPriceData.getOrDefault("amount", "1"));
                    if (customAmount <= 0) {
                        return Optional.of(0.0);
                    }
                    return Optional.of(basePrice / (double)customAmount);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (mode == ShopMode.PLAYERSHELF) {
                return Optional.empty();
            }
        }
        return ShopPricing.getPriceEntry(shelfStack).flatMap(configEntry -> {
            Double basePrice;
            Double d = basePrice = isBuy ? configEntry.buyPrice() : configEntry.sellPrice();
            if (basePrice == null) {
                return Optional.empty();
            }
            int configBaseAmount = configEntry.amount();
            if (configBaseAmount <= 0) {
                return Optional.of(0.0);
            }
            return Optional.of(basePrice / (double)configBaseAmount);
        });
    }

    public static Optional<Double> getPrice(BlockState blockState, int slot, ShopMode mode, boolean isBuy) {
        ItemStack shelfStack;
        if (blockState instanceof Shelf) {
            Shelf shelf = (Shelf)blockState;
            v0 = shelf.getInventory().getItem(slot);
        } else {
            v0 = shelfStack = null;
        }
        if (shelfStack == null || shelfStack.getType().isAir()) {
            return Optional.empty();
        }
        return ShopHelper.getUnitPrice(blockState, slot, isBuy).map(unitPrice -> unitPrice * (double)shelfStack.getAmount());
    }

    public static void handleAdminSetup(Player player, Block clickedBlock, BlockState blockState, ItemStack heldStack, EquipmentSlot hand, int slot) {
        if (!(blockState instanceof Shelf)) {
            MessageUtil.sendError((CommandSender)player, "error_internal_shelf_state");
            return;
        }
        Shelf shelfState = (Shelf)blockState;
        if (player.isSneaking() || slot == -1) {
            ShopMode nextMode;
            ShopMode currentMode = ShopHelper.getShopMode(blockState);
            if (currentMode == ShopMode.PLAYERSHELF) {
                ShopHelper.setShopMode(blockState, ShopMode.NONE);
                ShopHelper.setOwner(blockState, null, null);
                ShopHelper.getLinkedContainerPos(blockState).ifPresent(containerPos -> ShopDataManager.get().removeLink(ShopUtility.getContainerLocations(containerPos.getBlock())));
                ShopHelper.setLinkedContainerPos(blockState, null);
                nextMode = ShopMode.NONE;
            } else {
                nextMode = switch (currentMode.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> ShopMode.BUY;
                    case 1 -> ShopMode.SELL;
                    case 2 -> ShopMode.DUAL;
                    case 3 -> ShopMode.NONE;
                    case 4 -> ShopMode.NONE;
                };
                ShopHelper.setShopMode(blockState, nextMode);
                if (currentMode == ShopMode.PLAYERSHELF || nextMode == ShopMode.NONE) {
                    ShopHelper.setOwner(blockState, null, null);
                }
            }
            blockState.update(true);
            MessageUtil.sendPlayerMessage(player, "shop_mode_set", Map.of("%mode%", nextMode.name()));
            player.getWorld().playSound(clickedBlock.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.2f);
            TextDisplayManager.updateShopDisplay(clickedBlock.getWorld(), clickedBlock.getLocation(), blockState);
            return;
        }
        if (heldStack != null && !heldStack.getType().isAir()) {
            PersistentDataContainer pdc;
            String priceStampJson;
            ItemMeta meta = heldStack.getItemMeta();
            if (meta != null && (priceStampJson = (String)(pdc = meta.getPersistentDataContainer()).get(PRICE_STAMP_PDC_KEY, PersistentDataType.STRING)) != null) {
                ShopHelper.setCustomPriceData(blockState, slot, ShopUtility.deserializeStamp(priceStampJson));
                pdc.remove(PRICE_STAMP_PDC_KEY);
                heldStack.setItemMeta(meta);
                ItemStack displayItem = heldStack.clone();
                shelfState.getInventory().setItem(slot, displayItem);
                if (ShopHelper.getShopMode(blockState) == ShopMode.NONE) {
                    ShopHelper.setShopMode(blockState, ShopMode.BUY);
                    blockState.update(true);
                }
                MessageUtil.sendPlayerMessage(player, "shop_slot_set", Map.of("%slot%", String.valueOf(slot + 1), "%item%", displayItem.getType().name(), "%count%", String.valueOf(displayItem.getAmount())));
                player.getWorld().playSound(clickedBlock.getLocation(), Sound.BLOCK_CHISELED_BOOKSHELF_INSERT, 1.0f, 1.0f);
                return;
            }
            if (slot != -1) {
                ShopHelper.setCustomPriceData(blockState, slot, null);
            }
        } else {
            shelfState.getInventory().setItem(slot, null);
            ShopHelper.setCustomPriceData(blockState, slot, null);
            blockState.update(true);
            MessageUtil.sendPlayerMessage(player, "shop_slot_cleared", Map.of("%slot%", String.valueOf(slot + 1)));
            player.getWorld().playSound(clickedBlock.getLocation(), Sound.BLOCK_CHISELED_BOOKSHELF_PICKUP, 1.0f, 1.0f);
            if (shelfState.getInventory().isEmpty() && ShopHelper.getLinkedContainerPos(blockState).isEmpty()) {
                ShopHelper.setShopMode(blockState, ShopMode.NONE);
                ShopHelper.setOwner(blockState, null, null);
                ShopHelper.setLinkedContainerPos(blockState, null);
                blockState.update(true);
            }
        }
    }

    public static boolean applyAndCleanPlayerShopPriceStamp(BlockState blockState, ItemStack heldStack, Player player) {
        Shelf shelf;
        ItemStack referenceStack;
        if (heldStack == null || heldStack.getType().isAir()) {
            return false;
        }
        if (ShopHelper.getShopMode(blockState) != ShopMode.PLAYERSHELF) {
            return false;
        }
        if (blockState instanceof Shelf && (referenceStack = (shelf = (Shelf)blockState).getInventory().getItem(0)) != null && !referenceStack.getType().isAir() && !ShopHelper.isSimilarIgnoringPriceStamp(heldStack, referenceStack)) {
            MessageUtil.sendError((CommandSender)player, "error_item_type_mismatch", Map.of("%item%", referenceStack.getType().name()));
            return true;
        }
        ItemMeta meta = heldStack.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        String priceStampJson = (String)pdc.get(PRICE_STAMP_PDC_KEY, PersistentDataType.STRING);
        if (priceStampJson == null) {
            return false;
        }
        Map<String, String> stamp = ShopUtility.deserializeStamp(priceStampJson);
        Map existingPrices = ShopHelper.getCustomPriceData(blockState, 0).orElse(new HashMap());
        stamp.forEach((key, valueStr) -> {
            block9: {
                if (key.equals("sell") || key.equals("buy")) {
                    try {
                        double price = Double.parseDouble(valueStr);
                        if (price >= 0.0) {
                            existingPrices.put(key, valueStr);
                            break block9;
                        }
                        existingPrices.remove(key);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (key.equals("amount")) {
                    try {
                        if (Integer.parseInt(valueStr) > 0) {
                            existingPrices.put("amount", valueStr);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        });
        if (!existingPrices.containsKey("amount")) {
            existingPrices.put("amount", "1");
        }
        ShopHelper.setCustomPriceData(blockState, 0, existingPrices.isEmpty() ? null : existingPrices);
        pdc.remove(PRICE_STAMP_PDC_KEY);
        heldStack.setItemMeta(meta);
        MessageUtil.sendPlayerMessage(player, "playershop_price_set", Collections.emptyMap());
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.5f, 1.5f);
        return true;
    }

    public static void handleBuyInteraction(Player buyer, BlockState blockState, int slot, boolean isShiftClick) {
        ItemMeta itemToGiveMeta;
        int amountToBuy;
        ItemStack shelfStack;
        ShopMode mode = ShopHelper.getShopMode(blockState);
        if (mode == ShopMode.PLAYERSHELF) {
            ShopHelper.handlePlayerShelfBuy(buyer, blockState, slot);
            return;
        }
        if (!ShopEconomy.isEconomyEnabled()) {
            MessageUtil.sendError((CommandSender)buyer, "error_economy_not_enabled");
            return;
        }
        if (blockState instanceof Shelf) {
            Shelf shelf = (Shelf)blockState;
            v0 = shelf.getInventory().getItem(slot);
        } else {
            v0 = shelfStack = null;
        }
        if (shelfStack == null || shelfStack.getType().isAir()) {
            MessageUtil.sendError((CommandSender)buyer, "error_shop_out_of_stock");
            return;
        }
        int n = amountToBuy = isShiftClick ? shelfStack.getMaxStackSize() : shelfStack.getAmount();
        if (amountToBuy <= 0) {
            return;
        }
        Optional<Double> unitPriceOpt = ShopHelper.getUnitPrice(blockState, slot, true);
        if (unitPriceOpt.isEmpty() || unitPriceOpt.get() <= 0.0) {
            MessageUtil.sendError((CommandSender)buyer, "error_item_not_for_sale");
            return;
        }
        double price = unitPriceOpt.get() * (double)amountToBuy;
        ItemStack itemToGive = new ItemStack(shelfStack.getType(), amountToBuy);
        ItemMeta shelfMeta = shelfStack.getItemMeta();
        if (shelfMeta != null && (itemToGiveMeta = itemToGive.getItemMeta()) != null) {
            itemToGive.setItemMeta(shelfMeta);
            itemToGive.setAmount(amountToBuy);
        }
        if (ShopEconomy.hasEnough(buyer, price)) {
            if (ShopUtility.hasEnoughSpace((Inventory)buyer.getInventory(), itemToGive.clone())) {
                ShopEconomy.withdraw(buyer, price);
                ShopUtility.addItems((Inventory)buyer.getInventory(), itemToGive.clone());
                MessageUtil.sendPlayerMessage(buyer, "item_bought", Map.of("%amount%", String.valueOf(amountToBuy), "%item%", itemToGive.getType().name(), "%price%", ShopHelper.formatAccuratePrice(price)));
                buyer.getWorld().playSound(buyer.getLocation(), Sound.ENTITY_VILLAGER_TRADE, 0.5f, 1.0f);
            } else {
                MessageUtil.sendError((CommandSender)buyer, "error_inventory_full");
            }
        } else {
            MessageUtil.sendError((CommandSender)buyer, "error_insufficient_funds", Map.of("%price%", ShopHelper.formatAccuratePrice(price)));
        }
    }

    public static void handleSellInteraction(Player seller, BlockState blockState, int slot, boolean isShiftClick) {
        int actualAmountToSell;
        int desiredAmountToSell;
        ItemStack shelfStack;
        ShopMode mode = ShopHelper.getShopMode(blockState);
        if (mode == ShopMode.PLAYERSHELF) {
            ShopHelper.handlePlayerShelfSell(seller, blockState, slot);
            return;
        }
        if (!ShopEconomy.isEconomyEnabled()) {
            MessageUtil.sendError((CommandSender)seller, "error_economy_not_enabled");
            return;
        }
        if (blockState instanceof Shelf) {
            Shelf shelf = (Shelf)blockState;
            v0 = shelf.getInventory().getItem(slot);
        } else {
            v0 = shelfStack = null;
        }
        if (shelfStack == null || shelfStack.getType().isAir()) {
            MessageUtil.sendError((CommandSender)seller, "error_shop_not_buying");
            return;
        }
        Optional<Double> unitPriceOpt = ShopHelper.getUnitPrice(blockState, slot, false);
        if (unitPriceOpt.isEmpty() || unitPriceOpt.get() <= 0.0) {
            MessageUtil.sendError((CommandSender)seller, "error_shop_not_buying");
            return;
        }
        double unitPrice = unitPriceOpt.get();
        int n = desiredAmountToSell = isShiftClick ? shelfStack.getMaxStackSize() : shelfStack.getAmount();
        if (desiredAmountToSell <= 0) {
            return;
        }
        int playerItemCount = ShopUtility.countItems((Inventory)seller.getInventory(), shelfStack);
        int n2 = actualAmountToSell = playerItemCount < desiredAmountToSell ? playerItemCount : desiredAmountToSell;
        if (actualAmountToSell <= 0) {
            MessageUtil.sendError((CommandSender)seller, "error_not_enough_items_to_sell", Map.of("%amount%", String.valueOf(desiredAmountToSell), "%item%", shelfStack.getType().name()));
            return;
        }
        double price = unitPrice * (double)actualAmountToSell;
        ItemStack transactionStack = shelfStack.clone();
        transactionStack.setAmount(actualAmountToSell);
        if (ShopUtility.removeItems((Inventory)seller.getInventory(), transactionStack.clone())) {
            ShopEconomy.deposit(seller, price);
            MessageUtil.sendPlayerMessage(seller, "item_sold", Map.of("%amount%", String.valueOf(transactionStack.getAmount()), "%item%", shelfStack.getType().name(), "%price%", ShopHelper.formatAccuratePrice(price)));
            seller.getWorld().playSound(seller.getLocation(), Sound.ENTITY_VILLAGER_TRADE, 0.5f, 1.0f);
        } else {
            MessageUtil.sendError((CommandSender)seller, "error_not_enough_items_to_sell", Map.of("%amount%", String.valueOf(desiredAmountToSell), "%item%", shelfStack.getType().name()));
        }
    }

    public static void handlePlayerShelfBuy(Player buyer, BlockState blockState, int slot) {
        ItemStack shelfStack;
        Optional<UUID> ownerUuidOpt = ShopHelper.getOwner(blockState);
        if (blockState instanceof Shelf) {
            Shelf shelf = (Shelf)blockState;
            v0 = shelf.getInventory().getItem(slot);
        } else {
            v0 = shelfStack = null;
        }
        if (shelfStack == null || shelfStack.getType().isAir() || ownerUuidOpt.isEmpty()) {
            MessageUtil.sendError((CommandSender)buyer, "error_shop_out_of_stock");
            return;
        }
        if (!ShopEconomy.isEconomyEnabled()) {
            MessageUtil.sendError((CommandSender)buyer, "error_economy_not_enabled");
            return;
        }
        if (ownerUuidOpt.get().equals(buyer.getUniqueId())) {
            return;
        }
        int amountToBuy = shelfStack.getAmount();
        ItemStack itemToGive = shelfStack.clone();
        Optional<Double> priceOpt = ShopHelper.getPrice(blockState, slot, ShopMode.PLAYERSHELF, true);
        if (priceOpt.isEmpty() || priceOpt.get() <= 0.0) {
            MessageUtil.sendError((CommandSender)buyer, "error_item_not_for_sale");
            return;
        }
        double price = priceOpt.get();
        Optional<Inventory> containerOpt = ShopHelper.getLinkedContainerInventory(blockState);
        if (containerOpt.isEmpty()) {
            MessageUtil.sendError((CommandSender)buyer, "error_container_missing");
            return;
        }
        Inventory container = containerOpt.get();
        if (ShopUtility.countItems(container, itemToGive) < itemToGive.getAmount()) {
            MessageUtil.sendError((CommandSender)buyer, "error_shop_out_of_stock");
            return;
        }
        if (ShopEconomy.hasEnough(buyer, price)) {
            if (ShopUtility.removeItems(container, itemToGive.clone())) {
                if (ShopUtility.hasEnoughSpace((Inventory)buyer.getInventory(), itemToGive.clone())) {
                    ShopUtility.addItems((Inventory)buyer.getInventory(), itemToGive.clone());
                    ShopEconomy.withdraw(buyer, price);
                    ShopEconomy.deposit(ownerUuidOpt.get(), price);
                    MessageUtil.sendPlayerMessage(buyer, "item_bought", Map.of("%amount%", String.valueOf(amountToBuy), "%item%", itemToGive.getType().name(), "%price%", ShopHelper.formatAccuratePrice(price)));
                    buyer.getWorld().playSound(buyer.getLocation(), Sound.ENTITY_VILLAGER_TRADE, 0.5f, 1.0f);
                } else {
                    ShopUtility.addItems(container, itemToGive.clone());
                    MessageUtil.sendError((CommandSender)buyer, "error_inventory_full");
                }
            } else {
                MessageUtil.sendError((CommandSender)buyer, "error_shop_out_of_stock");
            }
        } else {
            MessageUtil.sendError((CommandSender)buyer, "error_insufficient_funds", Map.of("%price%", ShopHelper.formatAccuratePrice(price)));
        }
    }

    public static void handlePlayerShelfSell(Player seller, BlockState blockState, int slot) {
        ItemStack itemToSell;
        Optional<UUID> ownerUuidOpt = ShopHelper.getOwner(blockState);
        if (blockState instanceof Shelf) {
            Shelf shelf = (Shelf)blockState;
            v0 = shelf.getInventory().getItem(slot);
        } else {
            v0 = itemToSell = null;
        }
        if (itemToSell == null || itemToSell.getType().isAir() || ownerUuidOpt.isEmpty()) {
            MessageUtil.sendError((CommandSender)seller, "error_shop_not_buying");
            return;
        }
        if (!ShopEconomy.isEconomyEnabled()) {
            MessageUtil.sendError((CommandSender)seller, "error_economy_not_enabled");
            return;
        }
        if (ownerUuidOpt.get().equals(seller.getUniqueId())) {
            return;
        }
        Optional<Double> priceOpt = ShopHelper.getPrice(blockState, slot, ShopMode.PLAYERSHELF, false);
        if (priceOpt.isEmpty() || priceOpt.get() <= 0.0) {
            MessageUtil.sendError((CommandSender)seller, "error_shop_not_buying");
            return;
        }
        double price = priceOpt.get();
        Optional<Inventory> containerOpt = ShopHelper.getLinkedContainerInventory(blockState);
        if (containerOpt.isEmpty()) {
            MessageUtil.sendError((CommandSender)seller, "error_container_missing");
            return;
        }
        Inventory container = containerOpt.get();
        if (!ShopEconomy.hasEnough(ownerUuidOpt.get(), price)) {
            MessageUtil.sendError((CommandSender)seller, "error_owner_insufficient_funds");
            return;
        }
        if (ShopUtility.countItems((Inventory)seller.getInventory(), itemToSell) < itemToSell.getAmount()) {
            MessageUtil.sendError((CommandSender)seller, "error_not_enough_items_to_sell", Map.of("%amount%", String.valueOf(itemToSell.getAmount()), "%item%", itemToSell.getType().name()));
            return;
        }
        if (!ShopUtility.hasEnoughSpace(container, itemToSell.clone())) {
            MessageUtil.sendError((CommandSender)seller, "error_shop_container_full");
            return;
        }
        if (ShopUtility.removeItems((Inventory)seller.getInventory(), itemToSell.clone())) {
            ShopEconomy.withdraw(ownerUuidOpt.get(), price);
            ShopEconomy.deposit(seller, price);
            ShopUtility.addItems(container, itemToSell.clone());
            MessageUtil.sendPlayerMessage(seller, "item_sold", Map.of("%amount%", String.valueOf(itemToSell.getAmount()), "%item%", itemToSell.getType().name(), "%price%", ShopHelper.formatAccuratePrice(price)));
            seller.getWorld().playSound(seller.getLocation(), Sound.ENTITY_VILLAGER_TRADE, 0.5f, 1.0f);
        } else {
            MessageUtil.sendError((CommandSender)seller, "error_not_enough_items_to_sell", Map.of("%amount%", String.valueOf(itemToSell.getAmount()), "%item%", itemToSell.getType().name()));
        }
    }

    public static boolean isPlayerShelfOutOfOrder(BlockState blockState) {
        return ShopHelper.getShopMode(blockState) == ShopMode.PLAYERSHELF && ShopHelper.getLinkedContainerInventory(blockState).isEmpty();
    }

    public static List<ItemStack> getShelfContents(BlockState blockState) {
        if (blockState instanceof Shelf) {
            Shelf shelf = (Shelf)blockState;
            return Arrays.stream(shelf.getInventory().getContents()).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static boolean isSimilarIgnoringPriceStamp(ItemStack stack1, ItemStack stack2) {
        if (stack1.getType() != stack2.getType()) {
            return false;
        }
        ItemMeta meta1 = stack1.getItemMeta();
        ItemMeta meta2 = stack2.getItemMeta();
        if (meta1 == null && meta2 == null) {
            return true;
        }
        if (meta1 == null || meta2 == null) {
            return false;
        }
        ItemMeta tempMeta1 = meta1.clone();
        ItemMeta tempMeta2 = meta2.clone();
        NamespacedKey stampKey = new NamespacedKey((Plugin)ShopShelvesSpigot.getInstance(), "price_stamp");
        tempMeta1.getPersistentDataContainer().remove(stampKey);
        tempMeta2.getPersistentDataContainer().remove(stampKey);
        ItemStack tempStack1 = stack1.clone();
        tempStack1.setItemMeta(tempMeta1);
        ItemStack tempStack2 = stack2.clone();
        tempStack2.setItemMeta(tempMeta2);
        return tempStack1.isSimilar(tempStack2);
    }

    public static String formatPrice(double price) {
        if (ShopshelvesConfig.get().shouldRoundOffDisplayPrices()) {
            long roundedPrice = Math.round(price);
            return String.valueOf(roundedPrice);
        }
        String formatted = String.format(Locale.ROOT, "%.2f", price);
        if (formatted.endsWith(".00")) {
            return formatted.substring(0, formatted.length() - 3);
        }
        if (formatted.endsWith("0")) {
            return formatted.substring(0, formatted.length() - 1);
        }
        return formatted;
    }

    public static String formatAccuratePrice(double price) {
        return String.format(Locale.ROOT, "%.2f", price);
    }

    @Nullable
    public static String formatDisplayPrice(@Nullable Double price, ShopMode shopMode) {
        String notSetSymbol = MessageFormattingManager.getMessages().price_unset_display;
        if (price == null) {
            return notSetSymbol;
        }
        if (price <= 0.0) {
            if (shopMode == ShopMode.PLAYERSHELF) {
                return null;
            }
            return notSetSymbol;
        }
        return ShopHelper.formatPrice(price);
    }

    public static enum ShopMode {
        NONE,
        BUY,
        SELL,
        DUAL,
        PLAYERSHELF;

    }
}

