/*
 * Decompiled with CFR 0.152.
 */
package me.andy.shopShelvesSpigot.util;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.andy.shopShelvesSpigot.ShopShelvesSpigot;
import me.andy.shopShelvesSpigot.config.MessageFormattingData;
import me.andy.shopShelvesSpigot.config.MessageFormattingManager;
import me.andy.shopShelvesSpigot.config.ShopshelvesConfig;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MessageUtil {
    private static final Pattern HEX_PATTERN = Pattern.compile("&#([A-Fa-f0-9]{6})");
    private static final Pattern RICH_TEXT_PATTERN = Pattern.compile("(?<text>.*?)\\{(?<hover>.*?)\\}(?<action><action:(?<type>[^,]+),(?<value>.*?)>)?");

    public static void sendMessage(CommandSender source, String key, Map<String, String> placeholders) {
        Player player;
        MessageFormattingData.MessageEntry messageEntry = MessageUtil.getMessageEntry(key);
        if (messageEntry == null) {
            return;
        }
        ShopshelvesConfig.MessageDeliveryMode mode = ShopshelvesConfig.get().getMessageDeliveryMode();
        Player player2 = player = source instanceof Player ? (Player)source : null;
        if (!(mode != ShopshelvesConfig.MessageDeliveryMode.CHAT && mode != ShopshelvesConfig.MessageDeliveryMode.BOTH || messageEntry.chat() == null || messageEntry.chat().isEmpty())) {
            String rawChatMessage = MessageUtil.replacePlaceholders(messageEntry.chat(), placeholders);
            source.sendMessage(MessageUtil.translateColorCodes(rawChatMessage));
        }
        if (!(player == null || mode != ShopshelvesConfig.MessageDeliveryMode.ACTIONBAR && mode != ShopshelvesConfig.MessageDeliveryMode.BOTH || messageEntry.actionbar() == null || messageEntry.actionbar().isEmpty())) {
            String rawActionbarMessage = MessageUtil.replacePlaceholders(messageEntry.actionbar(), placeholders);
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)MessageUtil.translateColorCodes(rawActionbarMessage)));
        }
    }

    public static void sendRichTextLines(CommandSender sender, List<String> rawLines) {
        if (rawLines == null) {
            return;
        }
        for (String rawLine : rawLines) {
            Matcher matcher = RICH_TEXT_PATTERN.matcher(rawLine);
            TextComponent finalComponent = new TextComponent("");
            if (matcher.find()) {
                String lineText = matcher.group("text");
                String hoverText = matcher.group("hover");
                String actionType = matcher.group("type");
                String actionValue = matcher.group("value");
                TextComponent textComponent = new TextComponent(MessageUtil.translateColorCodes(lineText));
                if (hoverText != null && !hoverText.isEmpty()) {
                    String formattedHover = MessageUtil.translateColorCodes(hoverText);
                    textComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(formattedHover)}));
                }
                if (actionType != null && actionValue != null) {
                    try {
                        ClickEvent.Action action = ClickEvent.Action.valueOf((String)actionType.toUpperCase(Locale.ROOT));
                        textComponent.setClickEvent(new ClickEvent(action, actionValue));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                finalComponent.addExtra((BaseComponent)textComponent);
            } else {
                finalComponent.addExtra(MessageUtil.translateColorCodes(rawLine));
            }
            sender.spigot().sendMessage((BaseComponent)finalComponent);
        }
    }

    public static void sendError(CommandSender source, String key, Map<String, String> placeholders) {
        MessageFormattingData.MessageEntry messageEntry = MessageUtil.getMessageEntry(key);
        if (messageEntry == null) {
            return;
        }
        String rawErrorMessage = messageEntry.chat();
        if (rawErrorMessage == null || rawErrorMessage.isEmpty()) {
            rawErrorMessage = messageEntry.actionbar();
        }
        if (rawErrorMessage == null) {
            return;
        }
        rawErrorMessage = MessageUtil.replacePlaceholders(rawErrorMessage, placeholders);
        source.sendMessage(MessageUtil.translateColorCodes(rawErrorMessage));
    }

    public static void formatAndSendLines(CommandSender sender, List<String> rawLines) {
        if (rawLines == null) {
            return;
        }
        rawLines.stream().map(line -> line.replaceAll("\\{.*?\\}", "").replaceAll("<action:.*?>", "")).forEach(line -> sender.sendMessage(MessageUtil.translateColorCodes(line)));
    }

    public static String formatDisplay(String rawText) {
        return MessageUtil.translateColorCodes(rawText);
    }

    private static String replacePlaceholders(String text, Map<String, String> placeholders) {
        if (placeholders == null) {
            return text;
        }
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            text = text.replace(entry.getKey(), entry.getValue());
        }
        return text;
    }

    private static MessageFormattingData.MessageEntry getMessageEntry(String key) {
        try {
            Field field = MessageFormattingData.class.getDeclaredField(key);
            field.setAccessible(true);
            return (MessageFormattingData.MessageEntry)field.get(MessageFormattingManager.getMessages());
        }
        catch (NoSuchFieldException e) {
            ShopShelvesSpigot.getInstance().getLogger().warning("Message key '" + key + "' missing. Using default error.");
            return new MessageFormattingData.MessageEntry("&c[Missing: " + key + "]", "&c[Missing: " + key + "]");
        }
        catch (IllegalAccessException e) {
            ShopShelvesSpigot.getInstance().getLogger().severe("Could not access message key '" + key + "' via reflection.");
            return new MessageFormattingData.MessageEntry("&c[Access Error]", "&c[Access Error]");
        }
    }

    public static String translateColorCodes(String text) {
        Matcher matcher = HEX_PATTERN.matcher(text);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String hex = matcher.group(1);
            StringBuilder replacement = new StringBuilder("\u00a7x");
            for (char c : hex.toCharArray()) {
                replacement.append('\u00a7').append(c);
            }
            matcher.appendReplacement(buffer, replacement.toString());
        }
        matcher.appendTail(buffer);
        text = buffer.toString();
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    public static void sendMessage(CommandSender source, String key) {
        MessageUtil.sendMessage(source, key, Collections.emptyMap());
    }

    public static void sendError(CommandSender source, String key) {
        MessageUtil.sendError(source, key, Collections.emptyMap());
    }

    public static void sendPlayerMessage(Player player, String key) {
        MessageUtil.sendMessage((CommandSender)player, key, Collections.emptyMap());
    }

    public static void sendPlayerMessage(Player player, String key, Map<String, String> placeholders) {
        MessageUtil.sendMessage((CommandSender)player, key, placeholders);
    }
}

