/*
 * Decompiled with CFR 0.152.
 */
package me.andy.shopShelvesSpigot.util;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.stream.Collectors;
import me.andy.shopShelvesSpigot.ShopShelvesSpigot;
import me.andy.shopShelvesSpigot.logic.ShopHelper;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.configuration.file.YamlConfiguration;

public class ShopDataManager {
    private static final ShopDataManager instance = new ShopDataManager();
    private final File dataFile;
    private YamlConfiguration dataConfig;
    private final Map<String, Map<String, Location>> linkedContainers = new ConcurrentHashMap<String, Map<String, Location>>();
    private final Map<String, Map<String, List<DisplayConfig>>> shopDisplaysConfig = new ConcurrentHashMap<String, Map<String, List<DisplayConfig>>>();

    private ShopDataManager() {
        this.dataFile = new File(ShopShelvesSpigot.getInstance().getDataFolder(), "data.yml");
    }

    public static ShopDataManager get() {
        return instance;
    }

    public Map<String, Map<String, List<DisplayConfig>>> getAllShopsConfig() {
        return Collections.unmodifiableMap(this.shopDisplaysConfig);
    }

    public void load() {
        if (!this.dataFile.exists()) {
            try {
                this.dataFile.getParentFile().mkdirs();
                this.dataFile.createNewFile();
            }
            catch (IOException e) {
                ShopShelvesSpigot.getInstance().getLogger().log(Level.SEVERE, "Failed to create data.yml for shopshelves data.", e);
            }
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
        this.linkedContainers.clear();
        this.shopDisplaysConfig.clear();
        if (this.dataConfig.isConfigurationSection("linkedContainers")) {
            for (String worldName : this.dataConfig.getConfigurationSection("linkedContainers").getKeys(false)) {
                ConcurrentHashMap worldLinks = new ConcurrentHashMap();
                if (this.dataConfig.isConfigurationSection("linkedContainers." + worldName)) {
                    for (String containerKey : this.dataConfig.getConfigurationSection("linkedContainers." + worldName).getKeys(false)) {
                        String shelfKey = this.dataConfig.getString("linkedContainers." + worldName + "." + containerKey);
                        this.keyToLocation(shelfKey).ifPresent(shelfLoc -> worldLinks.put(containerKey, shelfLoc));
                    }
                }
                this.linkedContainers.put(worldName, worldLinks);
            }
        }
        if (this.dataConfig.isConfigurationSection("shopDisplaysConfig")) {
            for (String worldName : this.dataConfig.getConfigurationSection("shopDisplaysConfig").getKeys(false)) {
                ConcurrentHashMap worldDisplays = new ConcurrentHashMap();
                if (this.dataConfig.isConfigurationSection("shopDisplaysConfig." + worldName)) {
                    for (String shelfKey : this.dataConfig.getConfigurationSection("shopDisplaysConfig." + worldName).getKeys(false)) {
                        List rawList = this.dataConfig.getList("shopDisplaysConfig." + worldName + "." + shelfKey);
                        if (rawList == null) continue;
                        List configs = rawList.stream().filter(o -> o instanceof Map).map(o -> {
                            Map map = (Map)o;
                            try {
                                String text = (String)map.get("text");
                                double offsetX = ((Number)map.get("offsetX")).doubleValue();
                                double offsetY = ((Number)map.get("offsetY")).doubleValue();
                                double offsetZ = ((Number)map.get("offsetZ")).doubleValue();
                                float scale = ((Number)map.get("scale")).floatValue();
                                int viewRange = ((Number)map.get("viewRange")).intValue();
                                float yaw = ((Number)map.get("yaw")).floatValue();
                                String ownerTag = (String)map.get("ownerTag");
                                return new DisplayConfig(null, text, offsetX, offsetY, offsetZ, scale, viewRange, yaw, ownerTag);
                            }
                            catch (Exception e) {
                                ShopShelvesSpigot.getInstance().getLogger().warning("Failed to deserialize DisplayConfig for key: " + shelfKey + ". " + e.getMessage());
                                return null;
                            }
                        }).filter(Objects::nonNull).collect(Collectors.toList());
                        worldDisplays.put(shelfKey, configs);
                    }
                }
                this.shopDisplaysConfig.put(worldName, worldDisplays);
            }
        }
        ShopShelvesSpigot.getInstance().getLogger().info("Loaded " + this.linkedContainers.values().stream().mapToInt(Map::size).sum() + " linked containers from data.yml");
    }

    public void save() {
        String worldName;
        this.dataConfig.set("linkedContainers", null);
        for (Map.Entry<String, Map<String, Location>> entry : this.linkedContainers.entrySet()) {
            worldName = entry.getKey();
            for (Map.Entry<String, Location> linkEntry : entry.getValue().entrySet()) {
                String containerKey = linkEntry.getKey();
                String shelfKey = this.locationToKey(linkEntry.getValue());
                this.dataConfig.set("linkedContainers." + worldName + "." + containerKey, (Object)shelfKey);
            }
        }
        this.dataConfig.set("shopDisplaysConfig", null);
        for (Map.Entry<String, Map<String, Object>> entry : this.shopDisplaysConfig.entrySet()) {
            worldName = entry.getKey();
            for (Map.Entry<String, Object> displayEntry : entry.getValue().entrySet()) {
                String shelfKey = displayEntry.getKey();
                List mapList = ((List)displayEntry.getValue()).stream().map(config -> {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("text", config.getText());
                    map.put("offsetX", config.getOffsetX());
                    map.put("offsetY", config.getOffsetY());
                    map.put("offsetZ", config.getOffsetZ());
                    map.put("scale", Float.valueOf(config.getScale()));
                    map.put("viewRange", config.getViewRange());
                    map.put("yaw", Float.valueOf(config.getYaw()));
                    map.put("ownerTag", config.getOwnerTag());
                    return map;
                }).collect(Collectors.toList());
                this.dataConfig.set("shopDisplaysConfig." + worldName + "." + shelfKey, mapList);
            }
        }
        try {
            this.dataConfig.save(this.dataFile);
        }
        catch (IOException e) {
            ShopShelvesSpigot.getInstance().getLogger().severe("Could not save data.yml: " + e.getMessage());
        }
    }

    public String locationToKey(Location loc) {
        if (loc == null || loc.getWorld() == null) {
            return null;
        }
        return String.format("%s;%d;%d;%d", loc.getWorld().getName(), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
    }

    public Optional<Location> keyToLocation(String key) {
        if (key == null) {
            return Optional.empty();
        }
        String[] parts = key.split(";");
        if (parts.length != 4) {
            return Optional.empty();
        }
        try {
            World world = Bukkit.getWorld((String)parts[0]);
            if (world == null) {
                return Optional.empty();
            }
            int x = Integer.parseInt(parts[1]);
            int y = Integer.parseInt(parts[2]);
            int z = Integer.parseInt(parts[3]);
            return Optional.of(new Location(world, (double)x, (double)y, (double)z));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public boolean isContainerLinked(Location containerLoc) {
        return ((Map)this.linkedContainers.getOrDefault(containerLoc.getWorld().getName(), new HashMap())).containsKey(this.locationToKey(containerLoc));
    }

    public boolean isContainerLinked(List<Location> containerLocations) {
        if (containerLocations.isEmpty()) {
            return false;
        }
        Location firstLoc = containerLocations.get(0);
        return this.isContainerLinked(firstLoc);
    }

    public Optional<Location> getShelfForContainer(Location containerLoc) {
        String worldName = containerLoc.getWorld().getName();
        String containerKey = this.locationToKey(containerLoc);
        Location shelfLoc = (Location)((Map)this.linkedContainers.getOrDefault(worldName, new HashMap())).get(containerKey);
        return Optional.ofNullable(shelfLoc);
    }

    public void addLink(List<Location> containerLocations, Location shelfLoc) {
        if (containerLocations.isEmpty() || shelfLoc == null) {
            return;
        }
        String worldName = shelfLoc.getWorld().getName();
        Map worldLinks = this.linkedContainers.computeIfAbsent(worldName, k -> new ConcurrentHashMap());
        for (Location containerLoc : containerLocations) {
            worldLinks.put(this.locationToKey(containerLoc), shelfLoc);
        }
        this.save();
    }

    public void removeLink(List<Location> containerLocations) {
        if (containerLocations.isEmpty()) {
            return;
        }
        String worldName = containerLocations.get(0).getWorld().getName();
        Map<String, Location> worldLinks = this.linkedContainers.get(worldName);
        if (worldLinks != null) {
            for (Location containerLoc : containerLocations) {
                worldLinks.remove(this.locationToKey(containerLoc));
            }
            this.save();
        }
    }

    public Optional<List<DisplayConfig>> removeShopDisplayConfigs(Location shelfLoc) {
        String worldName = shelfLoc.getWorld().getName();
        String shelfKey = this.locationToKey(shelfLoc);
        Map<String, List<DisplayConfig>> worldDisplays = this.shopDisplaysConfig.get(worldName);
        if (worldDisplays != null) {
            Optional<List<DisplayConfig>> configs = Optional.ofNullable(worldDisplays.remove(shelfKey));
            if (configs.isPresent()) {
                this.save();
            }
            return configs;
        }
        return Optional.empty();
    }

    public Optional<List<DisplayConfig>> getShopDisplayConfigs(Location shelfLoc) {
        String worldName = shelfLoc.getWorld().getName();
        String shelfKey = this.locationToKey(shelfLoc);
        Map<String, List<DisplayConfig>> worldDisplays = this.shopDisplaysConfig.get(worldName);
        if (worldDisplays != null) {
            return Optional.ofNullable(worldDisplays.get(shelfKey));
        }
        return Optional.empty();
    }

    public void setShopDisplayConfigs(Location shelfLoc, List<DisplayConfig> configs) {
        String worldName = shelfLoc.getWorld().getName();
        this.shopDisplaysConfig.computeIfAbsent(worldName, k -> new ConcurrentHashMap()).put(this.locationToKey(shelfLoc), configs);
        this.save();
    }

    public int countPlayerShelves(UUID playerUuid) {
        int count = 0;
        List allShelfLocations = this.linkedContainers.values().stream().flatMap(map -> map.values().stream()).distinct().collect(Collectors.toList());
        for (Location shelfLoc : allShelfLocations) {
            BlockState blockState;
            World world = shelfLoc.getWorld();
            if (world == null || !world.isChunkLoaded(shelfLoc.getChunk()) || !ShopHelper.isShelf((blockState = shelfLoc.getBlock().getState()).getBlock().getType()) || ShopHelper.getShopMode(blockState) != ShopHelper.ShopMode.PLAYERSHELF || !ShopHelper.getOwner(blockState).map(uuid -> uuid.equals(playerUuid)).orElse(false).booleanValue()) continue;
            ++count;
        }
        return count;
    }

    public List<Location> getAllPlayerShelfLocations() {
        return this.linkedContainers.values().stream().flatMap(map -> map.values().stream()).distinct().collect(Collectors.toList());
    }

    public void clearRuntimeDisplayData() {
        this.shopDisplaysConfig.clear();
    }

    public static class DisplayConfig {
        public UUID liveUuid;
        public String text;
        public double offsetX;
        public double offsetY;
        public double offsetZ;
        public float scale;
        public int viewRange;
        public float yaw;
        public String ownerTag;

        public DisplayConfig() {
        }

        public DisplayConfig(UUID liveUuid, String text, double offsetX, double offsetY, double offsetZ, float scale, int viewRange, float yaw, String ownerTag) {
            this.liveUuid = liveUuid;
            this.text = text;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.offsetZ = offsetZ;
            this.scale = scale;
            this.viewRange = viewRange;
            this.yaw = yaw;
            this.ownerTag = ownerTag;
        }

        public UUID getLiveUuid() {
            return this.liveUuid;
        }

        public String getText() {
            return this.text;
        }

        public double getOffsetX() {
            return this.offsetX;
        }

        public double getOffsetY() {
            return this.offsetY;
        }

        public double getOffsetZ() {
            return this.offsetZ;
        }

        public float getScale() {
            return this.scale;
        }

        public int getViewRange() {
            return this.viewRange;
        }

        public float getYaw() {
            return this.yaw;
        }

        public String getOwnerTag() {
            return this.ownerTag;
        }

        public void setLiveUuid(UUID liveUuid) {
            this.liveUuid = liveUuid;
        }
    }
}

