/*
 * Decompiled with CFR 0.152.
 */
package me.andy.shopshelves.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import me.andy.shopshelves.Shopshelves;
import me.andy.shopshelves.logic.ShopHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class ShopPricing {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("shopshelves");
    private static final Path CONFIG_FILE = CONFIG_PATH.resolve("pricing.json");
    private static Map<String, PriceEntry> prices = new HashMap<String, PriceEntry>();
    private static final Function<class_1792, String> getId = item -> class_7923.field_41178.method_10221(item).toString();
    private static final Function<String, class_1792> getItemFromId = id -> (class_1792)class_7923.field_41178.method_63535(class_2960.method_60655((String)"minecraft", (String)id));
    private static final PriceEntry P_DIRT = new PriceEntry(1, 0.25, 1.0);
    private static final PriceEntry P_STONE = new PriceEntry(1, 1.0, 4.0);
    private static final PriceEntry P_LOG = new PriceEntry(1, 1.0, 3.0);
    private static final PriceEntry P_IRON_INGOT = new PriceEntry(1, 6.0, 20.0);
    private static final PriceEntry P_COPPER_INGOT = new PriceEntry(1, 4.0, 12.0);
    private static final PriceEntry P_GOLD_INGOT = new PriceEntry(1, 15.0, 50.0);
    private static final PriceEntry P_DIAMOND = new PriceEntry(1, 60.0, 200.0);
    private static final PriceEntry P_EMERALD = new PriceEntry(1, 80.0, 250.0);
    private static final PriceEntry P_NETHERITE = new PriceEntry(1, 540.0, 1800.0);
    private static final PriceEntry P_UTILITY_LOW = new PriceEntry(1, 1.0, 5.0);
    private static final PriceEntry P_MECH_MID = new PriceEntry(1, 4.0, 15.0);
    private static final PriceEntry P_FARMABLE_NONE = new PriceEntry(1, 0.0, 1.0);
    private static final PriceEntry P_UNTRADEABLE = new PriceEntry(1, null, null);
    private static final PriceEntry P_GEAR_DIAMOND = new PriceEntry(1, P_DIAMOND.sellPrice() * 4.0, P_DIAMOND.buyPrice() * 4.0);

    public static void load() {
        if (!Files.exists(CONFIG_FILE, new LinkOption[0])) {
            ShopPricing.createDefaultConfig();
            ShopPricing.save();
            return;
        }
        try (FileReader reader = new FileReader(CONFIG_FILE.toFile());){
            Type type = new TypeToken<Map<String, PriceEntry>>(){}.getType();
            prices = (Map)GSON.fromJson((Reader)reader, type);
            if (prices == null) {
                prices = new HashMap<String, PriceEntry>();
            }
            Shopshelves.LOGGER.info("ShopShelves pricing loaded successfully.");
        }
        catch (IOException e) {
            Shopshelves.LOGGER.error("Failed to load ShopShelves pricing.json", (Throwable)e);
            prices = new HashMap<String, PriceEntry>();
        }
    }

    public static void save() {
        try {
            Files.createDirectories(CONFIG_PATH, new FileAttribute[0]);
            try (FileWriter writer = new FileWriter(CONFIG_FILE.toFile());){
                GSON.toJson(prices, (Appendable)writer);
            }
        }
        catch (IOException e) {
            Shopshelves.LOGGER.error("Failed to save ShopShelves pricing.json", (Throwable)e);
        }
    }

    private static void createDefaultConfig() {
        prices.clear();
        BiConsumer<class_1792, PriceEntry> applyPrice = (item, entry) -> {
            if (item != class_1802.field_8162) {
                prices.put(getId.apply((class_1792)item), (PriceEntry)entry);
            }
        };
        for (class_1792 item2 : class_7923.field_41178) {
            String id = getId.apply(item2);
            applyPrice.accept(item2, P_STONE);
            if (item2 == class_1802.field_8162 || item2 == class_1802.field_8542 || id.contains("portal") || id.contains("fire") || id.contains("jigsaw") || id.contains("structure_") || id.contains("command_block") || id.contains("moving_piston") || id.contains("barrier") || id.contains("light") || item2 == class_1802.field_8840) {
                applyPrice.accept(item2, P_UNTRADEABLE);
                continue;
            }
            if (id.contains("ore") || id.contains("raw_") || id.contains("ingot") || id.contains("nugget") || id.contains("scrap") || id.contains("shard")) {
                if (id.contains("iron")) {
                    applyPrice.accept(item2, P_IRON_INGOT);
                    continue;
                }
                if (id.contains("copper")) {
                    applyPrice.accept(item2, P_COPPER_INGOT);
                    continue;
                }
                if (id.contains("gold")) {
                    applyPrice.accept(item2, P_GOLD_INGOT);
                    continue;
                }
                if (id.contains("diamond")) {
                    applyPrice.accept(item2, P_DIAMOND);
                    continue;
                }
                if (id.contains("emerald")) {
                    applyPrice.accept(item2, P_EMERALD);
                    continue;
                }
                if (id.contains("netherite")) {
                    applyPrice.accept(item2, P_NETHERITE);
                    continue;
                }
                if (id.contains("coal")) {
                    applyPrice.accept(item2, new PriceEntry(1, 2.5, 8.0));
                    continue;
                }
                if (id.contains("lapis")) {
                    applyPrice.accept(item2, new PriceEntry(1, 1.5, 5.0));
                    continue;
                }
                if (!id.contains("redstone")) continue;
                applyPrice.accept(item2, new PriceEntry(1, 1.0, 3.0));
                continue;
            }
            if (id.contains("dirt") || id.contains("sand") || id.contains("gravel") || id.contains("mud") || id.contains("clay")) {
                prices.put(id, P_DIRT);
                continue;
            }
            if (id.contains("_log") || id.contains("_wood") || id.contains("bamboo_block") || id.contains("stem") || id.contains("hyphae")) {
                prices.put(id, P_LOG);
                continue;
            }
            if (id.contains("_planks")) {
                prices.put(id, new PriceEntry(4, null, P_LOG.buyPrice()));
                continue;
            }
            if (id.contains("piston") || id.contains("dispenser") || id.contains("dropper") || id.contains("observer") || id.contains("comparator") || id.contains("repeater")) {
                prices.put(id, P_MECH_MID);
                continue;
            }
            if (id.contains("furnace") || id.contains("smoker") || id.contains("blast_furnace") || id.contains("crafting_table") || id.contains("barrel") || id.contains("loom") || id.contains("grindstone")) {
                prices.put(id, P_UTILITY_LOW);
                continue;
            }
            if (id.contains("_sword") || id.contains("_pickaxe") || id.contains("_axe") || id.contains("_hoe") || id.contains("_shovel") || id.contains("boots") || id.contains("helmet") || id.contains("chestplate") || id.contains("leggings")) {
                if (id.contains("diamond")) {
                    prices.put(id, P_GEAR_DIAMOND);
                    continue;
                }
                if (id.contains("netherite")) {
                    prices.put(id, new PriceEntry(1, P_NETHERITE.sellPrice() * 1.5, P_NETHERITE.buyPrice() * 1.5));
                    continue;
                }
                if (id.contains("iron")) {
                    prices.put(id, new PriceEntry(1, P_IRON_INGOT.sellPrice() * 4.0, P_IRON_INGOT.buyPrice() * 4.0));
                    continue;
                }
                if (id.contains("copper")) {
                    prices.put(id, new PriceEntry(1, P_COPPER_INGOT.sellPrice() * 4.0, P_COPPER_INGOT.buyPrice() * 4.0));
                    continue;
                }
                if (!id.contains("golden")) continue;
                prices.put(id, new PriceEntry(1, P_GOLD_INGOT.sellPrice() * 3.0, P_GOLD_INGOT.buyPrice() * 3.0));
                continue;
            }
            if (id.contains("copper_golem_statue")) {
                prices.put(id, new PriceEntry(1, 35.0, 120.0));
                continue;
            }
            if (id.contains("copper_chest")) {
                prices.put(id, new PriceEntry(1, 40.0, 130.0));
                continue;
            }
            if (id.contains("copper_bulb") || id.contains("copper_torch") || id.contains("copper_lantern") || id.contains("copper_chain") || id.contains("copper_bars") || id.contains("copper_grate") || id.contains("lightning_rod")) {
                prices.put(id, new PriceEntry(1, 2.0, 8.0));
                continue;
            }
            if (id.contains("seeds") || id.contains("wheat") || id.contains("carrot") || id.contains("melon") || id.contains("leaves") || id.contains("grass") || id.contains("sugar_cane") || id.contains("bamboo") || id.contains("string") || id.contains("feather") || id.contains("rotten_flesh") || id.contains("spider_eye")) {
                prices.put(id, P_FARMABLE_NONE);
                continue;
            }
            if (id.contains("end_rod") || id.contains("chorus_fruit") || id.contains("shulker_shell") || id.contains("totem_of_undying") || id.contains("ender_pearl") || id.contains("blaze_rod") || id.contains("ghast_tear")) {
                prices.put(id, new PriceEntry(1, 50.0, 150.0));
                continue;
            }
            if (id.contains("_slab") || id.contains("_stairs") || id.contains("_wall") || id.contains("_fence") || id.contains("_door") || id.contains("_trapdoor")) {
                prices.put(id, new PriceEntry(1, P_STONE.sellPrice() * 0.75, P_STONE.buyPrice() * 0.75));
                continue;
            }
            if (!id.contains("_sign") && !id.contains("_head") && !id.contains("_skull") && !id.contains("_pot") && !id.contains("potted") && !id.contains("candle") && !id.contains("banner")) continue;
            prices.put(id, P_UTILITY_LOW);
        }
    }

    public static Optional<PriceEntry> getPriceEntry(class_1799 stack) {
        String pricingKey = ShopHelper.getVariationId(stack);
        return Optional.ofNullable(prices.get(pricingKey));
    }

    public static Optional<PriceEntry> getPriceEntry(class_1792 item) {
        class_2960 id = class_7923.field_41178.method_10221((Object)item);
        return Optional.ofNullable(prices.get(id.toString()));
    }

    public static void setPrice(class_1799 stack, int amount, @Nullable Double sellPrice, @Nullable Double buyPrice) {
        String pricingKey = ShopHelper.getVariationId(stack);
        prices.put(pricingKey, new PriceEntry(amount, sellPrice, buyPrice));
    }

    public static Optional<Double> calculatePrice(class_1799 shelfStack, ShopHelper.ShopMode mode) {
        if (shelfStack.method_7960() || mode == ShopHelper.ShopMode.NONE) {
            return Optional.empty();
        }
        return ShopPricing.getPriceEntry(shelfStack).flatMap(configEntry -> {
            Double basePrice;
            switch (mode) {
                case BUY: {
                    Double d = configEntry.buyPrice();
                    break;
                }
                case SELL: {
                    Double d = configEntry.sellPrice();
                    break;
                }
                default: {
                    Double d = basePrice = null;
                }
            }
            if (basePrice == null) {
                return Optional.empty();
            }
            int adminAmount = shelfStack.method_7947();
            int configBaseAmount = configEntry.amount();
            if (configBaseAmount <= 0) {
                return Optional.of(0.0);
            }
            double multiplier = (double)adminAmount / (double)configBaseAmount;
            return Optional.of(basePrice * multiplier);
        });
    }

    public record PriceEntry(int amount, @Nullable Double sellPrice, @Nullable Double buyPrice) {
    }
}

