/*
 * Decompiled with CFR 0.152.
 */
package me.andy.shopshelves.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import me.andy.shopshelves.Shopshelves;
import net.fabricmc.loader.api.FabricLoader;

public class ShopshelvesConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("shopshelves");
    private static final Path CONFIG_FILE = CONFIG_PATH.resolve("config.json");
    private static ShopshelvesConfig instance = new ShopshelvesConfig();
    public static final float BASE_ENTITY_RENDER_DISTANCE = 96.0f;
    @SerializedName(value="message_delivery_mode")
    private MessageDeliveryMode messageDeliveryMode = MessageDeliveryMode.ACTIONBAR;
    @SerializedName(value="text_display_render_distance_blocks")
    private int textDisplayRenderDistanceBlocks = 16;
    @SerializedName(value="price_display_render_distance_blocks")
    private int priceDisplayRenderDistanceBlocks = 5;
    @SerializedName(value="price_display_mode")
    private PriceDisplayMode priceDisplayMode = PriceDisplayMode.TRIPLEPRICE;
    @SerializedName(value="round_off_display_prices")
    private boolean roundOffDisplayPrices = true;
    @SerializedName(value="main_display_scale")
    private int mainDisplayScale = 5;
    @SerializedName(value="amount_display_scale")
    private int amountDisplayScale = 5;
    @SerializedName(value="price_display_scale")
    private int priceDisplayScale = 5;
    @SerializedName(value="default_player_shelf_limit")
    private int defaultPlayerShelfLimit = 2;

    private ShopshelvesConfig() {
    }

    public static void load() {
        if (!Files.exists(CONFIG_FILE, new LinkOption[0])) {
            ShopshelvesConfig.save();
            return;
        }
        try (FileReader reader = new FileReader(CONFIG_FILE.toFile());){
            instance = (ShopshelvesConfig)GSON.fromJson((Reader)reader, ShopshelvesConfig.class);
            if (instance == null) {
                instance = new ShopshelvesConfig();
                ShopshelvesConfig.save();
            }
            ShopshelvesConfig.instance.mainDisplayScale = ShopshelvesConfig.clampScale(ShopshelvesConfig.instance.mainDisplayScale);
            ShopshelvesConfig.instance.amountDisplayScale = ShopshelvesConfig.clampScale(ShopshelvesConfig.instance.amountDisplayScale);
            ShopshelvesConfig.instance.priceDisplayScale = ShopshelvesConfig.clampScale(ShopshelvesConfig.instance.priceDisplayScale);
        }
        catch (IOException e) {
            Shopshelves.LOGGER.error("Failed to load shopshelves config.json", (Throwable)e);
            instance = new ShopshelvesConfig();
        }
    }

    public static void save() {
        try {
            Files.createDirectories(CONFIG_PATH, new FileAttribute[0]);
            try (FileWriter writer = new FileWriter(CONFIG_FILE.toFile());){
                GSON.toJson((Object)instance, (Appendable)writer);
            }
        }
        catch (IOException e) {
            Shopshelves.LOGGER.error("Failed to save shopshelves config.json", (Throwable)e);
        }
    }

    private static int clampScale(int value) {
        return Math.max(1, Math.min(10, value));
    }

    public static ShopshelvesConfig get() {
        return instance;
    }

    public MessageDeliveryMode getMessageDeliveryMode() {
        return this.messageDeliveryMode;
    }

    public void setMessageDeliveryMode(MessageDeliveryMode mode) {
        this.messageDeliveryMode = mode;
    }

    public int getTextDisplayRenderDistanceBlocks() {
        return this.textDisplayRenderDistanceBlocks;
    }

    public int getPriceDisplayRenderDistanceBlocks() {
        return this.priceDisplayRenderDistanceBlocks;
    }

    public PriceDisplayMode getPriceDisplayMode() {
        return this.priceDisplayMode;
    }

    public void setPriceDisplayMode(PriceDisplayMode mode) {
        this.priceDisplayMode = mode;
    }

    public boolean shouldRoundOffDisplayPrices() {
        return this.roundOffDisplayPrices;
    }

    public int getMainDisplayScale() {
        return this.mainDisplayScale;
    }

    public int getAmountDisplayScale() {
        return this.amountDisplayScale;
    }

    public int getPriceDisplayScale() {
        return this.priceDisplayScale;
    }

    public int getDefaultPlayerShelfLimit() {
        return this.defaultPlayerShelfLimit;
    }

    public static enum MessageDeliveryMode {
        CHAT,
        ACTIONBAR,
        BOTH;

    }

    public static enum PriceDisplayMode {
        SINGLEPRICE,
        TRIPLEPRICE;

    }
}

