/*
 * Decompiled with CFR 0.152.
 */
package me.andy.shopshelves.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.andy.shopshelves.Shopshelves;
import me.andy.shopshelves.logic.ShopHelper;
import me.andy.shopshelves.util.ShopShelf;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class ShopDataManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().enableComplexMapKeySerialization().create();
    private static final String FILE_NAME = "shopshelves.json";
    private static final ShopDataManager INSTANCE = new ShopDataManager();
    private WorldSaveData worldData = new WorldSaveData();

    private ShopDataManager() {
    }

    public static ShopDataManager get() {
        return INSTANCE;
    }

    public Map<String, Map<class_2338, List<UUID>>> getAllShops() {
        return this.worldData.shops;
    }

    private Path getConfigFile(MinecraftServer server) {
        return server.method_27050(class_5218.field_24188).resolve("data").resolve(FILE_NAME);
    }

    public void load(MinecraftServer server) {
        Path configFile = this.getConfigFile(server);
        if (!Files.exists(configFile, new LinkOption[0])) {
            this.worldData = new WorldSaveData();
            return;
        }
        try (FileReader reader = new FileReader(configFile.toFile());){
            Type type = new TypeToken<WorldSaveData>(this){}.getType();
            WorldSaveData loadedData = (WorldSaveData)GSON.fromJson((Reader)reader, type);
            if (loadedData != null) {
                this.worldData = loadedData;
                if (this.worldData.shops == null) {
                    this.worldData.shops = new ConcurrentHashMap<String, Map<class_2338, List<UUID>>>();
                }
                if (this.worldData.linkedContainers == null) {
                    this.worldData.linkedContainers = new ConcurrentHashMap<String, Map<class_2338, class_2338>>();
                }
            } else {
                this.worldData = new WorldSaveData();
            }
            int shopCount = this.worldData.shops.values().stream().mapToInt(Map::size).sum();
            int linkCount = this.worldData.linkedContainers.values().stream().mapToInt(Map::size).sum();
            Shopshelves.LOGGER.info("Loaded {} shop entries and {} linked containers from shopshelves.json", (Object)shopCount, (Object)linkCount);
        }
        catch (JsonSyntaxException | IOException e) {
            Shopshelves.LOGGER.error("Failed to load shopshelves.json, it might be corrupted. A new file will be created after saving.", e);
            this.worldData = new WorldSaveData();
        }
    }

    public void save(MinecraftServer server) {
        Path configFile = this.getConfigFile(server);
        try {
            Files.createDirectories(configFile.getParent(), new FileAttribute[0]);
            try (FileWriter writer = new FileWriter(configFile.toFile());){
                GSON.toJson((Object)this.worldData, (Appendable)writer);
            }
        }
        catch (IOException e) {
            Shopshelves.LOGGER.error("Failed to save shopshelves.json", (Throwable)e);
        }
    }

    public void setShopDisplayUuids(class_3218 world, class_2338 pos, List<UUID> textDisplayUuids) {
        String worldId = world.method_27983().method_29177().toString();
        this.worldData.shops.computeIfAbsent(worldId, k -> new HashMap()).put(pos, textDisplayUuids);
    }

    public Optional<List<UUID>> removeShopDisplayUuids(class_3218 world, class_2338 pos) {
        String worldId = world.method_27983().method_29177().toString();
        Map<class_2338, List<UUID>> worldShops = this.worldData.shops.get(worldId);
        if (worldShops != null) {
            return Optional.ofNullable(worldShops.remove(pos));
        }
        return Optional.empty();
    }

    public int countPlayerShelves(UUID playerUuid, MinecraftServer server) {
        int count = 0;
        for (Map.Entry<String, Map<class_2338, List<UUID>>> worldEntry : this.worldData.shops.entrySet()) {
            class_2960 worldIdentifier = class_2960.method_60654((String)worldEntry.getKey());
            class_5321 worldKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)worldIdentifier);
            class_3218 world = server.method_3847(worldKey);
            if (world == null) continue;
            for (class_2338 pos : worldEntry.getValue().keySet()) {
                ShopShelf shopShelf;
                class_2586 be;
                if (!world.method_22340(pos) || !((be = world.method_8321(pos)) instanceof ShopShelf) || (shopShelf = (ShopShelf)be).getShopMode() != ShopHelper.ShopMode.PLAYERSHELF || !shopShelf.getOwner().map(uuid -> uuid.equals(playerUuid)).orElse(false).booleanValue()) continue;
                ++count;
            }
        }
        return count;
    }

    public boolean isContainerLinked(class_3218 world, class_2338 containerPos) {
        String worldId = world.method_27983().method_29177().toString();
        return this.worldData.linkedContainers.getOrDefault(worldId, Map.of()).containsKey(containerPos);
    }

    public Optional<class_2338> getShelfForContainer(class_3218 world, class_2338 containerPos) {
        String worldId = world.method_27983().method_29177().toString();
        return Optional.ofNullable((class_2338)this.worldData.linkedContainers.getOrDefault(worldId, Map.of()).get(containerPos));
    }

    public void addLink(class_3218 world, List<class_2338> containerPositions, class_2338 shelfPos) {
        String worldId = world.method_27983().method_29177().toString();
        Map worldLinks = this.worldData.linkedContainers.computeIfAbsent(worldId, k -> new HashMap());
        for (class_2338 containerPos : containerPositions) {
            worldLinks.put(containerPos, shelfPos);
        }
    }

    public void removeLink(class_3218 world, List<class_2338> containerPositions) {
        String worldId = world.method_27983().method_29177().toString();
        Map<class_2338, class_2338> worldLinks = this.worldData.linkedContainers.get(worldId);
        if (worldLinks != null) {
            for (class_2338 containerPos : containerPositions) {
                worldLinks.remove(containerPos);
            }
        }
    }

    public void clear() {
        this.worldData = new WorldSaveData();
    }

    private static class WorldSaveData {
        Map<String, Map<class_2338, List<UUID>>> shops = new ConcurrentHashMap<String, Map<class_2338, List<UUID>>>();
        Map<String, Map<class_2338, class_2338>> linkedContainers = new ConcurrentHashMap<String, Map<class_2338, class_2338>>();

        private WorldSaveData() {
        }
    }
}

