/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace;

import com.mojang.logging.LogUtils;
import net.biorfn.compressedfurnace.ClientSetup;
import net.biorfn.compressedfurnace.config.Config;
import net.biorfn.compressedfurnace.network.Messages;
import net.biorfn.compressedfurnace.registries.CapabilitiesRegistries;
import net.biorfn.compressedfurnace.registries.MultiFurnaceTabs;
import net.biorfn.compressedfurnace.registries.MultiFurnaceTieredItems;
import net.biorfn.compressedfurnace.util.RecipeValidation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.slf4j.Logger;

@Mod(value="compressedfurnace")
public class CompressedFurnace {
    public static final String MODID = "compressedfurnace";
    public static final Logger LOGGER = LogUtils.getLogger();

    public CompressedFurnace(IEventBus modEventBus, ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(ClientSetup::init);
        modEventBus.addListener(CapabilitiesRegistries::registerCapabilities);
        modEventBus.register(Messages.class);
        MultiFurnaceTieredItems.init(modEventBus);
        MultiFurnaceTabs.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        RecipeManager recipeManager = event.getServer().getRecipeManager();
        ServerLevel level = event.getServer().getLevel(Level.OVERWORLD);
        RecipeValidation.validateRecipesOnRegistration(recipeManager, (Level)level);
    }
}

