/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.blocks;

import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.biorfn.compressedfurnace.entity.AbstractCompressedEntityBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCompressedBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING;
    public static final BooleanProperty LIT;
    public final String TYPE;
    protected final boolean isPowered;
    protected static final double FLAME_PARTICLE_OFFSET = 0.52;
    protected static final double SMOKE_PARTICLE_OFFSET = 0.6;
    protected static final BlockState FALLBACK_BLOCK_STATE;

    public AbstractCompressedBlock(BlockBehaviour.Properties properties, String type, boolean isPowered) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
        this.TYPE = type;
        this.isPowered = isPowered;
    }

    protected MapCodec<? extends AbstractCompressedBlock> codec() {
        return null;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        this.openContainer(level, pos, player);
        return InteractionResult.CONSUME;
    }

    protected abstract void openContainer(Level var1, BlockPos var2, Player var3);

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockentity = level.getBlockEntity(pos);
            if (blockentity instanceof AbstractCompressedEntityBlock) {
                AbstractCompressedEntityBlock abstractCompressedEntityBlock = (AbstractCompressedEntityBlock)blockentity;
                if (level instanceof ServerLevel) {
                    Containers.dropContents((Level)level, (BlockPos)pos, (Container)abstractCompressedEntityBlock);
                    abstractCompressedEntityBlock.getRecipesToAwardAndPopExperience((ServerLevel)level, Vec3.atCenterOf((Vec3i)pos));
                }
                super.onRemove(state, level, pos, newState, isMoving);
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            } else {
                super.onRemove(state, level, pos, newState, isMoving);
            }
        }
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)level.getBlockEntity(pos));
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, LIT});
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createTicker(Level level, BlockEntityType<T> serverType, BlockEntityType<? extends AbstractCompressedEntityBlock> clientType) {
        return level.isClientSide ? null : AbstractCompressedBlock.createTickerHelper(serverType, clientType, AbstractCompressedEntityBlock::serverTick);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            if (!Objects.equals(this.TYPE, "crusher")) {
                double d0 = (double)pos.getX() + 0.5;
                double d1 = pos.getY();
                double d2 = (double)pos.getZ() + 0.5;
                if (!this.isPowered && random.nextDouble() < 0.1) {
                    level.playLocalSound(d0, d1, d2, SoundEvents.FURNACE_FIRE_CRACKLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                }
                Direction direction = (Direction)state.getValue((Property)FACING);
                Direction.Axis direction$axis = direction.getAxis();
                double d4 = random.nextDouble() * 0.6 - 0.3;
                double d5 = direction$axis == Direction.Axis.X ? (double)direction.getStepX() * 0.52 : d4;
                double d6 = random.nextDouble() * 6.0 / 16.0;
                double d7 = direction$axis == Direction.Axis.Z ? (double)direction.getStepZ() * 0.52 : d4;
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
                if (!this.isPowered) {
                    level.addParticle((ParticleOptions)ParticleTypes.FLAME, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
                }
            } else if (!this.isPowered) {
                this.spawnParticleEffects(level, state, pos, random);
                this.playCrushingSounds(random, pos, level);
            } else {
                this.spawnParticleEffects(level, state, pos, random);
            }
        }
    }

    protected void spawnParticleEffects(Level level, BlockState state, BlockPos pos, RandomSource random) {
        double x = (double)pos.getX() + 0.5;
        double y = pos.getY();
        double z = (double)pos.getZ() + 0.5;
        Direction direction = (Direction)state.getValue((Property)FACING);
        for (ParticleType particleType : List.of(ParticleTypes.SMOKE, ParticleTypes.FLAME)) {
            this.spawnDirectionalParticle(level, direction, random, x, y, z, particleType);
        }
        this.spawnCrushingParticle(level, state, pos, random);
    }

    protected void spawnDirectionalParticle(Level level, Direction direction, RandomSource random, double x, double y, double z, ParticleType<?> particleType) {
        double xOffset = direction.getAxis() == Direction.Axis.X ? (double)direction.getStepX() * 0.52 : random.nextDouble() * 0.6 - 0.3;
        double zOffset = direction.getAxis() == Direction.Axis.Z ? (double)direction.getStepZ() * 0.52 : random.nextDouble() * 0.6 - 0.3;
        double heightOffset = random.nextDouble() * 6.0 / 16.0;
        this.addBlockParticle(level, particleType, x + xOffset, y + heightOffset, z + zOffset);
    }

    protected void spawnCrushingParticle(Level level, BlockState state, BlockPos pos, RandomSource random) {
        BlockState blockBeingCrushed = this.getBlockBeingCrushed(level, pos);
        Direction direction = (Direction)state.getValue((Property)FACING);
        double x = (double)pos.getX() + 0.5 + (double)direction.getStepX() * 0.52;
        double y = (double)pos.getY() + 0.75;
        double z = (double)pos.getZ() + 0.5 + (double)direction.getStepZ() * 0.52;
        x += random.nextDouble() * 0.2 - 0.1;
        y += random.nextDouble() * 0.1;
        z += random.nextDouble() * 0.2 - 0.1;
        assert (blockBeingCrushed != null);
        level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, blockBeingCrushed), x, y, z, random.nextGaussian() * 0.005, 0.1, random.nextGaussian() * 0.005);
    }

    protected void playCrushingSounds(RandomSource random, BlockPos pos, Level level) {
        if (random.nextDouble() < 0.1) {
            level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, SoundEvents.FURNACE_FIRE_CRACKLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
    }

    protected void addBlockParticle(Level level, ParticleType<?> type, double x, double y, double z) {
        level.addParticle((ParticleOptions)type, x, y, z, 0.0, 0.0, 0.0);
    }

    @Nullable
    protected BlockState getBlockBeingCrushed(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AbstractCompressedEntityBlock) {
            AbstractCompressedEntityBlock blockEntity2 = (AbstractCompressedEntityBlock)blockEntity;
            ArrayList<BlockState> possibleParticles = new ArrayList<BlockState>();
            for (int inputSlot : blockEntity2.SLOTS_FOR_INPUT) {
                Block block;
                ItemStack inputStack = (ItemStack)blockEntity2.items.get(inputSlot);
                if (inputStack.isEmpty() || (block = Block.byItem((Item)inputStack.getItem())) == Blocks.AIR) continue;
                possibleParticles.add(block.defaultBlockState());
            }
            if (!possibleParticles.isEmpty()) {
                return (BlockState)possibleParticles.get(level.random.nextInt(possibleParticles.size()));
            }
        }
        return FALLBACK_BLOCK_STATE;
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, pos, oldState, movedByPiston);
        if (!level.isClientSide) {
            level.updateNeighborsAt(pos, state.getBlock());
            for (Direction direction : Direction.values()) {
                level.updateNeighborsAt(pos.relative(direction), state.getBlock());
            }
        }
    }

    static {
        FALLBACK_BLOCK_STATE = Blocks.STONE.defaultBlockState();
        FACING = HorizontalDirectionalBlock.FACING;
        LIT = BlockStateProperties.LIT;
    }
}

