/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.blocks.crusher;

import com.mojang.serialization.MapCodec;
import net.biorfn.compressedfurnace.blocks.AbstractCompressedBlock;
import net.biorfn.compressedfurnace.entity.crusher.DoubleCrusherEntity;
import net.biorfn.compressedfurnace.registries.MultiFurnaceTieredItems;
import net.minecraft.core.BlockPos;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class DoubleCrusherBlock
extends AbstractCompressedBlock {
    public static final String ID = "double_compressed_crusher";
    public static final MapCodec<DoubleCrusherBlock> CODEC = DoubleCrusherBlock.simpleCodec(DoubleCrusherBlock::new);

    protected MapCodec<? extends DoubleCrusherBlock> codec() {
        return CODEC;
    }

    public DoubleCrusherBlock(BlockBehaviour.Properties properties) {
        super(properties, "crusher", false);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new DoubleCrusherEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return DoubleCrusherBlock.createTicker(level, blockEntityType, MultiFurnaceTieredItems.DOUBLE_COMPRESSED_CRUSHER_TILE.get());
    }

    @Override
    protected void openContainer(Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof DoubleCrusherEntity) {
            DoubleCrusherEntity doubleCrusherEntity = (DoubleCrusherEntity)blockEntity;
            player.openMenu((MenuProvider)doubleCrusherEntity);
        }
    }
}

