/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.blocks.powered.crusher;

import com.mojang.serialization.MapCodec;
import net.biorfn.compressedfurnace.blocks.powered.AbstractCompressedPoweredBlock;
import net.biorfn.compressedfurnace.entity.powered.crusher.PoweredCompressedCrusherBlockEntity;
import net.biorfn.compressedfurnace.registries.MultiFurnaceTieredItems;
import net.minecraft.core.BlockPos;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class PoweredCompressedCrusherBlock
extends AbstractCompressedPoweredBlock {
    public static final String ID = "powered_compressed_crusher";
    public static final MapCodec<PoweredCompressedCrusherBlock> CODEC = PoweredCompressedCrusherBlock.simpleCodec(PoweredCompressedCrusherBlock::new);

    protected MapCodec<? extends PoweredCompressedCrusherBlock> codec() {
        return CODEC;
    }

    public PoweredCompressedCrusherBlock(BlockBehaviour.Properties properties) {
        super(properties, "crusher", true);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new PoweredCompressedCrusherBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return PoweredCompressedCrusherBlock.createPoweredTicker(level, blockEntityType, MultiFurnaceTieredItems.POWERED_COMPRESSED_CRUSHER_TILE.get());
    }

    @Override
    protected void openContainer(Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof PoweredCompressedCrusherBlockEntity) {
            PoweredCompressedCrusherBlockEntity poweredCompressedCrusherBlockEntity = (PoweredCompressedCrusherBlockEntity)blockEntity;
            player.openMenu((MenuProvider)poweredCompressedCrusherBlockEntity);
        }
    }
}

