/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.blocks.powered.furnace;

import com.mojang.serialization.MapCodec;
import net.biorfn.compressedfurnace.blocks.powered.AbstractCompressedPoweredBlock;
import net.biorfn.compressedfurnace.entity.powered.furnace.PoweredCompressedFurnaceBlockEntity;
import net.biorfn.compressedfurnace.registries.MultiFurnaceTieredItems;
import net.minecraft.core.BlockPos;
import net.minecraft.stats.Stats;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class PoweredCompressedFurnaceBlock
extends AbstractCompressedPoweredBlock {
    public static final String ID = "powered_compressed_furnace";
    public static final MapCodec<PoweredCompressedFurnaceBlock> CODEC = PoweredCompressedFurnaceBlock.simpleCodec(PoweredCompressedFurnaceBlock::new);

    protected MapCodec<? extends PoweredCompressedFurnaceBlock> codec() {
        return CODEC;
    }

    public PoweredCompressedFurnaceBlock(BlockBehaviour.Properties properties) {
        super(properties, "furnace", true);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new PoweredCompressedFurnaceBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return PoweredCompressedFurnaceBlock.createPoweredTicker(level, blockEntityType, MultiFurnaceTieredItems.POWERED_COMPRESSED_FURNACE_TILE.get());
    }

    @Override
    protected void openContainer(Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof PoweredCompressedFurnaceBlockEntity) {
            PoweredCompressedFurnaceBlockEntity poweredCompressedFurnaceBlockEntity = (PoweredCompressedFurnaceBlockEntity)blockEntity;
            player.openMenu((MenuProvider)poweredCompressedFurnaceBlockEntity);
            player.awardStat(Stats.INTERACT_WITH_FURNACE);
        }
    }
}

