/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.blocks.powered.furnace;

import com.mojang.serialization.MapCodec;
import net.biorfn.compressedfurnace.blocks.powered.AbstractCompressedPoweredBlock;
import net.biorfn.compressedfurnace.entity.powered.furnace.PoweredDoubleCompressedFurnaceBlockEntity;
import net.biorfn.compressedfurnace.registries.MultiFurnaceTieredItems;
import net.minecraft.core.BlockPos;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class PoweredDoubleCompressedFurnaceBlock
extends AbstractCompressedPoweredBlock {
    public static final String ID = "powered_double_compressed_furnace";
    public static final MapCodec<PoweredDoubleCompressedFurnaceBlock> CODEC = PoweredDoubleCompressedFurnaceBlock.simpleCodec(PoweredDoubleCompressedFurnaceBlock::new);

    protected MapCodec<? extends PoweredDoubleCompressedFurnaceBlock> codec() {
        return CODEC;
    }

    public PoweredDoubleCompressedFurnaceBlock(BlockBehaviour.Properties properties) {
        super(properties, "furnace", true);
    }

    @Override
    protected void openContainer(Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof PoweredDoubleCompressedFurnaceBlockEntity) {
            PoweredDoubleCompressedFurnaceBlockEntity poweredDoubleCompressedFurnaceBlockEntity = (PoweredDoubleCompressedFurnaceBlockEntity)blockEntity;
            player.openMenu((MenuProvider)poweredDoubleCompressedFurnaceBlockEntity);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new PoweredDoubleCompressedFurnaceBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return PoweredDoubleCompressedFurnaceBlock.createPoweredTicker(level, blockEntityType, MultiFurnaceTieredItems.POWERED_DOUBLE_COMPRESSED_FURNACE_TILE.get());
    }
}

