/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.data;

import net.biorfn.compressedfurnace.CompressedFurnace;
import net.biorfn.compressedfurnace.registries.MultiFurnaceTieredItems;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;

public class MultiFurnaceItemsModelProvider
extends ItemModelProvider {
    public MultiFurnaceItemsModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "compressedfurnace", existingFileHelper);
    }

    protected void registerModels() {
        CompressedFurnace.LOGGER.info("Registering Items");
        this.basicItem((Item)MultiFurnaceTieredItems.RAW_SCRAP.get());
    }

    private void simpleModItem() {
        MultiFurnaceTieredItems.ITEMS.getEntries().forEach(itemRegistryObject -> {
            String itemName = itemRegistryObject.getId().getPath();
            ((ItemModelBuilder)this.withExistingParent(itemName, this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + itemName));
        });
    }

    private void simpleModBlockItem(DeferredHolder<Item, ? extends BlockItem> block) {
        ResourceLocation itemName = block.getId();
        this.simpleBlockItem(itemName);
    }

    private void simpleItem(DeferredItem<?> deferredItem) {
        String itemName = deferredItem.getRegisteredName().replace("multifurnace:", "");
        ((ItemModelBuilder)this.withExistingParent(itemName, this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + itemName));
    }
}

