/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.data;

import java.util.concurrent.CompletableFuture;
import net.biorfn.compressedfurnace.recipes.CrusherRecipeBuilder;
import net.biorfn.compressedfurnace.recipes.GeneratorRecipeBuilder;
import net.biorfn.compressedfurnace.registries.MultiFurnaceTieredItems;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import net.neoforged.neoforge.registries.DeferredHolder;

public class MultiFurnaceRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public MultiFurnaceRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        this.crusherRecipes(recipeOutput);
        this.blockRecipes(recipeOutput);
        this.itemRecipes(recipeOutput);
        this.smeltingItemRecipes(recipeOutput);
        this.generatorRecipes(recipeOutput);
    }

    private void blockRecipes(RecipeOutput recipeOutput) {
        this.addT1Fueled(recipeOutput, MultiFurnaceTieredItems.COMPRESSED_FURNACE, (ItemLike)Items.COBBLESTONE, (ItemLike)Items.FURNACE, (ItemLike)Items.COBBLESTONE, "compressed_furnace");
        this.addT2Fueled(recipeOutput, MultiFurnaceTieredItems.DOUBLE_COMPRESSED_FURNACE, (ItemLike)Items.COBBLESTONE, (ItemLike)MultiFurnaceTieredItems.COMPRESSED_FURNACE.get(), "double_compressed_furnace", false);
        this.addT3Fueled(recipeOutput, MultiFurnaceTieredItems.TRIPLE_COMPRESSED_FURNACE, (ItemLike)Items.COBBLESTONE, (ItemLike)MultiFurnaceTieredItems.DOUBLE_COMPRESSED_FURNACE.get(), "triple_compressed_furnace", false);
        this.addT1Fueled(recipeOutput, MultiFurnaceTieredItems.COMPRESSED_CRUSHER, (ItemLike)Items.FLINT, (ItemLike)Items.IRON_INGOT, (ItemLike)MultiFurnaceTieredItems.COMPRESSED_FURNACE.get(), "compressed_crusher");
        this.addT2Fueled(recipeOutput, MultiFurnaceTieredItems.DOUBLE_COMPRESSED_CRUSHER, (ItemLike)Items.FLINT, (ItemLike)MultiFurnaceTieredItems.COMPRESSED_CRUSHER.get(), "double_compressed_crusher", false);
        this.addT3Fueled(recipeOutput, MultiFurnaceTieredItems.TRIPLE_COMPRESSED_CRUSHER, (ItemLike)Items.FLINT, (ItemLike)MultiFurnaceTieredItems.DOUBLE_COMPRESSED_CRUSHER.get(), "triple_compressed_crusher", false);
        this.addT1Fueled(recipeOutput, MultiFurnaceTieredItems.COMPRESSED_BLAST_FURNACE, (ItemLike)Items.COBBLESTONE, (ItemLike)Items.BLAST_FURNACE, (ItemLike)Items.COBBLESTONE, "compressed_blast_furnace");
        this.addT2Fueled(recipeOutput, MultiFurnaceTieredItems.DOUBLE_COMPRESSED_BLAST_FURNACE, (ItemLike)Items.COBBLESTONE, (ItemLike)MultiFurnaceTieredItems.COMPRESSED_BLAST_FURNACE.get(), "double_compressed_blast_furnace", true);
        this.addT3Fueled(recipeOutput, MultiFurnaceTieredItems.TRIPLE_COMPRESSED_BLAST_FURNACE, (ItemLike)Items.COBBLESTONE, (ItemLike)MultiFurnaceTieredItems.DOUBLE_COMPRESSED_BLAST_FURNACE.get(), "triple_compressed_blast_furnace", true);
        this.addT1Powered(recipeOutput, MultiFurnaceTieredItems.POWERED_COMPRESSED_FURNACE, MultiFurnaceTieredItems.COMPRESSED_FURNACE, "powered_compressed_furnace");
        this.addT2Powered(recipeOutput, MultiFurnaceTieredItems.POWERED_DOUBLE_COMPRESSED_FURNACE, MultiFurnaceTieredItems.POWERED_COMPRESSED_FURNACE, "powered_double_compressed_furnace");
        this.addT3Powered(recipeOutput, MultiFurnaceTieredItems.POWERED_TRIPLE_COMPRESSED_FURNACE, MultiFurnaceTieredItems.POWERED_DOUBLE_COMPRESSED_FURNACE, "powered_triple_compressed_furnace");
        this.addT1Powered(recipeOutput, MultiFurnaceTieredItems.POWERED_COMPRESSED_CRUSHER, MultiFurnaceTieredItems.COMPRESSED_CRUSHER, "powered_compressed_crusher");
        this.addT2Powered(recipeOutput, MultiFurnaceTieredItems.POWERED_DOUBLE_COMPRESSED_CRUSHER, MultiFurnaceTieredItems.POWERED_COMPRESSED_CRUSHER, "powered_double_compressed_crusher");
        this.addT3Powered(recipeOutput, MultiFurnaceTieredItems.POWERED_TRIPLE_COMPRESSED_CRUSHER, MultiFurnaceTieredItems.POWERED_DOUBLE_COMPRESSED_CRUSHER, "powered_triple_compressed_crusher");
        this.addT1Powered(recipeOutput, MultiFurnaceTieredItems.POWERED_COMPRESSED_BLAST_FURNACE, MultiFurnaceTieredItems.COMPRESSED_BLAST_FURNACE, "powered_compressed_blast_furnace");
        this.addT2Powered(recipeOutput, MultiFurnaceTieredItems.POWERED_DOUBLE_COMPRESSED_BLAST_FURNACE, MultiFurnaceTieredItems.POWERED_COMPRESSED_BLAST_FURNACE, "powered_double_compressed_blast_furnace");
        this.addT3Powered(recipeOutput, MultiFurnaceTieredItems.POWERED_TRIPLE_COMPRESSED_BLAST_FURNACE, MultiFurnaceTieredItems.POWERED_DOUBLE_COMPRESSED_BLAST_FURNACE, "powered_triple_compressed_blast_furnace");
        this.addT1Gen(recipeOutput);
        this.addT2Gen(recipeOutput);
        this.addT3Gen(recipeOutput);
    }

    private void itemRecipes(RecipeOutput recipeOutput) {
    }

    private void crusherRecipes(RecipeOutput recipeOutput) {
        this.addCrusherItemRecipe((ItemLike)Items.IRON_ORE, (ItemLike)Items.RAW_IRON, 2, "iron", recipeOutput);
        this.addCrusherItemRecipe((ItemLike)Items.GOLD_ORE, (ItemLike)Items.RAW_GOLD, 2, "gold", recipeOutput);
        this.addCrusherItemRecipe((ItemLike)Items.COAL_ORE, (ItemLike)Items.COAL, 2, "coal", recipeOutput);
        this.addCrusherItemRecipe((ItemLike)Items.DIAMOND_ORE, (ItemLike)Items.DIAMOND, 2, "diamond", recipeOutput);
        this.addCrusherItemRecipe((ItemLike)Items.EMERALD_ORE, (ItemLike)Items.EMERALD, 2, "emerald", recipeOutput);
        this.addCrusherItemRecipe((ItemLike)Items.LAPIS_ORE, (ItemLike)Items.LAPIS_LAZULI, 4, "lapis", recipeOutput);
        this.addCrusherItemRecipe((ItemLike)Items.REDSTONE_ORE, (ItemLike)Items.REDSTONE, 4, "redstone", recipeOutput);
        this.addCrusherItemRecipe((ItemLike)Items.NETHER_QUARTZ_ORE, (ItemLike)Items.QUARTZ, 4, "quartz", recipeOutput);
        this.addCrusherItemRecipe((ItemLike)Items.NETHER_GOLD_ORE, (ItemLike)Items.RAW_GOLD, 2, "nether_gold", recipeOutput);
        this.addCrusherItemRecipe((ItemLike)Items.COPPER_ORE, (ItemLike)Items.RAW_COPPER, 2, "copper", recipeOutput);
        this.addCrusherItemRecipe((ItemLike)Items.DEEPSLATE_COAL_ORE, (ItemLike)Items.COAL, 2, "deepslate_coal", recipeOutput);
        this.addCrusherItemRecipe((ItemLike)Items.DEEPSLATE_IRON_ORE, (ItemLike)Items.RAW_IRON, 2, "deepslate_iron", recipeOutput);
        this.addCrusherItemRecipe((ItemLike)Items.DEEPSLATE_GOLD_ORE, (ItemLike)Items.RAW_GOLD, 2, "deepslate_gold", recipeOutput);
        this.addCrusherItemRecipe((ItemLike)Items.DEEPSLATE_DIAMOND_ORE, (ItemLike)Items.DIAMOND, 2, "deepslate_diamond", recipeOutput);
        this.addCrusherItemRecipe((ItemLike)Items.DEEPSLATE_EMERALD_ORE, (ItemLike)Items.EMERALD, 2, "deepslate_emerald", recipeOutput);
        this.addCrusherItemRecipe((ItemLike)Items.DEEPSLATE_LAPIS_ORE, (ItemLike)Items.LAPIS_LAZULI, 2, "deepslate_lapis", recipeOutput);
        this.addCrusherItemRecipe((ItemLike)Items.DEEPSLATE_REDSTONE_ORE, (ItemLike)Items.REDSTONE, 2, "deepslate_redstone", recipeOutput);
        this.addCrusherItemRecipe((ItemLike)Items.DEEPSLATE_COPPER_ORE, (ItemLike)Items.RAW_COPPER, 2, "deepslate_copper", recipeOutput);
        this.addCrusherItemRecipe((ItemLike)Items.ANCIENT_DEBRIS, (ItemLike)MultiFurnaceTieredItems.RAW_SCRAP.get(), 2, "ancient_debris", recipeOutput);
        this.addCrusherItemRecipe((ItemLike)Items.QUARTZ_BLOCK, (ItemLike)Items.QUARTZ, 4, "quartz_block", recipeOutput);
        this.addCrusherItemRecipe((ItemLike)Items.BLAZE_ROD, (ItemLike)Items.BLAZE_POWDER, 4, "blaze_rod", recipeOutput);
        this.addCrusherItemRecipe((ItemLike)Items.STONE, (ItemLike)Items.COBBLESTONE, 1, "stone_to_cobble", recipeOutput);
        this.addCrusherItemRecipe((ItemLike)Items.COBBLESTONE, (ItemLike)Items.GRAVEL, 1, "cobble_to_gravel", recipeOutput);
        this.addCrusherItemRecipe((ItemLike)Items.GRAVEL, (ItemLike)Items.SAND, 1, "gravel_to_sand", recipeOutput);
        this.addCrusherItemRecipe((ItemLike)Items.DEEPSLATE, (ItemLike)Items.COBBLED_DEEPSLATE, 1, "deepslate_to_cobbled", recipeOutput);
        this.addCrusherItemRecipe((ItemLike)Items.COBBLED_DEEPSLATE, (ItemLike)Items.GRAVEL, 1, "cobbled_to_gravel", recipeOutput);
        this.addCrusherItemRecipe((ItemLike)Items.DIORITE, (ItemLike)Items.GRAVEL, 1, "diorite_to_gravel", recipeOutput);
        this.addCrusherItemRecipe((ItemLike)Items.ANDESITE, (ItemLike)Items.GRAVEL, 1, "andesite_to_gravel", recipeOutput);
        this.addCrusherItemRecipe((ItemLike)Items.GRANITE, (ItemLike)Items.GRAVEL, 1, "granite_to_gravel", recipeOutput);
        this.addCrusherItemRecipe((ItemLike)Items.SANDSTONE, (ItemLike)Items.SAND, 1, "sandstone_to_sand", recipeOutput);
        this.addCrusherItemRecipe((ItemLike)Items.DRIPSTONE_BLOCK, (ItemLike)Items.POINTED_DRIPSTONE, 4, "dripstone_to_pointed_dripstone", recipeOutput);
        this.addCrusherItemRecipe((ItemLike)Items.PRISMARINE_BRICKS, (ItemLike)Items.PRISMARINE_SHARD, 9, "prismarine_bricks_to_prismarine_shard", recipeOutput);
        this.addCrusherItemRecipe((ItemLike)Items.PRISMARINE_BRICK_STAIRS, (ItemLike)Items.PRISMARINE_SHARD, 5, "prismarine_brick_stairs_to_prismarine_shard", recipeOutput);
        this.addCrusherItemRecipe((ItemLike)Items.PRISMARINE_SLAB, (ItemLike)Items.PRISMARINE_SHARD, 3, "prismarine_slab_to_prismarine_shard", recipeOutput);
        this.addCrusherItemRecipe((ItemLike)Items.PRISMARINE_STAIRS, (ItemLike)Items.PRISMARINE_SHARD, 4, "prismarine_stairs_to_prismarine_shard", recipeOutput);
        this.addCrusherItemRecipe((TagKey<Item>)ItemTags.WOOL, (ItemLike)Items.STRING, 4, "wool_to_string", recipeOutput);
        this.addCrusherItemRecipe((ItemLike)Items.HONEYCOMB_BLOCK, (ItemLike)Items.HONEYCOMB, 4, "honeycomb_block_to_honeycomb", recipeOutput);
    }

    private void generatorRecipes(RecipeOutput recipeOutput) {
    }

    private void smeltingItemRecipes(RecipeOutput recipeOutput) {
        this.smeltAndBlastItemRecipes(recipeOutput, (ItemLike)MultiFurnaceTieredItems.RAW_SCRAP.get(), RecipeCategory.MISC, (ItemLike)Items.NETHERITE_SCRAP);
        this.smeltAndBlastItemRecipes(recipeOutput, (ItemLike)Items.RAW_IRON_BLOCK, RecipeCategory.DECORATIONS, (ItemLike)Items.IRON_BLOCK);
        this.smeltAndBlastItemRecipes(recipeOutput, (ItemLike)Items.RAW_COPPER_BLOCK, RecipeCategory.DECORATIONS, (ItemLike)Items.COPPER_BLOCK);
        this.smeltAndBlastItemRecipes(recipeOutput, (ItemLike)Items.RAW_GOLD_BLOCK, RecipeCategory.DECORATIONS, (ItemLike)Items.GOLD_BLOCK);
    }

    private void smeltAndBlastItemRecipes(RecipeOutput recipeOutput, ItemLike input, RecipeCategory category, ItemLike result) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input}), (RecipeCategory)category, (ItemLike)result, (float)2.0f, (int)200).unlockedBy(MultiFurnaceRecipeProvider.getHasName((ItemLike)input), MultiFurnaceRecipeProvider.has((ItemLike)input)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"compressedfurnace", (String)("smelting/" + MultiFurnaceRecipeProvider.getHasName((ItemLike)input) + "_to_" + MultiFurnaceRecipeProvider.getHasName((ItemLike)result))));
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input}), (RecipeCategory)category, (ItemLike)result, (float)2.0f, (int)100).unlockedBy(MultiFurnaceRecipeProvider.getHasName((ItemLike)input), MultiFurnaceRecipeProvider.has((ItemLike)input)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"compressedfurnace", (String)("blasting/" + MultiFurnaceRecipeProvider.getHasName((ItemLike)input) + "_to_" + MultiFurnaceRecipeProvider.getHasName((ItemLike)result))));
    }

    private void addCrusherItemRecipe(ItemLike ingredient, ItemLike result, int count, String name, RecipeOutput recipeOutput) {
        CrusherRecipeBuilder.crusher(Ingredient.of((ItemLike[])new ItemLike[]{ingredient}), result, count, 2.0f, 200).group("crusher").unlockedBy(MultiFurnaceRecipeProvider.getHasName((ItemLike)ingredient), MultiFurnaceRecipeProvider.has((ItemLike)ingredient)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"compressedfurnace", (String)("crusher/crushed_" + name)));
    }

    private void addCrusherItemRecipe(TagKey<Item> ingredient, ItemLike result, int count, String name, RecipeOutput recipeOutput) {
        CrusherRecipeBuilder.crusher(Ingredient.of(ingredient), result, count, 2.0f, 200).group("crusher").unlockedBy(ingredient.location().toString(), MultiFurnaceRecipeProvider.has(ingredient)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"compressedfurnace", (String)("crusher/crushed_" + name)));
    }

    private void addGeneratorItemRecipe(ItemLike ingredient, int energy, String name, RecipeOutput recipeOutput) {
        GeneratorRecipeBuilder.generator(Ingredient.of((ItemLike[])new ItemLike[]{ingredient}), energy).group("generator").unlockedBy(MultiFurnaceRecipeProvider.getHasName((ItemLike)ingredient), MultiFurnaceRecipeProvider.has((ItemLike)ingredient)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"compressedfurnace", (String)("generator/" + name + "_to_energy")));
    }

    private void addT1Fueled(RecipeOutput recipeOutput, DeferredHolder<Block, ? extends BaseEntityBlock> result, ItemLike topCenter, ItemLike centerSides, ItemLike core, String name) {
        this.addFuelPowered(recipeOutput, result, (ItemLike)Items.COBBLESTONE, topCenter, centerSides, (ItemLike)Items.COBBLESTONE, core, name);
    }

    private void addT2Fueled(RecipeOutput recipeOutput, DeferredHolder<Block, ? extends BaseEntityBlock> result, ItemLike topCenter, ItemLike core, String name, boolean isBlast) {
        if (isBlast) {
            this.addFuelPowered(recipeOutput, result, (ItemLike)Items.COBBLESTONE, topCenter, (ItemLike)Items.BLAST_FURNACE, (ItemLike)Items.COBBLED_DEEPSLATE, core, name);
        } else {
            this.addFuelPowered(recipeOutput, result, (ItemLike)Items.COBBLESTONE, topCenter, (ItemLike)Items.FURNACE, (ItemLike)Items.COBBLED_DEEPSLATE, core, name);
        }
    }

    private void addT3Fueled(RecipeOutput recipeOutput, DeferredHolder<Block, ? extends BaseEntityBlock> result, ItemLike topCenter, ItemLike core, String name, boolean isBlast) {
        if (isBlast) {
            this.addFuelPowered(recipeOutput, result, (ItemLike)Items.COBBLED_DEEPSLATE, topCenter, (ItemLike)Items.BLAST_FURNACE, (ItemLike)Items.COBBLED_DEEPSLATE, core, name);
        } else {
            this.addFuelPowered(recipeOutput, result, (ItemLike)Items.COBBLED_DEEPSLATE, topCenter, (ItemLike)Items.FURNACE, (ItemLike)Items.COBBLED_DEEPSLATE, core, name);
        }
    }

    private void addFuelPowered(RecipeOutput recipeOutput, DeferredHolder<Block, ? extends BaseEntityBlock> result, ItemLike A_A, ItemLike _B_, ItemLike C_C, ItemLike D_D, ItemLike _E_, String name) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)result.get())).pattern("ABA").pattern("CEC").pattern("DBD").define(Character.valueOf('A'), A_A).define(Character.valueOf('B'), _B_).define(Character.valueOf('E'), _E_).define(Character.valueOf('C'), C_C).define(Character.valueOf('D'), D_D).unlockedBy(MultiFurnaceRecipeProvider.getHasName((ItemLike)A_A), MultiFurnaceRecipeProvider.has((ItemLike)A_A)).unlockedBy(MultiFurnaceRecipeProvider.getHasName((ItemLike)_B_), MultiFurnaceRecipeProvider.has((ItemLike)_B_)).unlockedBy(MultiFurnaceRecipeProvider.getHasName((ItemLike)C_C), MultiFurnaceRecipeProvider.has((ItemLike)C_C)).unlockedBy(MultiFurnaceRecipeProvider.getHasName((ItemLike)D_D), MultiFurnaceRecipeProvider.has((ItemLike)D_D)).unlockedBy(MultiFurnaceRecipeProvider.getHasName((ItemLike)_E_), MultiFurnaceRecipeProvider.has((ItemLike)_E_)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"compressedfurnace", (String)name));
    }

    private void addT1Powered(RecipeOutput recipeOutput, DeferredHolder<Block, ? extends BaseEntityBlock> result, DeferredHolder<Block, ? extends BaseEntityBlock> X, String name) {
        this.addPowered(recipeOutput, result, X, MultiFurnaceTieredItems.COMPRESSED_GENERATOR, (ItemLike)Items.IRON_INGOT, name);
    }

    private void addT2Powered(RecipeOutput recipeOutput, DeferredHolder<Block, ? extends BaseEntityBlock> result, DeferredHolder<Block, ? extends BaseEntityBlock> X, String name) {
        this.addPowered(recipeOutput, result, X, MultiFurnaceTieredItems.DOUBLE_COMPRESSED_GENERATOR, (ItemLike)Items.GOLD_INGOT, name);
    }

    private void addT3Powered(RecipeOutput recipeOutput, DeferredHolder<Block, ? extends BaseEntityBlock> result, DeferredHolder<Block, ? extends BaseEntityBlock> X, String name) {
        this.addPowered(recipeOutput, result, X, MultiFurnaceTieredItems.TRIPLE_COMPRESSED_GENERATOR, (ItemLike)Items.DIAMOND, name);
    }

    private void addPowered(RecipeOutput recipeOutput, DeferredHolder<Block, ? extends BaseEntityBlock> block, DeferredHolder<Block, ? extends BaseEntityBlock> X, DeferredHolder<Block, ? extends BaseEntityBlock> gen, ItemLike item, String name) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)block.get())).pattern("III").pattern("GXG").pattern("III").define(Character.valueOf('G'), (ItemLike)gen.get()).define(Character.valueOf('I'), item).define(Character.valueOf('X'), (ItemLike)X.get()).unlockedBy(MultiFurnaceRecipeProvider.getHasName((ItemLike)item), MultiFurnaceRecipeProvider.has((ItemLike)item)).unlockedBy(MultiFurnaceRecipeProvider.getHasName((ItemLike)((ItemLike)X.get())), MultiFurnaceRecipeProvider.has((ItemLike)((ItemLike)X.get()))).unlockedBy(MultiFurnaceRecipeProvider.getHasName((ItemLike)((ItemLike)gen.get())), MultiFurnaceRecipeProvider.has((ItemLike)((ItemLike)gen.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"compressedfurnace", (String)name));
    }

    private void addT1Gen(RecipeOutput recipeOutput) {
        this.addGen(recipeOutput, MultiFurnaceTieredItems.COMPRESSED_GENERATOR, (ItemLike)Items.GOLD_INGOT, (ItemLike)Items.GOLD_INGOT, (ItemLike)Items.REDSTONE, (ItemLike)MultiFurnaceTieredItems.COMPRESSED_FURNACE.get(), "compressed_generator");
    }

    private void addT2Gen(RecipeOutput recipeOutput) {
        this.addGen(recipeOutput, MultiFurnaceTieredItems.DOUBLE_COMPRESSED_GENERATOR, (ItemLike)Items.GOLD_BLOCK, (ItemLike)Items.GOLD_BLOCK, (ItemLike)Items.REDSTONE_BLOCK, (ItemLike)MultiFurnaceTieredItems.COMPRESSED_GENERATOR.get(), "double_compressed_generator");
    }

    private void addT3Gen(RecipeOutput recipeOutput) {
        this.addGen(recipeOutput, MultiFurnaceTieredItems.TRIPLE_COMPRESSED_GENERATOR, (ItemLike)Items.GOLD_BLOCK, (ItemLike)Items.DIAMOND, (ItemLike)Items.REDSTONE_BLOCK, (ItemLike)MultiFurnaceTieredItems.DOUBLE_COMPRESSED_GENERATOR.get(), "triple_compressed_generator");
    }

    private void addGen(RecipeOutput recipeOutput, DeferredHolder<Block, ? extends BaseEntityBlock> result, ItemLike g, ItemLike d, ItemLike r, ItemLike core, String name) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)result.get())).pattern("GDG").pattern("RFR").pattern("GDG").define(Character.valueOf('G'), g).define(Character.valueOf('D'), d).define(Character.valueOf('R'), r).define(Character.valueOf('F'), core).unlockedBy(MultiFurnaceRecipeProvider.getHasName((ItemLike)g), MultiFurnaceRecipeProvider.has((ItemLike)g)).unlockedBy(MultiFurnaceRecipeProvider.getHasName((ItemLike)r), MultiFurnaceRecipeProvider.has((ItemLike)r)).unlockedBy(MultiFurnaceRecipeProvider.getHasName((ItemLike)d), MultiFurnaceRecipeProvider.has((ItemLike)d)).unlockedBy(MultiFurnaceRecipeProvider.getHasName((ItemLike)core), MultiFurnaceRecipeProvider.has((ItemLike)core)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"compressedfurnace", (String)name));
    }
}

