/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.menu.generator;

import net.biorfn.compressedfurnace.entity.generator.GeneratorBlockEntity;
import net.biorfn.compressedfurnace.menu.slots.GeneratorFuelSlot;
import net.biorfn.compressedfurnace.recipes.GeneratorRecipe;
import net.biorfn.compressedfurnace.registries.MultiFurnaceTieredItems;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;

public abstract class GeneratorMenu
extends AbstractContainerMenu {
    public static final int GENERATOR_FUEL = 0;
    private final Container container;
    private final ContainerData data;
    protected final Level level;
    private final RecipeType<? extends GeneratorRecipe> recipeType = (RecipeType)MultiFurnaceTieredItems.GENERATOR_RECIPE_TYPE.get();
    protected String tierID;

    public GeneratorMenu(MenuType<?> menuType, int containerId, Level level, Inventory playerInventory, String tierId) {
        this(menuType, containerId, level, playerInventory, tierId, (ContainerData)new SimpleContainerData(7));
    }

    public GeneratorMenu(MenuType<?> menuType, int containerId, Level level, Inventory playerInventory, String tierId, ContainerData data) {
        super(menuType, containerId);
        Player player = playerInventory.player;
        BlockHitResult blockHitResult = (BlockHitResult)player.pick(5.0, 0.0f, false);
        BlockPos pos = blockHitResult.getBlockPos();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof GeneratorBlockEntity)) {
            throw new IllegalStateException("Container provider is not a MultiFurnaceBlockEntity in GeneratorMenu");
        }
        GeneratorBlockEntity generatorBlockEntity = (GeneratorBlockEntity)blockEntity;
        this.container = generatorBlockEntity;
        this.data = data;
        this.level = level;
        this.tierID = tierId;
        this.addSlot(new GeneratorFuelSlot(this.container, 0, 56, 40));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInventory, k, 8 + k * 18, 142));
        }
        this.addDataSlots(data);
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    public int getEnergy() {
        return this.data.get(2);
    }

    public int getMaxEnergy() {
        return this.data.get(3);
    }

    public int getLava() {
        return this.data.get(4);
    }

    public int getMaxLava() {
        return this.data.get(5);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack resultStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack stackInSlot = slot.getItem();
            resultStack = stackInSlot.copy();
            if (index == 0) {
                if (!this.moveItemStackTo(stackInSlot, this.container.getContainerSize(), this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(stackInSlot, resultStack);
            } else if (GeneratorBlockEntity.isFuel(stackInSlot) ? !this.moveItemStackTo(stackInSlot, 0, 1, false) : (index < this.slots.size() - 9 ? !this.moveItemStackTo(stackInSlot, this.slots.size() - 9, this.slots.size(), false) : !this.moveItemStackTo(stackInSlot, this.container.getContainerSize(), this.slots.size() - 9, false))) {
                return ItemStack.EMPTY;
            }
            if (stackInSlot.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (stackInSlot.getCount() == resultStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, stackInSlot);
        }
        return resultStack;
    }

    public float getLitProgress() {
        int i = this.data.get(0);
        if (i == 0) {
            i = 200;
        }
        return Mth.clamp((float)((float)this.data.get(0) / (float)i), (float)0.0f, (float)1.0f);
    }

    public float getBurnProgress() {
        int i = this.data.get(0);
        int j = this.data.get(1);
        return j != 0 && i != 0 ? Mth.clamp((float)((float)i / (float)j), (float)0.0f, (float)1.0f) : 0.0f;
    }

    public float getMaxBurn() {
        return this.data.get(6);
    }

    public boolean isLit() {
        return this.data.get(0) > 0;
    }
}

