/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.menu.powered;

import net.biorfn.compressedfurnace.entity.powered.AbstractCompressedPoweredEntityBlock;
import net.biorfn.compressedfurnace.menu.AbstractCompressedMenu;
import net.biorfn.compressedfurnace.menu.slots.ResultSlot;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;

public abstract class AbstractCompressedPoweredMenu
extends AbstractCompressedMenu {
    public final int INPUT0 = 0;
    public final int OUTPUT0 = 1;
    public final int INPUT1 = 2;
    public final int OUTPUT1 = 3;
    public final int INPUT2 = 4;
    public final int OUTPUT2 = 5;
    public final int INPUT3 = 6;
    public final int OUTPUT3 = 7;
    public final int INPUT4 = 8;
    public final int OUTPUT4 = 9;
    public final int INPUT5 = 10;
    public final int OUTPUT5 = 11;

    public AbstractCompressedPoweredMenu(MenuType<?> menuType, int containerId, Level level, Inventory playerInventory, String tierID, RecipeType<? extends AbstractCookingRecipe> recipeType) {
        this(menuType, containerId, level, playerInventory, tierID, (ContainerData)new SimpleContainerData(15), (ContainerData)new SimpleContainerData(9), recipeType);
    }

    public AbstractCompressedPoweredMenu(MenuType<?> menuType, int containerId, Level level, Inventory playerInventory, String tierID, ContainerData data, ContainerData data1, RecipeType<? extends AbstractCookingRecipe> recipeType) {
        super(menuType, containerId, level, playerInventory, tierID, data, data1, recipeType);
        Player player = playerInventory.player;
        BlockHitResult blockHitResult = (BlockHitResult)player.pick(5.0, 0.0f, false);
        BlockPos pos = blockHitResult.getBlockPos();
        this.container = (AbstractCompressedPoweredEntityBlock)level.getBlockEntity(pos);
    }

    @Override
    public AbstractCompressedPoweredEntityBlock getBlockEntity() {
        return (AbstractCompressedPoweredEntityBlock)this.container;
    }

    @Override
    protected void addTierSpecificSlots(Container container, Inventory playerInventory, String tierID) {
        if (tierID != null) {
            switch (tierID) {
                case "compressed": {
                    this.addSlot(new Slot(container, 0, 70, 6));
                    this.addSlot(new ResultSlot(playerInventory.player, container, 1, 70, 55));
                    this.addSlot(new Slot(container, 2, 91, 6));
                    this.addSlot(new ResultSlot(playerInventory.player, container, 3, 91, 55));
                    break;
                }
                case "double_compressed": {
                    this.addSlot(new Slot(container, 0, 64, 6));
                    this.addSlot(new ResultSlot(playerInventory.player, container, 1, 64, 55));
                    this.addSlot(new Slot(container, 2, 85, 6));
                    this.addSlot(new ResultSlot(playerInventory.player, container, 3, 85, 55));
                    this.addSlot(new Slot(container, 4, 106, 6));
                    this.addSlot(new ResultSlot(playerInventory.player, container, 5, 106, 55));
                    this.addSlot(new Slot(container, 6, 127, 6));
                    this.addSlot(new ResultSlot(playerInventory.player, container, 7, 127, 55));
                    break;
                }
                case "triple_compressed": {
                    this.addSlot(new Slot(container, 0, 43, 6));
                    this.addSlot(new ResultSlot(playerInventory.player, container, 1, 43, 55));
                    this.addSlot(new Slot(container, 2, 64, 6));
                    this.addSlot(new ResultSlot(playerInventory.player, container, 3, 64, 55));
                    this.addSlot(new Slot(container, 4, 85, 6));
                    this.addSlot(new ResultSlot(playerInventory.player, container, 5, 85, 55));
                    this.addSlot(new Slot(container, 6, 106, 6));
                    this.addSlot(new ResultSlot(playerInventory.player, container, 7, 106, 55));
                    this.addSlot(new Slot(container, 8, 127, 6));
                    this.addSlot(new ResultSlot(playerInventory.player, container, 9, 127, 55));
                    this.addSlot(new Slot(container, 10, 148, 6));
                    this.addSlot(new ResultSlot(playerInventory.player, container, 11, 148, 55));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected tier: " + tierID);
                }
            }
        }
    }

    public int getEnergy() {
        return this.data.get(0);
    }

    public int getMaxEnergy() {
        return this.data.get(1);
    }
}

