/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.menu.slots;

import net.biorfn.compressedfurnace.entity.AbstractCompressedEntityBlock;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.EventHooks;

public class ResultSlot
extends Slot {
    private final Player player;
    private int removeCount;

    public ResultSlot(Player player, Container container, int slot, int x, int y) {
        super(container, slot, x, y);
        this.player = player;
    }

    public boolean mayPlace(ItemStack stack) {
        return false;
    }

    public ItemStack remove(int amount) {
        if (this.hasItem()) {
            this.removeCount += Math.min(amount, this.getItem().getCount());
        }
        return super.remove(amount);
    }

    public void onTake(Player player, ItemStack stack) {
        this.checkTakeAchievements(stack);
        super.onTake(player, stack);
    }

    protected void checkTakeAchievements(ItemStack stack) {
        stack.onCraftedBy(this.player.level(), this.player, this.removeCount);
        Player var4 = this.player;
        if (var4 instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)var4;
            Container var5 = this.container;
            if (var5 instanceof AbstractCompressedEntityBlock) {
                AbstractCompressedEntityBlock abstractCompressedEntityBlock = (AbstractCompressedEntityBlock)var5;
                abstractCompressedEntityBlock.awardUsedRecipesAndPopExperience(serverplayer, this.getSlotIndex());
            }
        }
        this.removeCount = 0;
        EventHooks.firePlayerSmeltedEvent((Player)this.player, (ItemStack)stack);
    }
}

