/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.network;

import javax.annotation.Nullable;
import net.biorfn.compressedfurnace.entity.AbstractCompressedEntityBlock;
import net.biorfn.compressedfurnace.menu.AbstractCompressedMenu;
import net.biorfn.compressedfurnace.util.CallConstants;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SetSideIO(@Nullable Direction side, boolean reset) implements CustomPacketPayload
{
    public static final ResourceLocation ID = CallConstants.getLocation("set_side_io");
    public static final CustomPacketPayload.Type<SetSideIO> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, SetSideIO> CODEC = StreamCodec.ofMember((payload, buffer) -> {
        buffer.writeNullable((Object)payload.side, FriendlyByteBuf::writeEnum);
        buffer.writeBoolean(payload.reset);
    }, buffer -> {
        Direction side = (Direction)buffer.readNullable(buf -> (Direction)buf.readEnum(Direction.class));
        boolean reset = buffer.readBoolean();
        return new SetSideIO(side, reset);
    });

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            AbstractCompressedMenu menu;
            AbstractCompressedEntityBlock patt1$temp;
            Player player = ctx.player();
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof AbstractCompressedMenu && (patt1$temp = (menu = (AbstractCompressedMenu)patt0$temp).getBlockEntity()) instanceof AbstractCompressedEntityBlock) {
                AbstractCompressedEntityBlock blockEntity = patt1$temp;
                if (this.reset && this.side == null) {
                    blockEntity.resetSlotSides();
                } else if (this.reset && this.side != null) {
                    blockEntity.resetSlotType(this.side);
                } else {
                    blockEntity.cycleSlotSide(this.side);
                }
            }
        });
    }
}

