/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.recipes;

import java.util.LinkedHashMap;
import java.util.Map;
import net.biorfn.compressedfurnace.recipes.GeneratorRecipe;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import org.jetbrains.annotations.Nullable;

public class GeneratorRecipeBuilder
implements RecipeBuilder {
    private final Ingredient input;
    private final int energy;
    private final Map<String, Criterion<?>> criteria;
    @Nullable
    private String group;

    public GeneratorRecipeBuilder(Ingredient input, int energy) {
        this.input = input;
        this.energy = energy;
        this.criteria = new LinkedHashMap();
    }

    public static GeneratorRecipeBuilder generator(Ingredient input, int energy) {
        return new GeneratorRecipeBuilder(input, energy);
    }

    public RecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public RecipeBuilder group(@Nullable String group) {
        this.group = group;
        return this;
    }

    public Item getResult() {
        return null;
    }

    public void save(RecipeOutput writer, ResourceLocation id) {
        this.ensureValid(id);
        Advancement.Builder advancementBuilder = writer.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancementBuilder).addCriterion(arg_0, arg_1));
        writer.accept(id, (Recipe)new GeneratorRecipe(this.energy, this.input), advancementBuilder.build(id.withPrefix("recipes/" + RecipeCategory.MISC.getFolderName() + "/")));
    }

    private void ensureValid(ResourceLocation id) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("Recipe " + String.valueOf(id) + " has no way of being unlocked! Add a criterion.");
        }
    }
}

