/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.screen.guide;

import java.util.ArrayList;
import java.util.List;
import net.biorfn.compressedfurnace.config.Config;
import net.biorfn.compressedfurnace.registries.MultiFurnaceTieredItems;
import net.biorfn.compressedfurnace.util.widgets.ClickableText;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;

public class GuideBookScreen
extends Screen {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"compressedfurnace", (String)"textures/gui/book_w_slot.png");
    private int currentPage = 0;
    private Button Previous;
    private Button Next;
    private final int totalPages;
    int imageWidth = 234;
    int imageHeight = 186;
    protected int leftPos;
    protected int topPos;
    private final List<List<String>> pageContent;
    private final List<ItemStack> recipeGrid = new ArrayList<ItemStack>();
    private ClickableText returntoMenu;
    private ClickableText returntoFueled;
    private ClickableText returntoGenerators;
    private ClickableText returntoPowered;
    private ClickableText fueledMachines;
    private ClickableText generators;
    private ClickableText poweredMachines;
    private ClickableText miscItems;
    private ClickableText credits;
    private ClickableText discord;
    private ClickableText fuelFurnace;
    private ClickableText fuelCrusher;
    private ClickableText genRecipe;
    private ClickableText poweredFurnace;
    private ClickableText poweredCrusher;
    private ClickableText poweredBlastFurnace;
    private ClickableText fuelBlastFurnace;
    private int tD5;

    public GuideBookScreen(Component title) {
        super(title);
        this.pageContent = new ArrayList<List<String>>();
        this.initializePages();
        this.totalPages = this.pageContent.size();
    }

    protected void init() {
        super.init();
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.tD5 = this.width + 5;
        this.setupClickableTexts();
        this.Previous = (Button)this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)"Previous"), button -> {
            this.currentPage = Math.max(0, this.currentPage - 1);
            this.setupClickableTexts();
        }).bounds(this.leftPos + 12, this.topPos + this.imageHeight + 2, 50, 15).build());
        this.Next = (Button)this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)"Next"), button -> {
            ++this.currentPage;
            this.setupClickableTexts();
        }).bounds(this.leftPos + this.imageWidth - 61, this.topPos + this.imageHeight + 2, 45, 15).build());
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        if (this.currentPage == 2 || this.currentPage == 5 || this.currentPage == 8 || this.currentPage == 12 || this.currentPage == 16 || this.currentPage == 19 || this.currentPage == 22) {
            this.Previous.visible = false;
            this.Next.visible = true;
        }
        if (this.currentPage == 3 || this.currentPage == 6 || this.currentPage == 9 || this.currentPage == 13 || this.currentPage == 17 || this.currentPage == 20 || this.currentPage == 23) {
            this.Previous.visible = true;
            this.Next.visible = true;
        }
        if (this.currentPage == 4 || this.currentPage == 7 || this.currentPage == 10 || this.currentPage == 14 || this.currentPage == 18 || this.currentPage == 21 || this.currentPage == 24) {
            this.Previous.visible = true;
            this.Next.visible = false;
        }
        if (this.currentPage == this.totalPages - 1 || this.currentPage == 25 || this.currentPage == 0 || this.currentPage == 1 || this.currentPage == 11 || this.currentPage == 15) {
            this.Next.visible = false;
            this.Previous.visible = false;
        }
        int gWidth = this.tD5 / 2;
        int textColor = 0x333333;
        if (this.currentPage != 0) {
            this.returntoMenu.render(guiGraphics, this.font, mouseX, mouseY);
        }
        this.renderPageContent(guiGraphics, gWidth, textColor);
        if (this.currentPage == 0) {
            this.fueledMachines.render(guiGraphics, this.font, mouseX, mouseY);
            this.generators.render(guiGraphics, this.font, mouseX, mouseY);
            this.poweredMachines.render(guiGraphics, this.font, mouseX, mouseY);
            this.miscItems.render(guiGraphics, this.font, mouseX, mouseY);
            this.credits.render(guiGraphics, this.font, mouseX, mouseY);
        }
        if (this.currentPage == 1) {
            this.fuelFurnace.render(guiGraphics, this.font, mouseX, mouseY);
            this.fuelCrusher.render(guiGraphics, this.font, mouseX, mouseY);
            this.fuelBlastFurnace.render(guiGraphics, this.font, mouseX, mouseY);
        }
        if (this.currentPage > 1 && this.currentPage <= 10) {
            this.returntoFueled.render(guiGraphics, this.font, mouseX, mouseY);
        }
        if (this.currentPage == 11) {
            this.genRecipe.render(guiGraphics, this.font, mouseX, mouseY);
        }
        if (this.currentPage > 11 && this.currentPage <= 14) {
            this.returntoGenerators.render(guiGraphics, this.font, mouseX, mouseY);
        }
        if (this.currentPage == 15) {
            this.poweredFurnace.render(guiGraphics, this.font, mouseX, mouseY);
            this.poweredCrusher.render(guiGraphics, this.font, mouseX, mouseY);
            this.poweredBlastFurnace.render(guiGraphics, this.font, mouseX, mouseY);
        }
        if (this.currentPage > 15 && this.currentPage <= 24) {
            this.returntoPowered.render(guiGraphics, this.font, mouseX, mouseY);
        }
        if (this.currentPage == this.totalPages - 1) {
            this.discord.render(guiGraphics, this.font, mouseX, mouseY);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        switch (this.currentPage) {
            case 2: {
                this.addCraftingStuff(guiGraphics, "compressed_furnace", mouseX, mouseY);
                break;
            }
            case 3: {
                this.addCraftingStuff(guiGraphics, "double_compressed_furnace", mouseX, mouseY);
                break;
            }
            case 4: {
                this.addCraftingStuff(guiGraphics, "triple_compressed_furnace", mouseX, mouseY);
                break;
            }
            case 5: {
                this.addCraftingStuff(guiGraphics, "compressed_crusher", mouseX, mouseY);
                break;
            }
            case 6: {
                this.addCraftingStuff(guiGraphics, "double_compressed_crusher", mouseX, mouseY);
                break;
            }
            case 7: {
                this.addCraftingStuff(guiGraphics, "triple_compressed_crusher", mouseX, mouseY);
                break;
            }
            case 8: {
                this.addCraftingStuff(guiGraphics, "compressed_blast_furnace", mouseX, mouseY);
                break;
            }
            case 9: {
                this.addCraftingStuff(guiGraphics, "double_compressed_blast_furnace", mouseX, mouseY);
                break;
            }
            case 10: {
                this.addCraftingStuff(guiGraphics, "triple_compressed_blast_furnace", mouseX, mouseY);
                break;
            }
            case 12: {
                this.addCraftingStuff(guiGraphics, "compressed_generator", mouseX, mouseY);
                break;
            }
            case 13: {
                this.addCraftingStuff(guiGraphics, "double_compressed_generator", mouseX, mouseY);
                break;
            }
            case 14: {
                this.addCraftingStuff(guiGraphics, "triple_compressed_generator", mouseX, mouseY);
                break;
            }
            case 16: {
                this.addCraftingStuff(guiGraphics, "powered_compressed_furnace", mouseX, mouseY);
                break;
            }
            case 17: {
                this.addCraftingStuff(guiGraphics, "powered_double_compressed_furnace", mouseX, mouseY);
                break;
            }
            case 18: {
                this.addCraftingStuff(guiGraphics, "powered_triple_compressed_furnace", mouseX, mouseY);
                break;
            }
            case 19: {
                this.addCraftingStuff(guiGraphics, "powered_compressed_crusher", mouseX, mouseY);
                break;
            }
            case 20: {
                this.addCraftingStuff(guiGraphics, "powered_double_compressed_crusher", mouseX, mouseY);
                break;
            }
            case 21: {
                this.addCraftingStuff(guiGraphics, "powered_triple_compressed_crusher", mouseX, mouseY);
                break;
            }
            case 22: {
                this.addCraftingStuff(guiGraphics, "powered_compressed_blast_furnace", mouseX, mouseY);
                break;
            }
            case 23: {
                this.addCraftingStuff(guiGraphics, "powered_double_compressed_blast_furnace", mouseX, mouseY);
                break;
            }
            case 24: {
                this.addCraftingStuff(guiGraphics, "powered_triple_compressed_blast_furnace", mouseX, mouseY);
                break;
            }
            case 25: {
                this.renderCraftingResult(guiGraphics, this.leftPos + 110, this.topPos + 30, (ItemLike)MultiFurnaceTieredItems.RAW_SCRAP.get(), mouseX, mouseY);
                this.renderCraftingResult(guiGraphics, this.leftPos + 110, this.topPos + 100, (ItemLike)Items.EXPERIENCE_BOTTLE, mouseX, mouseY);
            }
        }
    }

    private void customDrawCenteredString(GuiGraphics guiGraphics, String text, int x, int y, int color) {
        guiGraphics.drawString(this.font, text, x - this.font.width(text) / 2, this.topPos + y, color, false);
    }

    private void renderPageContent(GuiGraphics guiGraphics, int gWidth, int textColor) {
        if (this.currentPage >= 0 && this.currentPage < this.totalPages) {
            List<String> lines = this.pageContent.get(this.currentPage);
            for (int i = 0; i < lines.size(); ++i) {
                this.customDrawCenteredString(guiGraphics, lines.get(i), gWidth, 12 + i * 10, textColor);
            }
        }
    }

    private void addCraftingStuff(GuiGraphics guiGraphics, String recipeKey, int mouseX, int mouseY) {
        this.renderCraftingGrid(guiGraphics, this.leftPos + 50, this.topPos + 70, this.recipeGrid, mouseX, mouseY);
        this.renderCraftingResult(guiGraphics, this.leftPos + 160, this.topPos + 90, this.getResultItem(recipeKey), mouseX, mouseY);
        this.loadRecipe(recipeKey);
    }

    private void renderCraftingGrid(GuiGraphics guiGraphics, int leftPos, int topPos, List<ItemStack> recipeGrid, int mouseX, int mouseY) {
        int slotSize = 18;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                int index = row * 3 + col;
                int x = leftPos + col * slotSize;
                int y = topPos + row * slotSize;
                guiGraphics.blit(TEXTURE, x, y, 0, 187, slotSize, slotSize);
                if (index >= recipeGrid.size() || recipeGrid.get(index).isEmpty()) continue;
                ItemStack stack = recipeGrid.get(index);
                guiGraphics.renderItem(recipeGrid.get(index), x + 1, y + 1);
                guiGraphics.renderItemDecorations(this.font, recipeGrid.get(index), x + 1, y + 1);
                if (mouseX < x || mouseX > x + slotSize || mouseY < y || mouseY > y + slotSize) continue;
                guiGraphics.renderTooltip(this.font, stack, mouseX, mouseY);
            }
        }
    }

    private void renderCraftingResult(GuiGraphics guiGraphics, int leftPos, int topPos, ItemLike itemLike, int mouseX, int mouseY) {
        guiGraphics.blit(TEXTURE, leftPos, topPos, 0, 187, 18, 18);
        if (!this.recipeGrid.isEmpty()) {
            ItemStack result = new ItemStack(itemLike);
            guiGraphics.renderItem(result, leftPos + 1, topPos + 1);
            guiGraphics.renderItemDecorations(this.font, result, leftPos + 1, topPos + 1);
            if (mouseX >= leftPos && mouseX <= leftPos + 18 && mouseY >= topPos && mouseY <= topPos + 18) {
                guiGraphics.renderTooltip(this.font, result, mouseX, mouseY);
            }
        }
    }

    private void initializePages() {
        this.addPage("Welcome to the Compressed", "Furnace Guide!");
        this.addPage("Fueled Machines.", "For each tier you get an increase", "of 2 inputs and 2 outputs. There is", "an Auto Split button!", "There is a config!");
        this.addPage("Compressed Furnace", "you get total 2 inputs and 2 outputs.");
        this.addPage("Double Compressed Furnace", "you get total 4 inputs and 4 outputs.");
        this.addPage("Triple Compressed Furnace", "you get total 6 inputs and outputs.");
        this.addPage("Compressed Crusher", "you get total 2 inputs and 2 outputs.", this.getChance(Config.compressedChances));
        this.addPage("Double Compressed Crusher", "you get total 4 inputs and 4 outputs.", this.getChance(Config.doubleCompressedChances));
        this.addPage("Triple Compressed Crusher", "you get total 6 inputs and 6 outputs.", this.getChance(Config.tripleCompressedChances));
        this.addPage("Compressed Blast Furnace", "you get 2 inputs and 2 outputs");
        this.addPage("Double Compressed Blast Furnace", "you get 4 inputs and 4 outputs");
        this.addPage("Triple Compressed Blast Furnace", "you get 6 inputs and 6 outputs");
        this.addPage("Generators", "Each tier gives you more", "RF storage and better efficiency", "and you can use the internal", "lava tank or the fuel slot to", "power the machines", "There is a config!");
        this.addPage("Compressed Generator", this.getRFCapacity((ModConfigSpec.ConfigValue<Integer>)Config.compressedEnergyCapacity, true), this.getTransfer((ModConfigSpec.ConfigValue<Integer>)Config.compressedMaxTransferRate), this.getmBCapacity((ModConfigSpec.ConfigValue<Integer>)Config.compressedLavaTankCapacity));
        this.addPage("Double Compressed Generator", this.getRFCapacity((ModConfigSpec.ConfigValue<Integer>)Config.doubleCompressedEnergyCapacity, true), this.getTransfer((ModConfigSpec.ConfigValue<Integer>)Config.doubleCompressedMaxTransferRate), this.getmBCapacity((ModConfigSpec.ConfigValue<Integer>)Config.doubleCompressedLavaTankCapacity));
        this.addPage("Triple Compressed Generator", this.getRFCapacity((ModConfigSpec.ConfigValue<Integer>)Config.tripleCompressedEnergyCapacity, true), this.getTransfer((ModConfigSpec.ConfigValue<Integer>)Config.tripleCompressedMaxTransferRate), this.getmBCapacity((ModConfigSpec.ConfigValue<Integer>)Config.tripleCompressedLavaTankCapacity));
        this.addPage("Powered Machines", "These machines are powered by RF", "Each tier has a bigger internal", "RF, They also have the same inputs", "and outputs as the fueled ones.", "Theres an Auto Split button!", "There is a config!");
        this.addPage("Powered Compressed Furnace", "you get total 2 inputs and 2 outputs", this.getRFCapacity((ModConfigSpec.ConfigValue<Integer>)Config.compressedEnergyCapacity, false), this.getTransfer((ModConfigSpec.ConfigValue<Integer>)Config.compressedMaxTransferRate));
        this.addPage("Powered Double Compressed Furnace", "you get total 4 inputs and 4 outputs.", this.getRFCapacity((ModConfigSpec.ConfigValue<Integer>)Config.doubleCompressedEnergyCapacity, false), this.getTransfer((ModConfigSpec.ConfigValue<Integer>)Config.doubleCompressedMaxTransferRate));
        this.addPage("Powered Triple Compressed Furnace", "you get total 6 inputs and 6 outputs.", this.getRFCapacity((ModConfigSpec.ConfigValue<Integer>)Config.tripleCompressedEnergyCapacity, false), this.getTransfer((ModConfigSpec.ConfigValue<Integer>)Config.tripleCompressedMaxTransferRate));
        this.addPage("Powered Compressed Crusher", "you get total 2 inputs and 2 outputs.", this.getRFCapacity((ModConfigSpec.ConfigValue<Integer>)Config.compressedEnergyCapacity, false), this.getTransfer((ModConfigSpec.ConfigValue<Integer>)Config.compressedMaxTransferRate), this.getChance(Config.compressedChances));
        this.addPage("Powered Double Compressed Crusher", "you get total 4 inputs and 4 outputs", this.getRFCapacity((ModConfigSpec.ConfigValue<Integer>)Config.doubleCompressedEnergyCapacity, false), this.getTransfer((ModConfigSpec.ConfigValue<Integer>)Config.doubleCompressedMaxTransferRate), this.getChance(Config.doubleCompressedChances));
        this.addPage("Powered Triple Compressed Crusher", "you get total 6 inputs and 6 outputs", this.getRFCapacity((ModConfigSpec.ConfigValue<Integer>)Config.tripleCompressedEnergyCapacity, false), this.getTransfer((ModConfigSpec.ConfigValue<Integer>)Config.tripleCompressedMaxTransferRate), this.getChance(Config.tripleCompressedChances));
        this.addPage("Powered Compressed Blast Furnace", "you get total 2 inputs and 2 outputs", this.getRFCapacity((ModConfigSpec.ConfigValue<Integer>)Config.compressedEnergyCapacity, false), this.getTransfer((ModConfigSpec.ConfigValue<Integer>)Config.compressedMaxTransferRate));
        this.addPage("Powered Double Compressed Blast Furnace", "you get total 4 inputs and 4 outputs", this.getRFCapacity((ModConfigSpec.ConfigValue<Integer>)Config.doubleCompressedEnergyCapacity, false), this.getTransfer((ModConfigSpec.ConfigValue<Integer>)Config.doubleCompressedMaxTransferRate));
        this.addPage("Powered Triple Compressed Blast Furnace", "you get total 6 inputs and 6 outputs", this.getRFCapacity((ModConfigSpec.ConfigValue<Integer>)Config.tripleCompressedEnergyCapacity, false), this.getTransfer((ModConfigSpec.ConfigValue<Integer>)Config.tripleCompressedMaxTransferRate));
        this.addPage("the raw scrap is the dust for", "ancient debris", "", "", "", "There is a XP bottle that appears", "when the output slot is empty and", "there is xp to be collected");
        this.addPage("", "", "If you find any issues with or have", "", "", "any suggestions for compatibility", "", "", "please let me know!", "", "");
    }

    private String getChance(ModConfigSpec.ConfigValue<List<? extends Double>> config) {
        if (((List)config.get()).size() > 1) {
            if (((List)config.get()).size() == 3) {
                return "Extra item chance: " + (Double)((List)config.get()).getFirst() * 100.0 + "%, " + (Double)((List)config.get()).get(1) * 100.0 + "%, & " + (Double)((List)config.get()).get(2) * 100.0 + "%";
            }
            return "Extra item chance of: " + (Double)((List)config.get()).getFirst() * 100.0 + "% & " + (Double)((List)config.get()).get(1) * 100.0 + "%";
        }
        return "Extra item chance of: " + (Double)((List)config.get()).getFirst() * 100.0 + "%";
    }

    private String getRFCapacity(ModConfigSpec.ConfigValue<Integer> RF, boolean isgen) {
        int doubleRfValue = (Integer)RF.get() * 2;
        if (isgen) {
            return "Has a RF capacity of: " + String.valueOf(RF.get()) + "RF";
        }
        return "Has a RF capacity of: " + doubleRfValue + "RF";
    }

    private String getTransfer(ModConfigSpec.ConfigValue<Integer> transfer) {
        return ", & a transfer rate " + String.valueOf(transfer.get()) + "RF/t";
    }

    private String getmBCapacity(ModConfigSpec.ConfigValue<Integer> lava) {
        return ", & a Lava capacity of: " + String.valueOf(lava.get()) + "mB";
    }

    private void addPage(String ... lines) {
        this.pageContent.add(List.of(lines));
    }

    private void populateRecipeGrid(CraftingRecipe craftingRecipe) {
        this.recipeGrid.clear();
        NonNullList ingredients = craftingRecipe.getIngredients();
        for (int i = 0; i < 9; ++i) {
            if (i < ingredients.size()) {
                Ingredient ingredient = (Ingredient)ingredients.get(i);
                if (!ingredient.isEmpty()) {
                    ItemStack[] matchingStacks = ingredient.getItems();
                    this.recipeGrid.add(matchingStacks.length > 0 ? matchingStacks[0] : ItemStack.EMPTY);
                    continue;
                }
                this.recipeGrid.add(ItemStack.EMPTY);
                continue;
            }
            this.recipeGrid.add(ItemStack.EMPTY);
        }
    }

    private void loadRecipe(String recipeKey) {
        if (Minecraft.getInstance().level == null) {
            return;
        }
        RecipeManager recipeManager = Minecraft.getInstance().level.getRecipeManager();
        recipeManager.byKey(ResourceLocation.fromNamespaceAndPath((String)"compressedfurnace", (String)recipeKey)).ifPresent(recipe -> {
            Recipe patt0$temp = recipe.value();
            if (patt0$temp instanceof CraftingRecipe) {
                CraftingRecipe craftingRecipe = (CraftingRecipe)patt0$temp;
                this.populateRecipeGrid(craftingRecipe);
            }
        });
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.currentPage != 0) {
            this.returntoMenu.mouseClicked(this.font, (int)mouseX, (int)mouseY, button);
        }
        if (this.currentPage == 0) {
            this.fueledMachines.mouseClicked(this.font, (int)mouseX, (int)mouseY, button);
            this.generators.mouseClicked(this.font, (int)mouseX, (int)mouseY, button);
            this.poweredMachines.mouseClicked(this.font, (int)mouseX, (int)mouseY, button);
            this.miscItems.mouseClicked(this.font, (int)mouseX, (int)mouseY, button);
            this.credits.mouseClicked(this.font, (int)mouseX, (int)mouseY, button);
        }
        if (this.currentPage == 1) {
            this.fuelFurnace.mouseClicked(this.font, (int)mouseX, (int)mouseY, button);
            this.fuelCrusher.mouseClicked(this.font, (int)mouseX, (int)mouseY, button);
            this.fuelBlastFurnace.mouseClicked(this.font, (int)mouseX, (int)mouseY, button);
        }
        if (this.currentPage > 1 && this.currentPage <= 10) {
            this.returntoFueled.mouseClicked(this.font, (int)mouseX, (int)mouseY, button);
        }
        if (this.currentPage == 11) {
            this.genRecipe.mouseClicked(this.font, (int)mouseX, (int)mouseY, button);
        }
        if (this.currentPage > 11 && this.currentPage <= 14) {
            this.returntoGenerators.mouseClicked(this.font, (int)mouseX, (int)mouseY, button);
        }
        if (this.currentPage == 15) {
            this.poweredFurnace.mouseClicked(this.font, (int)mouseX, (int)mouseY, button);
            this.poweredCrusher.mouseClicked(this.font, (int)mouseX, (int)mouseY, button);
            this.poweredBlastFurnace.mouseClicked(this.font, (int)mouseX, (int)mouseY, button);
        }
        if (this.currentPage > 15 && this.currentPage <= 24) {
            this.returntoPowered.mouseClicked(this.font, (int)mouseX, (int)mouseY, button);
        }
        if (this.currentPage == this.totalPages - 1) {
            this.discord.mouseClicked(this.font, (int)mouseX, (int)mouseY, button);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private ItemLike getResultItem(String recipeKey) {
        return switch (recipeKey) {
            case "compressed_furnace" -> (BlockItem)MultiFurnaceTieredItems.COMPRESSED_FURNACE_ITEM.get();
            case "double_compressed_furnace" -> (BlockItem)MultiFurnaceTieredItems.DOUBLE_COMPRESSED_FURNACE_ITEM.get();
            case "triple_compressed_furnace" -> (BlockItem)MultiFurnaceTieredItems.TRIPLE_COMPRESSED_FURNACE_ITEM.get();
            case "compressed_crusher" -> (BlockItem)MultiFurnaceTieredItems.COMPRESSED_CRUSHER_ITEM.get();
            case "double_compressed_crusher" -> (BlockItem)MultiFurnaceTieredItems.DOUBLE_COMPRESSED_CRUSHER_ITEM.get();
            case "triple_compressed_crusher" -> (BlockItem)MultiFurnaceTieredItems.TRIPLE_COMPRESSED_CRUSHER_ITEM.get();
            case "compressed_generator" -> (BlockItem)MultiFurnaceTieredItems.COMPRESSED_GENERATOR_ITEM.get();
            case "double_compressed_generator" -> (BlockItem)MultiFurnaceTieredItems.DOUBLE_COMPRESSED_GENERATOR_ITEM.get();
            case "triple_compressed_generator" -> (BlockItem)MultiFurnaceTieredItems.TRIPLE_COMPRESSED_GENERATOR_ITEM.get();
            case "powered_compressed_furnace" -> (BlockItem)MultiFurnaceTieredItems.POWERED_COMPRESSED_FURNACE_ITEM.get();
            case "powered_double_compressed_furnace" -> (BlockItem)MultiFurnaceTieredItems.POWERED_DOUBLE_COMPRESSED_FURNACE_ITEM.get();
            case "powered_triple_compressed_furnace" -> (BlockItem)MultiFurnaceTieredItems.POWERED_TRIPLE_COMPRESSED_FURNACE_ITEM.get();
            case "powered_compressed_crusher" -> (BlockItem)MultiFurnaceTieredItems.POWERED_COMPRESSED_CRUSHER_ITEM.get();
            case "powered_double_compressed_crusher" -> (BlockItem)MultiFurnaceTieredItems.POWERED_DOUBLE_COMPRESSED_CRUSHER_ITEM.get();
            case "powered_triple_compressed_crusher" -> (BlockItem)MultiFurnaceTieredItems.POWERED_TRIPLE_COMPRESSED_CRUSHER_ITEM.get();
            case "compressed_blast_furnace" -> (BlockItem)MultiFurnaceTieredItems.COMPRESSED_BLAST_FURNACE_ITEM.get();
            case "double_compressed_blast_furnace" -> (BlockItem)MultiFurnaceTieredItems.DOUBLE_COMPRESSED_BLAST_FURNACE_ITEM.get();
            case "triple_compressed_blast_furnace" -> (BlockItem)MultiFurnaceTieredItems.TRIPLE_COMPRESSED_BLAST_FURNACE_ITEM.get();
            case "powered_compressed_blast_furnace" -> (BlockItem)MultiFurnaceTieredItems.POWERED_COMPRESSED_BLAST_FURNACE_ITEM.get();
            case "powered_double_compressed_blast_furnace" -> (BlockItem)MultiFurnaceTieredItems.POWERED_DOUBLE_COMPRESSED_BLAST_FURNACE_ITEM.get();
            case "powered_triple_compressed_blast_furnace" -> (BlockItem)MultiFurnaceTieredItems.POWERED_TRIPLE_COMPRESSED_BLAST_FURNACE_ITEM.get();
            default -> Items.AIR;
        };
    }

    private void setupClickableTexts() {
        int gWidth = this.tD5 / 2;
        if (this.currentPage != 0) {
            this.returntoMenu = new ClickableText("Return to Menu", this.leftPos + 12 + this.font.width("Return to Menu") / 2, this.topPos + this.imageHeight - 25, text -> {
                this.currentPage = 0;
                this.setupClickableTexts();
            });
        }
        if (this.currentPage == this.totalPages - 1) {
            this.discord = new ClickableText("Discord", gWidth, this.topPos + this.imageHeight - 80, text -> Util.getPlatform().openUri("https://discord.gg/5bgGfEj"));
        }
        if (this.currentPage == 0) {
            this.fueledMachines = new ClickableText("Fueled Machines", gWidth, this.topPos + 45, text -> {
                this.currentPage = 1;
                this.setupClickableTexts();
            });
            this.generators = new ClickableText("Generators", gWidth, this.topPos + 65, text -> {
                this.currentPage = 11;
                this.setupClickableTexts();
            });
            this.poweredMachines = new ClickableText("Powered Machines", gWidth, this.topPos + 85, text -> {
                this.currentPage = 15;
                this.setupClickableTexts();
            });
            this.miscItems = new ClickableText("Misc. Items", gWidth, this.topPos + 105, text -> {
                this.currentPage = 25;
                this.setupClickableTexts();
            });
            this.credits = new ClickableText("Closing Page", gWidth, this.topPos + 125, text -> {
                this.currentPage = this.totalPages - 1;
                this.setupClickableTexts();
            });
        }
        if (this.currentPage == 1) {
            this.fuelFurnace = new ClickableText("Fuel Furnace", gWidth, this.topPos + 75, text -> {
                this.currentPage = 2;
                this.setupClickableTexts();
            });
            this.fuelCrusher = new ClickableText("Fuel Crusher", gWidth, this.topPos + 100, text -> {
                this.currentPage = 5;
                this.setupClickableTexts();
            });
            this.fuelBlastFurnace = new ClickableText("Fuel Blast Furnace", gWidth, this.topPos + 125, text -> {
                this.currentPage = 8;
                this.setupClickableTexts();
            });
        }
        if (this.currentPage > 1 && this.currentPage <= 10) {
            this.returntoFueled = new ClickableText("Return to Fueled", this.leftPos + this.imageWidth - 61, this.topPos + this.imageHeight - 25, text -> {
                this.currentPage = 1;
                this.setupClickableTexts();
            });
        }
        if (this.currentPage == 11) {
            this.genRecipe = new ClickableText("Generator", gWidth, this.topPos + this.imageHeight - 100, text -> {
                this.currentPage = 12;
                this.setupClickableTexts();
            });
        }
        if (this.currentPage > 11 && this.currentPage <= 14) {
            this.returntoGenerators = new ClickableText("Return to Generators", this.leftPos + this.imageWidth - 61, this.topPos + this.imageHeight - 25, text -> {
                this.currentPage = 11;
                this.setupClickableTexts();
            });
        }
        if (this.currentPage == 15) {
            this.poweredFurnace = new ClickableText("Powered Furnace", gWidth, this.topPos + 100, text -> {
                this.currentPage = 16;
                this.setupClickableTexts();
            });
            this.poweredCrusher = new ClickableText("Powered Crusher", gWidth, this.topPos + 120, text -> {
                this.currentPage = 19;
                this.setupClickableTexts();
            });
            this.poweredBlastFurnace = new ClickableText("Powered Blast Furnace", gWidth, this.topPos + 140, text -> {
                this.currentPage = 22;
                this.setupClickableTexts();
            });
        }
        if (this.currentPage > 15 && this.currentPage <= 24) {
            this.returntoPowered = new ClickableText("Return to Powered", this.leftPos + this.imageWidth - 61, this.topPos + this.imageHeight - 25, text -> {
                this.currentPage = 15;
                this.setupClickableTexts();
            });
        }
    }
}

