/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.util;

import java.util.ArrayList;
import java.util.List;
import net.biorfn.compressedfurnace.CompressedFurnace;
import net.biorfn.compressedfurnace.recipes.CrusherRecipe;
import net.biorfn.compressedfurnace.recipes.GeneratorRecipe;
import net.biorfn.compressedfurnace.registries.MultiFurnaceTieredItems;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;

public class RecipeValidation {
    public static void validateRecipesOnRegistration(RecipeManager recipeManager, Level level) {
        ArrayList allRecipes = new ArrayList();
        allRecipes.addAll(recipeManager.getAllRecipesFor((RecipeType)MultiFurnaceTieredItems.CRUSHER_RECIPE_TYPE.get()));
        allRecipes.addAll(recipeManager.getAllRecipesFor((RecipeType)MultiFurnaceTieredItems.GENERATOR_RECIPE_TYPE.get()));
        for (RecipeHolder recipe : allRecipes) {
            if (RecipeValidation.isValidRecipe(recipe, level)) continue;
            CompressedFurnace.LOGGER.warn("Invalid Recipe: {}", (Object)recipe.id());
        }
    }

    public static boolean isValidRecipe(RecipeHolder<?> recipeHolder, Level level) {
        Recipe recipe = recipeHolder.value();
        RegistryAccess registryAccess = level.registryAccess();
        if (!RecipeValidation.hasValidIngredients(recipe, recipeHolder)) {
            return false;
        }
        if (recipe instanceof GeneratorRecipe) {
            GeneratorRecipe generatorRecipe = (GeneratorRecipe)recipe;
            return RecipeValidation.validateGeneratorRecipe(generatorRecipe, recipeHolder);
        }
        if (recipe instanceof CrusherRecipe) {
            CrusherRecipe crusherRecipe = (CrusherRecipe)recipe;
            return RecipeValidation.validateCrusherRecipe(crusherRecipe, recipeHolder, registryAccess);
        }
        CompressedFurnace.LOGGER.warn("Unsupported recipe type: {}", (Object)recipe.getClass().getSimpleName());
        return false;
    }

    private static boolean hasValidIngredients(Recipe<?> recipe, RecipeHolder<?> recipeHolder) {
        if (recipe.getIngredients() == null || recipe.getIngredients().isEmpty()) {
            CompressedFurnace.LOGGER.error("Recipe {} has no ingredients!", (Object)recipeHolder.id());
            return false;
        }
        return true;
    }

    private static boolean validateGeneratorRecipe(GeneratorRecipe generatorRecipe, RecipeHolder<?> recipeHolder) {
        if (generatorRecipe.getEnergy() <= 0 || generatorRecipe.getEnergy() > 1000000000) {
            CompressedFurnace.LOGGER.error("Generator Recipe {} has an invalid energy! Energy: {}", (Object)recipeHolder.id(), (Object)generatorRecipe.getEnergy());
            return false;
        }
        return true;
    }

    private static boolean validateCrusherRecipe(CrusherRecipe crusherRecipe, RecipeHolder<?> recipeHolder, RegistryAccess registryAccess) {
        if (crusherRecipe.getCookingTime() <= 0) {
            CompressedFurnace.LOGGER.error("Crusher Recipe {} has an invalid cooking time!", (Object)recipeHolder.id());
            return false;
        }
        if (crusherRecipe.getResultItem((HolderLookup.Provider)registryAccess).isEmpty()) {
            CompressedFurnace.LOGGER.error("Crusher Recipe {} has an invalid result!", (Object)recipeHolder.id());
            return false;
        }
        return true;
    }

    private static boolean validateGenericRecipe(Recipe<?> recipe, RecipeHolder<?> recipeHolder, RegistryAccess registryAccess) {
        if (recipe.getResultItem((HolderLookup.Provider)registryAccess).isEmpty()) {
            CompressedFurnace.LOGGER.error("Generic Recipe {} has an invalid result!", (Object)recipeHolder.id());
            return false;
        }
        return true;
    }

    public static boolean hasValidRecipe(Level level, int[] INPUTSLOTS, RecipeManager.CachedCheck<SingleRecipeInput, ? extends AbstractCookingRecipe> quickCheck, List<ItemStack> items) {
        for (int slot : INPUTSLOTS) {
            ItemStack itemStack = items.get(slot);
            if (itemStack.isEmpty() || !quickCheck.getRecipeFor((RecipeInput)new SingleRecipeInput(itemStack), level).isPresent()) continue;
            return true;
        }
        return false;
    }
}

