/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.util.entitiy;

import java.util.Map;
import javax.annotation.Nullable;
import net.biorfn.compressedfurnace.util.RecipeValidation;
import net.biorfn.compressedfurnace.util.entitiy.CookingState;
import net.biorfn.compressedfurnace.util.entitiy.ExtraItemManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;

public class BurnUtil {
    public static boolean canBurn(RegistryAccess registryAccess, @Nullable RecipeHolder<?> recipe, NonNullList<ItemStack> inventory, int maxStackSize, int inputSlot, int outputSlot, Level level, boolean customRecipe) {
        ItemStack inputStack = (ItemStack)inventory.get(inputSlot);
        ItemStack outputStack = (ItemStack)inventory.get(outputSlot);
        if (customRecipe ? inputStack.isEmpty() || recipe == null || !RecipeValidation.isValidRecipe(recipe, level) : inputStack.isEmpty() || recipe == null) {
            return false;
        }
        ItemStack resultStack = ((AbstractCookingRecipe)recipe.value()).assemble(new SingleRecipeInput(inputStack), (HolderLookup.Provider)registryAccess);
        if (resultStack.isEmpty()) {
            return false;
        }
        if (outputStack.isEmpty()) {
            return true;
        }
        if (!ItemStack.isSameItemSameComponents((ItemStack)outputStack, (ItemStack)resultStack)) {
            return false;
        }
        if (!outputStack.isStackable()) {
            return false;
        }
        return outputStack.getCount() + resultStack.getCount() <= maxStackSize && outputStack.getCount() < maxStackSize;
    }

    public static boolean burn(RegistryAccess registryAccess, @Nullable RecipeHolder<?> recipe, NonNullList<ItemStack> inventory, int maxStackSize, int inputSlot, int outputSlot, Level level, BlockPos worldPosition, String tierID, boolean chance, boolean customRecipe, @Nullable ExtraItemManager extraItemManager) {
        ItemStack inputStack = (ItemStack)inventory.get(inputSlot);
        ItemStack outputStack = (ItemStack)inventory.get(outputSlot);
        if (customRecipe ? inputStack.isEmpty() || recipe == null || !RecipeValidation.isValidRecipe(recipe, level) : inputStack.isEmpty() || recipe == null) {
            return false;
        }
        ItemStack resultStack = ((AbstractCookingRecipe)recipe.value()).assemble(new SingleRecipeInput(inputStack), (HolderLookup.Provider)registryAccess);
        if (resultStack.isEmpty()) {
            return false;
        }
        if (chance) {
            ExtraItemManager.extraItemChance(tierID, resultStack);
        }
        if (outputStack.isEmpty()) {
            inventory.set(outputSlot, (Object)resultStack.copy());
        } else if (ItemStack.isSameItemSameComponents((ItemStack)outputStack, (ItemStack)resultStack)) {
            int newCount = outputStack.getCount() + resultStack.getCount();
            if (newCount <= maxStackSize) {
                outputStack.grow(resultStack.getCount());
            } else {
                outputStack.setCount(maxStackSize);
            }
        }
        inputStack.shrink(1);
        if (!chance) {
            extraItemManager.updateSmeltedItem(inputSlot, inputStack.getItem());
            if (extraItemManager.shouldGrantExtraItem(tierID, inputSlot)) {
                extraItemManager.grantExtraItem(level, worldPosition, inputSlot, outputSlot, maxStackSize, resultStack, (ItemStack[])inventory.toArray((Object[])new ItemStack[0]));
            }
        }
        return true;
    }

    public static void finishProcessing(RegistryAccess registryAccess, @Nullable RecipeHolder<?> recipe, NonNullList<ItemStack> inventory, int inputSlot, int outputSlot, int maxStackSize, @Nullable ExtraItemManager extraItemManager, String tierID, Level level, BlockPos worldPosition, Map<Integer, CookingState> cookingStateBySlot, boolean chance, boolean customRecipe) {
        ItemStack inputStack = (ItemStack)inventory.get(inputSlot);
        if (inputStack.isEmpty()) {
            cookingStateBySlot.get(inputSlot).resetProgress();
        }
        if (customRecipe) {
            if (recipe == null || !(recipe.value() instanceof AbstractCookingRecipe) || !RecipeValidation.isValidRecipe(recipe, level)) {
                cookingStateBySlot.get(inputSlot).resetProgress();
                return;
            }
        } else if (recipe == null || !(recipe.value() instanceof AbstractCookingRecipe)) {
            cookingStateBySlot.get(inputSlot).resetProgress();
            return;
        }
        AbstractCookingRecipe cookingRecipe = (AbstractCookingRecipe)recipe.value();
        ItemStack resultStack = cookingRecipe.assemble(new SingleRecipeInput(inputStack), (HolderLookup.Provider)registryAccess);
        ItemStack outputStack = (ItemStack)inventory.get(outputSlot);
        if (!(outputStack.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)outputStack, (ItemStack)resultStack) && outputStack.getCount() < maxStackSize)) {
            return;
        }
        inputStack.shrink(1);
        if (chance) {
            ExtraItemManager.extraItemChance(tierID, resultStack);
        }
        if (outputStack.isEmpty()) {
            inventory.set(outputSlot, (Object)resultStack.copy());
        } else if (ItemStack.isSameItemSameComponents((ItemStack)outputStack, (ItemStack)resultStack)) {
            outputStack.grow(resultStack.getCount());
        }
        if (!chance) {
            extraItemManager.updateSmeltedItem(inputSlot, inputStack.getItem());
            if (extraItemManager.shouldGrantExtraItem(tierID, inputSlot)) {
                extraItemManager.grantExtraItem(level, worldPosition, inputSlot, outputSlot, maxStackSize, resultStack, (ItemStack[])inventory.toArray((Object[])new ItemStack[0]));
            }
        }
        cookingStateBySlot.get(inputSlot).resetProgress();
    }
}

