/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.util.entitiy;

import net.biorfn.compressedfurnace.config.Config;

public class CookingState {
    private int progress;
    private int totalTime;

    public CookingState(int progress, int totalTime) {
        this.progress = progress;
        this.totalTime = totalTime;
    }

    public static CookingState createWithTier(String tierID, int baseTime) {
        int adjustedTime = CookingState.getCookTimeForTier(tierID, baseTime);
        return new CookingState(0, adjustedTime);
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public int getTotalTime() {
        return this.totalTime;
    }

    public boolean isComplete() {
        return this.progress >= this.totalTime;
    }

    public void setTotalTime(int totalTime) {
        this.totalTime = totalTime;
    }

    public void resetProgress() {
        this.progress = 0;
    }

    public void incrementProgress() {
        if (this.progress < this.totalTime) {
            ++this.progress;
        }
    }

    public String toString() {
        return "CookingState{progress=" + this.progress + ", totalTime=" + this.totalTime + "}";
    }

    private static int getCookTimeForTier(String tierID, int defaultCookTime) {
        return switch (tierID) {
            case "compressed" -> (int)((double)defaultCookTime * (Double)Config.compressedCookTimeModifier.get());
            case "double_compressed" -> (int)((double)defaultCookTime * (Double)Config.doubleCompressedCookTimeModifier.get());
            case "triple_compressed" -> (int)((double)defaultCookTime * (Double)Config.tripleCompressedCookTimeModifier.get());
            default -> defaultCookTime;
        };
    }
}

