/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.util.entitiy;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.biorfn.compressedfurnace.config.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ExtraItemManager {
    private final Map<Integer, Integer> smeltedItemCountBySlot = new HashMap<Integer, Integer>();
    private final Map<Integer, Item> lastSmeltedItemBySlot = new HashMap<Integer, Item>();

    public static void extraItemChance(String tierID, ItemStack resultStack) {
        double[] chances;
        for (double chance : chances = ExtraItemManager.getChancesForTier(tierID)) {
            if (!(Math.random() < chance)) continue;
            resultStack.grow(1);
        }
    }

    private static double[] getChancesForTier(String tierID) {
        switch (tierID) {
            case "compressed": {
                return ((List)Config.compressedChances.get()).stream().mapToDouble(Double::doubleValue).toArray();
            }
            case "double_compressed": {
                return ((List)Config.doubleCompressedChances.get()).stream().mapToDouble(Double::doubleValue).toArray();
            }
            case "triple_compressed": {
                return ((List)Config.tripleCompressedChances.get()).stream().mapToDouble(Double::doubleValue).toArray();
            }
        }
        return new double[0];
    }

    public void updateSmeltedItem(int inputSlot, Item currentItem) {
        Item lastSmeltedItem = this.lastSmeltedItemBySlot.get(inputSlot);
        if (lastSmeltedItem == null || !lastSmeltedItem.equals(currentItem)) {
            this.smeltedItemCountBySlot.put(inputSlot, 0);
            this.lastSmeltedItemBySlot.put(inputSlot, currentItem);
        }
    }

    public boolean shouldGrantExtraItem(String tierID, int inputSlot) {
        boolean allowed = false;
        int smeltedCount = this.smeltedItemCountBySlot.getOrDefault(inputSlot, 0) + 1;
        this.smeltedItemCountBySlot.put(inputSlot, smeltedCount);
        int threshold = ExtraItemManager.getThresholdForTier(tierID);
        return allowed && smeltedCount % threshold == 0;
    }

    private static int getThresholdForTier(String tierID) {
        return switch (tierID) {
            case "compressed" -> 0;
            case "double_compressed" -> 0;
            case "triple_compressed" -> 0;
            default -> 0;
        };
    }

    public void grantExtraItem(Level level, BlockPos pos, int inputSlot, int outputSlot, int maxStackSize, ItemStack resultStack, ItemStack[] inventory) {
        ItemStack outputStack = inventory[outputSlot];
        if (outputStack.isEmpty()) {
            resultStack.grow(1);
            inventory[outputSlot] = resultStack.copy();
        } else if (ItemStack.isSameItemSameComponents((ItemStack)outputStack, (ItemStack)resultStack)) {
            int newCount = outputStack.getCount() + 1;
            if (newCount <= maxStackSize) {
                outputStack.grow(1);
            } else {
                outputStack.setCount(maxStackSize);
            }
        } else {
            level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), resultStack.copy()));
        }
        this.smeltedItemCountBySlot.put(inputSlot, 0);
    }
}

