/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.util.widgets;

import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;

public class ConfigSlider
extends AbstractSliderButton {
    private final Component label;
    private final int minValue;
    private final int maxValue;
    private final Consumer<Integer> onValueChange;

    public ConfigSlider(int x, int y, int width, int height, Component label, int initialValue, int minValue, int maxValue, Consumer<Integer> onValueChange) {
        super(x, y, width, height, label, (double)(initialValue - minValue) / (double)(maxValue - minValue));
        this.label = label;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.onValueChange = onValueChange;
        this.updateMessage();
    }

    protected void updateMessage() {
        int currentValue = (int)(this.value * (double)(this.maxValue - this.minValue)) + this.minValue;
        this.setMessage((Component)Component.literal((String)(this.label.getString() + ": " + currentValue)));
    }

    protected void applyValue() {
        int currentValue = (int)(this.value * (double)(this.maxValue - this.minValue)) + this.minValue;
        this.onValueChange.accept(currentValue);
    }

    public double getValue() {
        return this.value;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean handled = false;
        if (keyCode == 65) {
            this.value = Math.max(0.0, this.value - 0.1);
        } else if (keyCode == 68) {
            this.value = Math.min(1.0, this.value + 0.1);
        }
        if (handled) {
            this.updateMessage();
            this.applyValue();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }
}

