/*
 * Decompiled with CFR 0.152.
 */
package assemblyline.client.event.levelstage;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;
import voltaic.client.event.AbstractLevelStageHandler;
import voltaic.prefab.utilities.math.Color;

public class HandlerFarmerLines
extends AbstractLevelStageHandler {
    public static final HandlerFarmerLines INSTANCE = new HandlerFarmerLines();
    private final HashMap<BlockPos, Pair<Color[], List<AABB>>> farmerLines = new HashMap();

    public void render(Camera camera, Frustum frustum, LevelRenderer levelRenderer, PoseStack stack, Matrix4f matrix4f, Minecraft minecraft, int renderTick, DeltaTracker deltaTracker) {
        stack.pushPose();
        MultiBufferSource.BufferSource buffer = minecraft.renderBuffers().bufferSource();
        VertexConsumer builder = buffer.getBuffer((RenderType)RenderType.LINES);
        Vec3 camPos = camera.getPosition();
        stack.translate(-camPos.x, -camPos.y, -camPos.z);
        for (Map.Entry<BlockPos, Pair<Color[], List<AABB>>> en : this.farmerLines.entrySet()) {
            Color[] rgbaValues = (Color[])en.getValue().getFirst();
            List lines = (List)en.getValue().getSecond();
            for (int i = 0; i < lines.size(); ++i) {
                AABB box = ((AABB)lines.get(i)).deflate(0.01);
                float[] rgba = rgbaValues[i].colorFloatArr();
                LevelRenderer.renderLineBox((PoseStack)stack, (VertexConsumer)builder, (AABB)box, (float)rgba[0], (float)rgba[1], (float)rgba[2], (float)rgba[3]);
            }
        }
        stack.popPose();
    }

    public boolean shouldRender(RenderLevelStageEvent.Stage stage) {
        return stage == RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS;
    }

    public void clear() {
        this.farmerLines.clear();
    }

    public static boolean isBeingRendered(BlockPos pos) {
        return HandlerFarmerLines.INSTANCE.farmerLines.containsKey(pos);
    }

    public static void remove(BlockPos pos) {
        HandlerFarmerLines.INSTANCE.farmerLines.remove(pos);
    }

    public static void addRenderData(BlockPos pos, Pair<Color[], List<AABB>> data) {
        HandlerFarmerLines.INSTANCE.farmerLines.put(pos, data);
    }
}

