/*
 * Decompiled with CFR 0.152.
 */
package assemblyline.client.render.tile;

import assemblyline.common.tile.TileCrate;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import voltaic.client.render.AbstractTileRenderer;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.utilities.math.MathUtils;

public class RenderCrate
extends AbstractTileRenderer<TileCrate> {
    public RenderCrate(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void render(TileCrate tileCrate, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (tileCrate.getCount() <= 0) {
            return;
        }
        for (Direction dir : Direction.values()) {
            if (dir == Direction.UP || dir == Direction.DOWN) continue;
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.5 + (double)dir.getStepX() / 1.999, 0.3 + (double)dir.getStepY() / 2.0, 0.5 + (double)dir.getStepZ() / 1.999);
            switch (dir) {
                case EAST: {
                    matrixStackIn.mulPose(MathUtils.rotQuaternionDeg((float)0.0f, (float)-90.0f, (float)0.0f));
                    break;
                }
                case NORTH: {
                    break;
                }
                case SOUTH: {
                    matrixStackIn.mulPose(MathUtils.rotQuaternionDeg((float)0.0f, (float)180.0f, (float)0.0f));
                    break;
                }
                case WEST: {
                    matrixStackIn.mulPose(MathUtils.rotQuaternionDeg((float)0.0f, (float)90.0f, (float)0.0f));
                    break;
                }
            }
            ItemStack item = ItemStack.EMPTY;
            for (ItemStack stack : ((ComponentInventory)tileCrate.getComponent(IComponentType.Inventory)).getItems()) {
                if (stack.isEmpty()) continue;
                item = stack;
                break;
            }
            MutableComponent displayNameIn = Component.literal((String)(tileCrate.getCount() + "x" + item.getHoverName().getString()));
            Font fontrenderer = Minecraft.getInstance().font;
            float scale = 0.025f / ((float)fontrenderer.width((FormattedText)displayNameIn) / 32.0f);
            matrixStackIn.scale(-scale, -scale, scale);
            Matrix4f matrix4f = matrixStackIn.last().pose();
            float f2 = (float)(-fontrenderer.width((FormattedText)displayNameIn)) / 2.0f;
            fontrenderer.drawInBatch((Component)displayNameIn, f2, 0.0f, 0, false, matrix4f, bufferIn, Font.DisplayMode.NORMAL, 0, combinedLightIn);
            matrixStackIn.popPose();
            ItemStack stack = ((ComponentInventory)tileCrate.getComponent(IComponentType.Inventory)).getItem(0);
            matrixStackIn.pushPose();
            matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)-180.0f, (Vector3f)MathUtils.YP));
            if (dir == Direction.NORTH) {
                matrixStackIn.translate(-1.0f, 0.0f, 0.0f);
            }
            if (dir == Direction.EAST) {
                matrixStackIn.translate(-1.0f, 0.0f, -1.0f);
                matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)-90.0f, (Vector3f)MathUtils.YP));
            }
            if (dir == Direction.SOUTH) {
                matrixStackIn.translate(0.0f, 0.0f, -1.0f);
                matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)-180.0f, (Vector3f)MathUtils.YP));
            }
            if (dir == Direction.WEST) {
                matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)90.0f, (Vector3f)MathUtils.YP));
            }
            matrixStackIn.translate(0.5, 0.6, 0.0);
            if (stack.getItem() instanceof BlockItem) {
                matrixStackIn.scale(0.35f, 0.35f, 0.35f);
            } else {
                matrixStackIn.scale(0.4f, 0.4f, 0.4f);
            }
            Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.NONE, 0xF000F0, combinedOverlayIn, matrixStackIn, bufferIn, tileCrate.getLevel(), 0);
            matrixStackIn.popPose();
        }
    }
}

