/*
 * Decompiled with CFR 0.152.
 */
package assemblyline.common.block;

import assemblyline.common.tile.belt.utils.GenericTileConveyorBelt;
import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import voltaic.common.block.states.VoltaicBlockStates;
import voltaic.common.block.voxelshapes.VoxelShapeProvider;
import voltaic.prefab.block.GenericEntityBlockWaterloggable;

public class BlockConveyorBelt
extends GenericEntityBlockWaterloggable {
    public static final double MAX_Y = 0.3125;
    private final VoxelShapeProvider shapeProvider;
    private final BlockEntityType.BlockEntitySupplier<?> supplier;

    public BlockConveyorBelt(VoxelShapeProvider shapeProvider, BlockEntityType.BlockEntitySupplier<?> supplier) {
        super(Blocks.IRON_BLOCK.properties().strength(3.5f).sound(SoundType.METAL).requiresCorrectToolForDrops().noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)VoltaicBlockStates.FACING, (Comparable)Direction.NORTH));
        this.shapeProvider = shapeProvider;
        this.supplier = supplier;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction dir = null;
        if (state.hasProperty((Property)VoltaicBlockStates.FACING)) {
            dir = (Direction)state.getValue((Property)VoltaicBlockStates.FACING);
        }
        return this.shapeProvider.getShape(dir);
    }

    public void onRotate(ItemStack stack, BlockPos pos, Player player) {
        BlockEntity blockEntity = player.level().getBlockEntity(pos);
        if (blockEntity instanceof GenericTileConveyorBelt) {
            GenericTileConveyorBelt belt = (GenericTileConveyorBelt)blockEntity;
            belt.cycleConveyorType();
        }
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        return Arrays.asList(new ItemStack((ItemLike)this));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return null;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)VoltaicBlockStates.FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{VoltaicBlockStates.FACING});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return this.supplier.create(pos, state);
    }
}

