/*
 * Decompiled with CFR 0.152.
 */
package assemblyline.common.block;

import assemblyline.common.tile.belt.TileDetector;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import voltaic.common.block.states.VoltaicBlockStates;
import voltaic.prefab.block.GenericEntityBlockWaterloggable;

public class BlockDetector
extends GenericEntityBlockWaterloggable {
    public BlockDetector() {
        super(Blocks.IRON_BLOCK.properties().strength(3.5f).sound(SoundType.METAL).requiresCorrectToolForDrops().noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)VoltaicBlockStates.FACING, (Comparable)Direction.NORTH));
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)VoltaicBlockStates.FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{VoltaicBlockStates.FACING});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TileDetector(pos, state);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return null;
    }
}

