/*
 * Decompiled with CFR 0.152.
 */
package assemblyline.common.tile;

import assemblyline.common.inventory.container.ContainerAutocrafter;
import assemblyline.common.settings.AssemblyLineConfig;
import assemblyline.registers.AssemblyLineTiles;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.RecipeMatcher;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentForgeEnergy;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;

public class TileAutocrafter
extends GenericTile {
    public TileAutocrafter(BlockPos worldPosition, BlockState blockState) {
        super((BlockEntityType)AssemblyLineTiles.TILE_AUTOCRAFTER.get(), worldPosition, blockState);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).maxJoules(AssemblyLineConfig.INSTANCE.AUTOCRAFTER_USAGE.getAsDouble() * 20.0).setInputDirections(BlockEntityUtils.MachineDirection.values()));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().inputs(9).outputs(1)).setSlotsByDirection(BlockEntityUtils.MachineDirection.BOTTOM, new Integer[]{9}).setSlotsByDirection(BlockEntityUtils.MachineDirection.TOP, new Integer[]{1, 3, 4, 5, 7}).setSlotsByDirection(BlockEntityUtils.MachineDirection.BACK, new Integer[]{6, 7, 8}).setSlotsByDirection(BlockEntityUtils.MachineDirection.FRONT, new Integer[]{0, 1, 2}).setSlotsByDirection(BlockEntityUtils.MachineDirection.LEFT, new Integer[]{2, 5, 8}).setSlotsByDirection(BlockEntityUtils.MachineDirection.RIGHT, new Integer[]{0, 3, 6}));
        this.addComponent((IComponent)new ComponentContainerProvider("autocrafter", (GenericTile)this).createMenu((id, player) -> new ContainerAutocrafter((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
        this.addComponent((IComponent)new ComponentForgeEnergy((GenericTile)this));
    }

    public static boolean shapedMatches(ComponentInventory inv, ShapedRecipe shaped) {
        for (int i = 0; i <= 3 - shaped.getWidth(); ++i) {
            for (int j = 0; j <= 3 - shaped.getHeight(); ++j) {
                if (!TileAutocrafter.shapedMatches(inv, shaped, i, j, true) && !TileAutocrafter.shapedMatches(inv, shaped, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean shapedMatches(ComponentInventory inventory, ShapedRecipe shaped, int x, int y, boolean flag) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int k = i - x;
                int l = j - y;
                Ingredient ingredient = Ingredient.EMPTY;
                if (k >= 0 && l >= 0 && k < shaped.getWidth() && l < shaped.getHeight()) {
                    ingredient = flag ? (Ingredient)shaped.getIngredients().get(shaped.getWidth() - k - 1 + l * shaped.getWidth()) : (Ingredient)shaped.getIngredients().get(k + l * shaped.getWidth());
                }
                if (ingredient.test(inventory.getItem(i + j * 3))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean shapelessMatches(ComponentInventory inventory, ShapelessRecipe shaped) {
        StackedContents stackedcontents = new StackedContents();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        boolean isSimple = shaped.getIngredients().stream().allMatch(Ingredient::isSimple);
        int i = 0;
        for (int j = 0; j < 9; ++j) {
            ItemStack itemstack = inventory.getItem(j);
            if (itemstack.isEmpty()) continue;
            ++i;
            if (isSimple) {
                stackedcontents.accountStack(itemstack, 1);
                continue;
            }
            inputs.add(itemstack);
        }
        return i == shaped.getIngredients().size() && (isSimple ? stackedcontents.canCraft((Recipe)shaped, (IntList)null) : RecipeMatcher.findMatches(inputs, (List)shaped.getIngredients()) != null);
    }

    public void tickServer(ComponentTickable tick) {
        boolean canContinue;
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        boolean bl = canContinue = electro.getJoulesStored() >= AssemblyLineConfig.INSTANCE.AUTOCRAFTER_USAGE.getAsDouble();
        if (tick.getTicks() % 20L == 0L && canContinue) {
            ComponentInventory inventory = (ComponentInventory)this.getComponent(IComponentType.Inventory);
            for (int i = 0; i < 9; ++i) {
                if (inventory.getItem(i).getCount() != 1) continue;
                canContinue = false;
            }
            if (canContinue) {
                ItemStack currentItemStack;
                List recipes = this.level.getServer().getRecipeManager().getAllRecipesFor(RecipeType.CRAFTING);
                ItemStack result = ItemStack.EMPTY;
                canContinue = false;
                for (RecipeHolder recipe : recipes) {
                    ShapelessRecipe shapelessRecipe;
                    result = ((CraftingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)this.level.registryAccess());
                    Recipe recipe2 = recipe.value();
                    if (recipe2 instanceof ShapedRecipe) {
                        ShapedRecipe shapedRecipe = (ShapedRecipe)recipe2;
                        if (!TileAutocrafter.shapedMatches(inventory, shapedRecipe)) continue;
                        canContinue = true;
                        break;
                    }
                    recipe2 = recipe.value();
                    if (!(recipe2 instanceof ShapelessRecipe) || !TileAutocrafter.shapelessMatches(inventory, shapelessRecipe = (ShapelessRecipe)recipe2)) continue;
                    canContinue = true;
                    break;
                }
                if (canContinue && ((currentItemStack = inventory.getItem(9)).isEmpty() || ItemStack.isSameItem((ItemStack)result, (ItemStack)currentItemStack) && currentItemStack.getCount() + result.getCount() <= result.getMaxStackSize())) {
                    for (int i = 0; i < 9; ++i) {
                        inventory.getItem(i).shrink(1);
                    }
                    if (currentItemStack.isEmpty()) {
                        inventory.setItem(9, result.copy());
                    } else {
                        currentItemStack.grow(result.getCount());
                    }
                    electro.joules(electro.getJoulesStored() - AssemblyLineConfig.INSTANCE.AUTOCRAFTER_USAGE.getAsDouble());
                }
            }
        }
    }
}

