/*
 * Decompiled with CFR 0.152.
 */
package assemblyline.common.tile;

import assemblyline.common.inventory.container.ContainerBlockBreaker;
import assemblyline.common.settings.AssemblyLineConfig;
import assemblyline.common.tile.util.TileOutlineArea;
import assemblyline.registers.AssemblyLineSounds;
import assemblyline.registers.AssemblyLineTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import voltaic.api.particle.ParticleAPI;
import voltaic.api.sound.SoundAPI;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentForgeEnergy;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;

public class TileBlockBreaker
extends TileOutlineArea {
    public SingleProperty<Integer> ticksSinceCheck = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "ticksSinceCheck", (Object)0));
    public SingleProperty<Integer> currentWaitTime = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "currentWaitTime", (Object)0));
    public final SingleProperty<Boolean> works = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "works", (Object)false));
    public final SingleProperty<Double> progress = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "progress", (Object)0.0));

    public TileBlockBreaker(BlockPos pos, BlockState state) {
        super((BlockEntityType)AssemblyLineTiles.TILE_BLOCKBREAKER.get(), pos, state);
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer).tickClient(this::tickClient));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.FRONT}).voltage(120.0).maxJoules(AssemblyLineConfig.INSTANCE.BLOCKBREAKER_USAGE.getAsDouble() * 20.0));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().upgrades(3)).validUpgrades(ContainerBlockBreaker.VALID_UPGRADES).valid(TileBlockBreaker.machineValidator()));
        this.addComponent((IComponent)new ComponentContainerProvider("blockbreaker", (GenericTile)this).createMenu((id, player) -> new ContainerBlockBreaker((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
        this.addComponent((IComponent)new ComponentForgeEnergy((GenericTile)this));
        this.height.setValue((Object)1);
    }

    public void tickServer(ComponentTickable component) {
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        if (electro.getJoulesStored() < AssemblyLineConfig.INSTANCE.BLOCKBREAKER_USAGE.getAsDouble()) {
            this.progress.setValue((Object)0.0);
            return;
        }
        this.ticksSinceCheck.setValue((Object)((int)((Double)this.progress.getValue() * 100.0)));
        this.currentWaitTime.setValue((Object)100);
        Direction facing = this.getFacing();
        BlockPos block = this.worldPosition.offset(facing.getOpposite().getNormal());
        BlockState blockState = this.level.getBlockState(block);
        this.works.setValue((Object)(!blockState.isAir() && blockState.getDestroySpeed((BlockGetter)this.level, block) > 0.0f ? 1 : 0));
        if (!((Boolean)this.works.getValue()).booleanValue()) {
            this.progress.setValue((Object)0.0);
            return;
        }
        double k1 = 1.0f / blockState.getDestroySpeed((BlockGetter)this.level, block) / 30.0f;
        if ((Double)this.progress.getValue() < 1.0) {
            this.progress.setValue((Object)((Double)this.progress.getValue() + k1 * 5.0));
            electro.joules(electro.getJoulesStored() - AssemblyLineConfig.INSTANCE.BLOCKBREAKER_USAGE.getAsDouble());
            return;
        }
        this.level.destroyBlock(block, true);
        this.progress.setValue((Object)0.0);
        this.works.setValue((Object)false);
    }

    public void tickClient(ComponentTickable component) {
        if (!((Boolean)this.works.getValue()).booleanValue()) {
            return;
        }
        if (component.getTicks() % 200L == 0L) {
            SoundAPI.playSound((SoundEvent)((SoundEvent)AssemblyLineSounds.SOUND_BLOCKBREAKER.get()), (SoundSource)SoundSource.BLOCKS, (float)0.5f, (float)1.0f, (BlockPos)this.worldPosition);
        }
        BlockPos offset = this.worldPosition.offset(this.getFacing().getOpposite().getNormal());
        Block block = this.level.getBlockState(offset).getBlock();
        double d4 = this.level.random.nextDouble() * 1.2 + (double)offset.getX() - 0.1;
        double d5 = this.level.random.nextDouble() * 1.2 + (double)offset.getY() - 0.1;
        double d6 = this.level.random.nextDouble() * 1.2 + (double)offset.getZ() - 0.1;
        ParticleAPI.addGrindedParticle((Level)this.level, (double)d4, (double)d5, (double)d6, (double)0.0, (double)5.0, (double)0.0, (BlockState)block.defaultBlockState(), (BlockPos)this.worldPosition);
    }

    public int getComparatorSignal() {
        return (Boolean)this.works.getValue() != false ? 15 : 0;
    }
}

