/*
 * Decompiled with CFR 0.152.
 */
package assemblyline.common.tile;

import assemblyline.common.inventory.container.ContainerBlockPlacer;
import assemblyline.common.settings.AssemblyLineConfig;
import assemblyline.common.tile.util.TileOutlineArea;
import assemblyline.registers.AssemblyLineTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import voltaic.common.item.ItemUpgrade;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentForgeEnergy;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;

public class TileBlockPlacer
extends TileOutlineArea {
    public SingleProperty<Integer> ticksSinceCheck = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "ticksSinceCheck", (Object)0));
    public SingleProperty<Integer> currentWaitTime = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "currentWaitTime", (Object)0));

    public TileBlockPlacer(BlockPos pos, BlockState state) {
        super((BlockEntityType)AssemblyLineTiles.TILE_BLOCKPLACER.get(), pos, state);
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.FRONT}).voltage(120.0).maxJoules(AssemblyLineConfig.INSTANCE.BLOCKPLACER_USAGE.getAsDouble() * 2.0));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().inputs(1).upgrades(3)).setDirectionsBySlot(Integer.valueOf(0), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.TOP, BlockEntityUtils.MachineDirection.BOTTOM, BlockEntityUtils.MachineDirection.LEFT, BlockEntityUtils.MachineDirection.RIGHT}).validUpgrades(ContainerBlockPlacer.VALID_UPGRADES).valid(TileBlockPlacer.machineValidator()));
        this.addComponent((IComponent)new ComponentContainerProvider("blockplacer", (GenericTile)this).createMenu((id, player) -> new ContainerBlockPlacer((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
        this.addComponent((IComponent)new ComponentForgeEnergy((GenericTile)this));
        this.height.setValue((Object)1);
    }

    public void tickServer(ComponentTickable tickable) {
        BlockItem bi;
        Block b;
        BlockState newState;
        Item item;
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        this.currentWaitTime.setValue((Object)20);
        for (ItemStack stack : inv.getUpgradeContents()) {
            if (stack.isEmpty()) continue;
            ItemUpgrade upgrade = (ItemUpgrade)stack.getItem();
            switch (upgrade.subtype) {
                case iteminput: {
                    upgrade.subtype.applyUpgrade.accept((Object)this, (Object)stack, (Object)0);
                    break;
                }
            }
        }
        if (electro.getJoulesStored() < AssemblyLineConfig.INSTANCE.BLOCKPLACER_USAGE.getAsDouble() || inv.areInputsEmpty()) {
            return;
        }
        this.ticksSinceCheck.setValue((Object)((Integer)this.ticksSinceCheck.getValue() + 1));
        if ((Integer)this.ticksSinceCheck.getValue() >= (Integer)this.currentWaitTime.getValue()) {
            this.ticksSinceCheck.setValue((Object)0);
        }
        if ((Integer)this.ticksSinceCheck.getValue() != 0) {
            return;
        }
        Direction facing = this.getFacing();
        BlockPos off = this.worldPosition.offset(facing.getOpposite().getNormal());
        BlockState state = this.level.getBlockState(off);
        electro.setJoulesStored(electro.getJoulesStored() - AssemblyLineConfig.INSTANCE.BLOCKBREAKER_USAGE.getAsDouble());
        if (!state.isAir()) {
            return;
        }
        ItemStack stack = inv.getItem(0);
        if (!stack.isEmpty() && (item = stack.getItem()) instanceof BlockItem && (newState = (b = (bi = (BlockItem)item).getBlock()).getStateForPlacement((BlockPlaceContext)new DirectionalPlaceContext(this.level, off, facing, stack, facing))).canSurvive((LevelReader)this.level, off)) {
            this.level.setBlockAndUpdate(off, newState);
            stack.shrink(1);
        }
    }
}

