/*
 * Decompiled with CFR 0.152.
 */
package assemblyline.common.tile;

import assemblyline.common.inventory.container.ContainerMobGrinder;
import assemblyline.common.settings.AssemblyLineConfig;
import assemblyline.common.tile.util.TileOutlineArea;
import assemblyline.registers.AssemblyLineAttachmentTypes;
import assemblyline.registers.AssemblyLineTiles;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import voltaic.common.item.ItemUpgrade;
import voltaic.common.item.subtype.SubtypeItemUpgrade;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentForgeEnergy;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;

public class TileMobGrinder
extends TileOutlineArea {
    public static final int DEFAULT_WAIT_TICKS = 600;
    public static final int FASTEST_WAIT_TICKS = 60;
    public SingleProperty<Double> powerUsageMultiplier = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "powerUsageMultiplier", (Object)1.0));
    public SingleProperty<Integer> ticksSinceCheck = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "ticksSinceCheck", (Object)0));
    public SingleProperty<Integer> currentWaitTime = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "currentWaitTime", (Object)0));

    public TileMobGrinder(BlockPos pos, BlockState state) {
        super((BlockEntityType)AssemblyLineTiles.TILE_MOBGRINDER.get(), pos, state);
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.FRONT}).voltage(120.0).maxJoules(AssemblyLineConfig.INSTANCE.MOBGRINDER_USAGE.getAsDouble() * 40.0));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().outputs(9).upgrades(3)).setDirectionsBySlot(Integer.valueOf(0), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.TOP, BlockEntityUtils.MachineDirection.BOTTOM, BlockEntityUtils.MachineDirection.LEFT, BlockEntityUtils.MachineDirection.RIGHT}).setDirectionsBySlot(Integer.valueOf(1), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.TOP, BlockEntityUtils.MachineDirection.BOTTOM, BlockEntityUtils.MachineDirection.LEFT, BlockEntityUtils.MachineDirection.RIGHT}).setDirectionsBySlot(Integer.valueOf(2), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.TOP, BlockEntityUtils.MachineDirection.BOTTOM, BlockEntityUtils.MachineDirection.LEFT, BlockEntityUtils.MachineDirection.RIGHT}).setDirectionsBySlot(Integer.valueOf(3), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.TOP, BlockEntityUtils.MachineDirection.BOTTOM, BlockEntityUtils.MachineDirection.LEFT, BlockEntityUtils.MachineDirection.RIGHT}).setDirectionsBySlot(Integer.valueOf(4), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.TOP, BlockEntityUtils.MachineDirection.BOTTOM, BlockEntityUtils.MachineDirection.LEFT, BlockEntityUtils.MachineDirection.RIGHT}).setDirectionsBySlot(Integer.valueOf(5), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.TOP, BlockEntityUtils.MachineDirection.BOTTOM, BlockEntityUtils.MachineDirection.LEFT, BlockEntityUtils.MachineDirection.RIGHT}).setDirectionsBySlot(Integer.valueOf(6), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.TOP, BlockEntityUtils.MachineDirection.BOTTOM, BlockEntityUtils.MachineDirection.LEFT, BlockEntityUtils.MachineDirection.RIGHT}).setDirectionsBySlot(Integer.valueOf(7), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.TOP, BlockEntityUtils.MachineDirection.BOTTOM, BlockEntityUtils.MachineDirection.LEFT, BlockEntityUtils.MachineDirection.RIGHT}).setDirectionsBySlot(Integer.valueOf(8), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.TOP, BlockEntityUtils.MachineDirection.BOTTOM, BlockEntityUtils.MachineDirection.LEFT, BlockEntityUtils.MachineDirection.RIGHT}).validUpgrades(ContainerMobGrinder.VALID_UPGRADES).valid(TileMobGrinder.machineValidator()));
        this.addComponent((IComponent)new ComponentContainerProvider("mobgrinder", (GenericTile)this).createMenu((id, player) -> new ContainerMobGrinder((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
        this.addComponent((IComponent)new ComponentForgeEnergy((GenericTile)this));
    }

    public void tickServer(ComponentTickable tickable) {
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        for (ItemStack stack : inv.getUpgradeContents()) {
            if (stack.isEmpty()) continue;
            ItemUpgrade upgrade = (ItemUpgrade)stack.getItem();
            if (upgrade.subtype != SubtypeItemUpgrade.itemoutput) continue;
            upgrade.subtype.applyUpgrade.accept((Object)this, (Object)stack, (Object)0);
        }
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        if (electro.getJoulesStored() < AssemblyLineConfig.INSTANCE.MOBGRINDER_USAGE.getAsDouble() * (Double)this.powerUsageMultiplier.getValue() || !inv.areOutputsEmpty()) {
            return;
        }
        this.ticksSinceCheck.setValue((Object)((Integer)this.ticksSinceCheck.getValue() + 1));
        if ((Integer)this.ticksSinceCheck.getValue() >= (Integer)this.currentWaitTime.getValue()) {
            this.ticksSinceCheck.setValue((Object)0);
        }
        if ((Integer)this.ticksSinceCheck.getValue() != 0) {
            return;
        }
        this.checkArea = this.getAABB((Integer)this.width.getValue(), (Integer)this.length.getValue(), (Integer)this.height.getValue(), true).inflate(1.0);
        List entities = this.level.getEntities(null, this.checkArea);
        for (Entity entity : entities) {
            if (electro.getJoulesStored() < AssemblyLineConfig.INSTANCE.MOBGRINDER_USAGE.getAsDouble()) break;
            if (entity instanceof Player) continue;
            electro.joules(electro.getJoulesStored() - AssemblyLineConfig.INSTANCE.MOBGRINDER_USAGE.getAsDouble());
            entity.setData(AssemblyLineAttachmentTypes.GRINDER_KILLED_MOB, (Object)this.getBlockPos());
            entity.kill();
        }
    }

    public void onInventoryChange(ComponentInventory inv, int slot) {
        super.onInventoryChange(inv, slot);
        if (slot == -1 || slot >= inv.getUpgradeSlotStartIndex()) {
            int waitTime = 600;
            int newWidth = 1;
            int newLength = 1;
            int newHeight = 5;
            double powerMultiplier = 1.0;
            block5: for (ItemStack stack : inv.getUpgradeContents()) {
                if (stack.isEmpty()) continue;
                ItemUpgrade upgrade = (ItemUpgrade)stack.getItem();
                switch (upgrade.subtype) {
                    case advancedspeed: {
                        int i;
                        for (i = 0; i < stack.getCount(); ++i) {
                            waitTime = Math.max(waitTime / 3, 60);
                            powerMultiplier *= 1.5;
                        }
                        continue block5;
                    }
                    case basicspeed: {
                        int i;
                        for (i = 0; i < stack.getCount(); ++i) {
                            waitTime = (int)Math.max((double)waitTime / 1.25, 60.0);
                            powerMultiplier *= 1.5;
                        }
                        continue block5;
                    }
                    case range: {
                        int i;
                        for (i = 0; i < stack.getCount(); ++i) {
                            newLength = Math.min(newLength + 2, 25);
                            newWidth = Math.min(newWidth + 2, 25);
                            powerMultiplier *= 1.3;
                        }
                        continue block5;
                    }
                }
            }
            this.currentWaitTime.setValue((Object)waitTime);
            this.width.setValue((Object)newWidth);
            this.length.setValue((Object)newLength);
            this.height.setValue((Object)newHeight);
            this.powerUsageMultiplier.setValue((Object)powerMultiplier);
        }
    }
}

