/*
 * Decompiled with CFR 0.152.
 */
package assemblyline.common.tile.belt;

import assemblyline.common.tile.belt.utils.GenericTileConveyorBelt;
import assemblyline.registers.AssemblyLineTiles;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.object.CachedTileOutput;

public class TileDetector
extends GenericTile {
    public boolean isPowered = false;
    private CachedTileOutput beltCache;

    public TileDetector(BlockPos worldPosition, BlockState blockState) {
        super((BlockEntityType)AssemblyLineTiles.TILE_DETECTOR.get(), worldPosition, blockState);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
    }

    public void tickServer(ComponentTickable component) {
        Object object;
        if (this.beltCache == null) {
            this.beltCache = new CachedTileOutput(this.getLevel(), this.getBlockPos().relative(this.getFacing()));
        }
        if (component.getTicks() % 10L == 0L && !(this.beltCache.getSafe() instanceof GenericTileConveyorBelt)) {
            this.beltCache.update(this.getBlockPos().relative(this.getFacing()));
        }
        if ((object = this.beltCache.getSafe()) instanceof GenericTileConveyorBelt) {
            GenericTileConveyorBelt belt = (GenericTileConveyorBelt)((Object)object);
            if (belt.getItemOnBelt().isEmpty() && this.isPowered) {
                this.isPowered = false;
                this.level.updateNeighborsAt(this.worldPosition, this.getBlockState().getBlock());
            }
            if (!belt.getItemOnBelt().isEmpty() && !this.isPowered) {
                this.isPowered = true;
                this.level.updateNeighborsAt(this.worldPosition, this.getBlockState().getBlock());
            }
        } else if (component.getTicks() % 4L == 0L) {
            BlockPos relative = this.worldPosition.relative(this.getFacing());
            List entities = this.level.getEntities((EntityTypeTest)EntityType.ITEM, new AABB(relative), entity -> entity != null && !entity.getItem().isEmpty());
            if (!entities.isEmpty()) {
                if (!this.isPowered) {
                    this.isPowered = true;
                    this.level.updateNeighborsAt(this.worldPosition, this.getBlockState().getBlock());
                }
            } else if (this.isPowered) {
                this.isPowered = false;
                this.level.updateNeighborsAt(this.worldPosition, this.getBlockState().getBlock());
            }
        }
    }

    public InteractionResult useWithoutItem(Player player, BlockHitResult hit) {
        return InteractionResult.PASS;
    }

    public ItemInteractionResult useWithItem(ItemStack used, Player player, InteractionHand hand, BlockHitResult hit) {
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public int getSignal(Direction dir) {
        return this.isPowered ? 15 : 0;
    }

    public int getDirectSignal(Direction dir) {
        return this.getSignal(dir);
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putBoolean("powered", this.isPowered);
    }

    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.isPowered = compound.getBoolean("powered");
    }
}

