/*
 * Decompiled with CFR 0.152.
 */
package assemblyline.common.tile.util;

import assemblyline.client.event.levelstage.HandlerHarvesterLines;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;

public abstract class TileOutlineArea
extends GenericTile {
    public static final int CHECK_HEIGHT = 5;
    protected static final int DEFAULT_CHECK_WIDTH = 1;
    protected static final int DEFAULT_CHECK_LENGTH = 1;
    protected static final int DEFAULT_CHECK_HEIGHT = 5;
    protected static final int MAX_CHECK_WIDTH = 25;
    protected static final int MAX_CHECK_LENGTH = 25;
    public SingleProperty<Integer> width = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "width", (Object)1));
    public SingleProperty<Integer> length = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "length", (Object)1));
    public SingleProperty<Integer> height = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "height", (Object)5));
    protected AABB checkArea;

    protected TileOutlineArea(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public AABB getAABB(int width, int length, int height, boolean isFlipped) {
        Direction facing = this.getFacing();
        if (isFlipped) {
            facing = facing.getOpposite();
        }
        Direction counterClockwise = facing.getCounterClockWise();
        Direction clockwise = facing.getClockWise();
        BlockPos pos = this.getBlockPos().relative(facing);
        BlockPos start = pos.relative(facing, length - 1).relative(counterClockwise, width / 2).relative(Direction.UP, height - 1);
        BlockPos end = pos.relative(clockwise, width / 2);
        return AABB.encapsulatingFullBlocks((BlockPos)start, (BlockPos)end);
    }

    public void setRemoved() {
        super.setRemoved();
        if (this.getLevel().isClientSide) {
            HandlerHarvesterLines.removeLines(this.getBlockPos());
        }
    }
}

