/*
 * Decompiled with CFR 0.152.
 */
package assemblyline.prefab.utils;

import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class AssemblyTextUtils {
    public static final String GUI_BASE = "gui";
    public static final String TOOLTIP_BASE = "tooltip";
    public static final String JEI_BASE = "jei";
    public static final String GUIDEBOOK_BASE = "guidebook";
    public static final String MESSAGE_BASE = "chat";
    public static final String JEI_INFO_ITEM = "info.item";
    public static final String JEI_INFO_FLUID = "info.fluid";
    public static final String BLOCK_BASE = "block";
    public static final String GAS_BASE = "gas";
    public static final String ADVANCEMENT_BASE = "advancement";
    public static final String DIMENSION = "dimension";
    public static final String CREATIVE_TAB = "creativetab";

    public static MutableComponent tooltip(String key, Object ... additional) {
        return AssemblyTextUtils.translated(TOOLTIP_BASE, key, additional);
    }

    public static MutableComponent guidebook(String key, Object ... additional) {
        return AssemblyTextUtils.translated(GUIDEBOOK_BASE, key, additional);
    }

    public static MutableComponent gui(String key, Object ... additional) {
        return AssemblyTextUtils.translated(GUI_BASE, key, additional);
    }

    public static MutableComponent chatMessage(String key, Object ... additional) {
        return AssemblyTextUtils.translated(MESSAGE_BASE, key, additional);
    }

    public static MutableComponent jeiTranslated(String key, Object ... additional) {
        return Component.translatable((String)("jei." + key), (Object[])additional);
    }

    public static MutableComponent jeiItemTranslated(String key, Object ... additional) {
        return AssemblyTextUtils.jeiTranslated("info.item." + key, additional);
    }

    public static MutableComponent jeiFluidTranslated(String key, Object ... additional) {
        return AssemblyTextUtils.jeiTranslated("info.fluid." + key, additional);
    }

    public static MutableComponent block(String key, Object ... additional) {
        return AssemblyTextUtils.translated(BLOCK_BASE, key, additional);
    }

    public static MutableComponent advancement(String key, Object ... additional) {
        return AssemblyTextUtils.translated(ADVANCEMENT_BASE, key, additional);
    }

    public static MutableComponent creativeTab(String key, Object ... additional) {
        return AssemblyTextUtils.translated(CREATIVE_TAB, key, additional);
    }

    public static MutableComponent translated(String base, String key, Object ... additional) {
        return Component.translatable((String)(base + ".assemblyline." + key), (Object[])additional);
    }

    public static boolean guiExists(String key) {
        return AssemblyTextUtils.translationExists(GUI_BASE, key);
    }

    public static boolean tooltipExists(String key) {
        return AssemblyTextUtils.translationExists(TOOLTIP_BASE, key);
    }

    public static boolean translationExists(String base, String key) {
        return I18n.exists((String)(base + ".assemblyline." + key));
    }
}

