/*
 * Decompiled with CFR 0.152.
 */
package assemblyline.client.event.levelstage;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;
import voltaic.client.event.AbstractLevelStageHandler;

public class HandlerHarvesterLines
extends AbstractLevelStageHandler {
    public static final HandlerHarvesterLines INSTANCE = new HandlerHarvesterLines();
    private final HashMap<BlockPos, AABB> outlines = new HashMap();

    public void render(Camera camera, Frustum frustum, LevelRenderer levelRenderer, PoseStack stack, Matrix4f matrix4f, Minecraft minecraft, int renderTick, DeltaTracker deltaTracker) {
        MultiBufferSource.BufferSource buffer = minecraft.renderBuffers().bufferSource();
        VertexConsumer builder = buffer.getBuffer((RenderType)RenderType.LINES);
        Vec3 camPos = camera.getPosition();
        stack.pushPose();
        stack.translate(-camPos.x, -camPos.y, -camPos.z);
        for (Map.Entry<BlockPos, AABB> en : this.outlines.entrySet()) {
            AABB box = en.getValue().deflate(0.001);
            LevelRenderer.renderLineBox((PoseStack)stack, (VertexConsumer)builder, (AABB)box, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        buffer.endBatch((RenderType)RenderType.LINES);
        stack.popPose();
    }

    public boolean shouldRender(RenderLevelStageEvent.Stage stage) {
        return stage == RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS;
    }

    public void clear() {
        this.outlines.clear();
    }

    public static boolean containsLines(BlockPos pos) {
        return HandlerHarvesterLines.INSTANCE.outlines.containsKey(pos);
    }

    public static void addLines(BlockPos pos, AABB lines) {
        HandlerHarvesterLines.INSTANCE.outlines.put(pos, lines);
    }

    public static void removeLines(BlockPos pos) {
        HandlerHarvesterLines.INSTANCE.outlines.remove(pos);
    }
}

