/*
 * Decompiled with CFR 0.152.
 */
package assemblyline.client.render.tile;

import assemblyline.client.AssemblyLineClientRegister;
import assemblyline.common.tile.TileBlockBreaker;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import voltaic.client.render.AbstractTileRenderer;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.RenderingUtils;
import voltaic.prefab.utilities.math.MathUtils;

public class RenderBlockBreaker
extends AbstractTileRenderer<TileBlockBreaker> {
    public RenderBlockBreaker(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void render(TileBlockBreaker breaker, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        double progress = 0.0;
        if ((double)((Integer)breaker.ticksSinceCheck.getValue()).intValue() / (double)((Integer)breaker.currentWaitTime.getValue()).intValue() > 0.0) {
            progress = ((float)((ComponentTickable)breaker.getComponent(IComponentType.Tickable)).getTicks() + ((Boolean)breaker.works.getValue() != false ? partialTicks : 0.0f)) * 20.0f;
        }
        BakedModel ibakedmodel = Minecraft.getInstance().getModelManager().getModel(AssemblyLineClientRegister.MODEL_BLOCKBREAKERWHEEL);
        matrixStackIn.pushPose();
        RenderingUtils.prepareRotationalTileModel((BlockEntity)breaker, (PoseStack)matrixStackIn);
        matrixStackIn.mulPose(MathUtils.rotQuaternionDeg((float)0.0f, (float)0.0f, (float)90.0f));
        matrixStackIn.translate(0.0625, 0.375, 0.15625);
        matrixStackIn.mulPose(MathUtils.rotQuaternionDeg((float)((float)(-progress)), (float)0.0f, (float)0.0f));
        RenderingUtils.renderModel((BakedModel)ibakedmodel, (BlockEntity)breaker, (RenderType)RenderType.solid(), (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)combinedLightIn, (int)combinedOverlayIn);
        matrixStackIn.popPose();
        matrixStackIn.pushPose();
        RenderingUtils.prepareRotationalTileModel((BlockEntity)breaker, (PoseStack)matrixStackIn);
        matrixStackIn.mulPose(MathUtils.rotQuaternionDeg((float)0.0f, (float)0.0f, (float)90.0f));
        matrixStackIn.translate(0.0625, 0.375, -0.15625);
        matrixStackIn.mulPose(MathUtils.rotQuaternionDeg((float)((float)progress), (float)0.0f, (float)0.0f));
        RenderingUtils.renderModel((BakedModel)ibakedmodel, (BlockEntity)breaker, (RenderType)RenderType.solid(), (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)combinedLightIn, (int)combinedOverlayIn);
        matrixStackIn.popPose();
        if ((double)((Integer)breaker.ticksSinceCheck.getValue()).intValue() / (double)((Integer)breaker.currentWaitTime.getValue()).intValue() <= 0.0) {
            return;
        }
        matrixStackIn.pushPose();
        Direction breaking = breaker.getFacing().getOpposite();
        BlockPos offset = breaker.getBlockPos().relative(breaking);
        BlockState state = breaker.getLevel().getBlockState(offset);
        PoseStack.Pose pose = matrixStackIn.last();
        SheetedDecalTextureGenerator vertexconsumer1 = new SheetedDecalTextureGenerator(Minecraft.getInstance().renderBuffers().crumblingBufferSource().getBuffer((RenderType)ModelBakery.DESTROY_TYPES.get((int)(Math.min((Double)breaker.progress.getValue(), 1.0) * 9.0))), pose, 1.0f);
        matrixStackIn.translate((float)breaking.getStepX(), 0.0f, (float)breaking.getStepZ());
        Minecraft.getInstance().getBlockRenderer().renderBreakingTexture(state, offset, (BlockAndTintGetter)breaker.getLevel(), matrixStackIn, (VertexConsumer)vertexconsumer1, this.level().getModelData(offset));
        matrixStackIn.popPose();
    }
}

