/*
 * Decompiled with CFR 0.152.
 */
package assemblyline.client.render.tile;

import assemblyline.client.AssemblyLineClientRegister;
import assemblyline.common.tile.belt.TileConveyorBelt;
import assemblyline.common.tile.belt.utils.ConveyorType;
import assemblyline.common.tile.belt.utils.GenericTileConveyorBelt;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import voltaic.client.render.AbstractTileRenderer;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.utilities.RenderingUtils;
import voltaic.prefab.utilities.math.MathUtils;

public class RenderConveyorBelt
extends AbstractTileRenderer<TileConveyorBelt> {
    public RenderConveyorBelt(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void render(TileConveyorBelt tile, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Vector3f move;
        matrixStackIn.pushPose();
        ComponentInventory inv = (ComponentInventory)tile.getComponent(IComponentType.Inventory);
        ItemStack stack = inv.getItem(0);
        ConveyorType type = tile.getConveyorType();
        matrixStackIn.pushPose();
        if (!stack.isEmpty()) {
            Vector3f itemVec = tile.getLocalItemLocationVector();
            move = tile.getDirectionVector();
            Direction direct = tile.getFacing().getOpposite();
            if (type != ConveyorType.HORIZONTAL) {
                move = move.add(0.0f, type == ConveyorType.SLOPED_DOWN ? -1.0f : 1.0f, 0.0f);
            }
            move.mul(partialTicks / 16.0f);
            if (((Boolean)tile.running.getValue()).booleanValue()) {
                itemVec = itemVec.add((Vector3fc)move);
            }
            boolean blockItem = stack.getItem() instanceof BlockItem;
            switch (type) {
                case HORIZONTAL: {
                    matrixStackIn.translate((double)itemVec.x(), (double)itemVec.y() + (blockItem ? 0.167 : (double)0.003125f) + (double)move.y(), (double)itemVec.z());
                    matrixStackIn.scale(0.35f, 0.35f, 0.35f);
                    matrixStackIn.translate(0.0f, 0.89285713f, 0.0f);
                    if (blockItem) break;
                    matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)90.0f, (Vector3f)MathUtils.XN));
                    break;
                }
                case SLOPED_DOWN: {
                    matrixStackIn.translate((double)itemVec.x(), (double)itemVec.y() + (blockItem ? 0.167 : 0.0625), (double)itemVec.z());
                    matrixStackIn.scale(0.35f, 0.35f, 0.35f);
                    if (!blockItem) {
                        matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)90.0f, (Vector3f)MathUtils.XN));
                    }
                    int rotate = -45;
                    if (direct == Direction.NORTH) {
                        matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)180.0f, (Vector3f)MathUtils.YP));
                        matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)rotate, (Vector3f)MathUtils.XN));
                        if (!blockItem) {
                            matrixStackIn.translate(0.0, 0.0, -0.3);
                        }
                    } else if (direct == Direction.EAST) {
                        if (blockItem) {
                            matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)90.0f, (Vector3f)MathUtils.YP));
                            matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)(-rotate), (Vector3f)MathUtils.XP));
                        } else {
                            matrixStackIn.translate(0.0, -0.4, 0.4);
                            matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)45.0f, (Vector3f)MathUtils.YP));
                        }
                    } else if (direct == Direction.WEST) {
                        if (blockItem) {
                            matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)-90.0f, (Vector3f)MathUtils.YP));
                            matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)rotate, (Vector3f)MathUtils.XN));
                        } else {
                            matrixStackIn.translate(0.0, -0.3, 0.5);
                            matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)-45.0f, (Vector3f)MathUtils.YP));
                        }
                    } else if (direct == Direction.SOUTH) {
                        matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)(-rotate), (Vector3f)MathUtils.XP));
                        if (!blockItem) {
                            matrixStackIn.translate(0.0, 0.0, 0.4);
                        }
                    }
                    matrixStackIn.translate(0.0f, 0.35714287f, 0.0f);
                    break;
                }
                case SLOPED_UP: {
                    matrixStackIn.translate((double)itemVec.x(), (double)itemVec.y() + (blockItem ? 0.4 : 0.4375), (double)itemVec.z());
                    matrixStackIn.scale(0.35f, 0.35f, 0.35f);
                    if (!blockItem) {
                        matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)90.0f, (Vector3f)MathUtils.XN));
                    }
                    int rotate = 45;
                    if (direct == Direction.NORTH) {
                        matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)180.0f, (Vector3f)MathUtils.YP));
                        matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)rotate, (Vector3f)MathUtils.XN));
                        if (!blockItem) {
                            matrixStackIn.translate(0.0, 0.0, -0.2);
                        }
                    } else if (direct == Direction.EAST) {
                        if (blockItem) {
                            matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)90.0f, (Vector3f)MathUtils.YP));
                            matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)(-rotate), (Vector3f)MathUtils.XP));
                        } else {
                            matrixStackIn.translate(0.0, -0.9, 0.3);
                            matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)-45.0f, (Vector3f)MathUtils.YP));
                        }
                    } else if (direct == Direction.WEST) {
                        if (blockItem) {
                            matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)-90.0f, (Vector3f)MathUtils.YP));
                            matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)rotate, (Vector3f)MathUtils.XN));
                        } else {
                            matrixStackIn.translate(0.0, -1.0, 0.4);
                            matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)45.0f, (Vector3f)MathUtils.YP));
                        }
                    } else if (direct == Direction.SOUTH) {
                        matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)(-rotate), (Vector3f)MathUtils.XP));
                        if (!blockItem) {
                            matrixStackIn.translate(0.0, 0.0, 0.2);
                        }
                    }
                    matrixStackIn.translate(0.0f, 0.89285713f, 0.0f);
                    break;
                }
                case VERTICAL: {
                    matrixStackIn.translate(0.5, (double)itemVec.y() + (blockItem ? 0.167 : 0.3125) + 0.3125, 0.5);
                    matrixStackIn.scale(0.35f, 0.35f, 0.35f);
                    if (blockItem) break;
                    matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)90.0f, (Vector3f)MathUtils.XN));
                    break;
                }
            }
            this.minecraft().getItemRenderer().renderStatic(stack, ItemDisplayContext.NONE, combinedLightIn, combinedOverlayIn, matrixStackIn, bufferIn, tile.getLevel(), 0);
        }
        matrixStackIn.popPose();
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.0, 0.0625, 0.0);
        RenderingUtils.prepareRotationalTileModel((BlockEntity)tile, (PoseStack)matrixStackIn);
        if (type == ConveyorType.SLOPED_DOWN) {
            matrixStackIn.translate(0.0f, -1.0f, 0.0f);
            matrixStackIn.mulPose(MathUtils.rotQuaternionDeg((float)0.0f, (float)180.0f, (float)0.0f));
        }
        ModelResourceLocation location = switch (type) {
            case ConveyorType.SLOPED_DOWN -> {
                if (((Boolean)tile.running.getValue()).booleanValue()) {
                    yield AssemblyLineClientRegister.MODEL_SLOPEDCONVEYORDOWNANIMATED;
                }
                yield AssemblyLineClientRegister.MODEL_SLOPEDCONVEYORDOWN;
            }
            case ConveyorType.SLOPED_UP -> {
                if (((Boolean)tile.running.getValue()).booleanValue()) {
                    yield AssemblyLineClientRegister.MODEL_SLOPEDCONVEYORUPANIMATED;
                }
                yield AssemblyLineClientRegister.MODEL_SLOPEDCONVEYORUP;
            }
            case ConveyorType.VERTICAL -> {
                GenericTileConveyorBelt belt;
                BlockEntity blockItem = tile.getLevel().getBlockEntity(tile.getBlockPos().below());
                if (blockItem instanceof GenericTileConveyorBelt && (belt = (GenericTileConveyorBelt)blockItem).getConveyorType() == ConveyorType.VERTICAL) {
                    if (!(tile.getLevel().getBlockEntity(tile.getBlockPos().above()) instanceof GenericTileConveyorBelt)) {
                        if (((Boolean)tile.running.getValue()).booleanValue()) {
                            yield AssemblyLineClientRegister.MODEL_ELEVATORRUNNINGBUTLAST;
                        }
                        yield AssemblyLineClientRegister.MODEL_ELEVATORBUTLAST;
                    }
                    if (((Boolean)tile.running.getValue()).booleanValue()) {
                        yield AssemblyLineClientRegister.MODEL_ELEVATORRUNNING;
                    }
                    yield AssemblyLineClientRegister.MODEL_ELEVATOR;
                }
                if (!(tile.getLevel().getBlockEntity(tile.getBlockPos().above()) instanceof GenericTileConveyorBelt)) {
                    if (((Boolean)tile.running.getValue()).booleanValue()) {
                        yield AssemblyLineClientRegister.MODEL_ELEVATORBOTTOMRUNNINGBUTLAST;
                    }
                    yield AssemblyLineClientRegister.MODEL_ELEVATORBOTTOMBUTLAST;
                }
                if (((Boolean)tile.running.getValue()).booleanValue()) {
                    yield AssemblyLineClientRegister.MODEL_ELEVATORBOTTOMRUNNING;
                }
                yield AssemblyLineClientRegister.MODEL_ELEVATORBOTTOM;
            }
            default -> (Boolean)tile.running.getValue() != false ? AssemblyLineClientRegister.MODEL_CONVEYORANIMATED : AssemblyLineClientRegister.MODEL_CONVEYOR;
        };
        RenderingUtils.renderModel((BakedModel)this.getModel(location), (BlockEntity)tile, (RenderType)RenderType.solid(), (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)combinedLightIn, (int)combinedOverlayIn);
        matrixStackIn.popPose();
        move = tile.getDirectionVector();
        BakedModel model = this.getModel(AssemblyLineClientRegister.MODEL_MANIPULATOR);
        if (((Boolean)tile.isPusher.getValue()).booleanValue()) {
            BlockPos nextBlockPos = tile.getNextPos().subtract((Vec3i)tile.getBlockPos());
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.0, 0.0625, 0.0);
            if (type == ConveyorType.SLOPED_DOWN) {
                matrixStackIn.translate(0.0, 0.4, 0.0);
            }
            matrixStackIn.translate((float)nextBlockPos.getX() - move.x(), (float)nextBlockPos.getY() - move.y(), (float)nextBlockPos.getZ() - move.z());
            RenderingUtils.prepareRotationalTileModel((BlockEntity)tile, (PoseStack)matrixStackIn);
            RenderingUtils.renderModel((BakedModel)model, (BlockEntity)tile, (RenderType)RenderType.solid(), (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)combinedLightIn, (int)combinedOverlayIn);
            matrixStackIn.popPose();
        }
        if (((Boolean)tile.isPuller.getValue()).booleanValue()) {
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.0, 0.0625, 0.0);
            RenderingUtils.prepareRotationalTileModel((BlockEntity)tile, (PoseStack)matrixStackIn);
            if (type == ConveyorType.SLOPED_UP) {
                matrixStackIn.translate(0.0, 0.4, 0.0);
            }
            matrixStackIn.mulPose(MathUtils.rotQuaternionDeg((float)0.0f, (float)180.0f, (float)0.0f));
            RenderingUtils.renderModel((BakedModel)model, (BlockEntity)tile, (RenderType)RenderType.solid(), (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)combinedLightIn, (int)combinedOverlayIn);
            matrixStackIn.popPose();
        }
        matrixStackIn.popPose();
    }

    public AABB getRenderBoundingBox(TileConveyorBelt blockEntity) {
        return super.getRenderBoundingBox((BlockEntity)blockEntity).inflate(3.0);
    }

    public int getInventorySize() {
        return 1;
    }
}

