/*
 * Decompiled with CFR 0.152.
 */
package assemblyline.client.render.tile;

import assemblyline.client.AssemblyLineClientRegister;
import assemblyline.common.settings.AssemblyLineConfig;
import assemblyline.common.tile.TileMobGrinder;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.level.block.entity.BlockEntity;
import voltaic.client.render.AbstractTileRenderer;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.utilities.RenderingUtils;
import voltaic.prefab.utilities.math.MathUtils;

public class RenderMobGrinder
extends AbstractTileRenderer<TileMobGrinder> {
    public RenderMobGrinder(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void render(TileMobGrinder grinder, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        double progress = 0.0;
        if (((ComponentElectrodynamic)grinder.getComponent(IComponentType.Electrodynamic)).getJoulesStored() >= AssemblyLineConfig.INSTANCE.MOBGRINDER_USAGE.getAsDouble() * (Double)grinder.powerUsageMultiplier.getValue()) {
            progress = (double)(System.currentTimeMillis() % 150L) / 150.0 * 360.0;
        }
        BakedModel ibakedmodel = Minecraft.getInstance().getModelManager().getModel(AssemblyLineClientRegister.MODEL_MOBGRINDERSIDEWHEEL);
        matrixStackIn.pushPose();
        RenderingUtils.prepareRotationalTileModel((BlockEntity)grinder, (PoseStack)matrixStackIn);
        matrixStackIn.mulPose(MathUtils.rotQuaternionDeg((float)0.0f, (float)0.0f, (float)90.0f));
        matrixStackIn.translate(0.0625, 0.375, 0.15625);
        matrixStackIn.mulPose(MathUtils.rotQuaternionDeg((float)((float)(-progress)), (float)0.0f, (float)0.0f));
        RenderingUtils.renderModel((BakedModel)ibakedmodel, (BlockEntity)grinder, (RenderType)RenderType.solid(), (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)combinedLightIn, (int)combinedOverlayIn);
        matrixStackIn.popPose();
        matrixStackIn.pushPose();
        RenderingUtils.prepareRotationalTileModel((BlockEntity)grinder, (PoseStack)matrixStackIn);
        matrixStackIn.mulPose(MathUtils.rotQuaternionDeg((float)0.0f, (float)0.0f, (float)90.0f));
        matrixStackIn.translate(0.0625, 0.375, -0.15625);
        matrixStackIn.mulPose(MathUtils.rotQuaternionDeg((float)((float)progress), (float)0.0f, (float)0.0f));
        RenderingUtils.renderModel((BakedModel)ibakedmodel, (BlockEntity)grinder, (RenderType)RenderType.solid(), (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)combinedLightIn, (int)combinedOverlayIn);
        matrixStackIn.popPose();
        ibakedmodel = Minecraft.getInstance().getModelManager().getModel(AssemblyLineClientRegister.MODEL_MOBGRINDERCENTERWHEEL);
        matrixStackIn.pushPose();
        RenderingUtils.prepareRotationalTileModel((BlockEntity)grinder, (PoseStack)matrixStackIn);
        matrixStackIn.mulPose(MathUtils.rotQuaternionDeg((float)0.0f, (float)0.0f, (float)90.0f));
        matrixStackIn.translate(0.0625, 0.375, 0.0);
        matrixStackIn.mulPose(MathUtils.rotQuaternionDeg((float)((float)progress), (float)0.0f, (float)0.0f));
        RenderingUtils.renderModel((BakedModel)ibakedmodel, (BlockEntity)grinder, (RenderType)RenderType.solid(), (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)combinedLightIn, (int)combinedOverlayIn);
        matrixStackIn.popPose();
    }
}

