/*
 * Decompiled with CFR 0.152.
 */
package assemblyline.client.render.tile;

import assemblyline.client.AssemblyLineClientRegister;
import assemblyline.common.settings.AssemblyLineConfig;
import assemblyline.common.tile.TileRancher;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.level.block.entity.BlockEntity;
import voltaic.client.render.AbstractTileRenderer;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.utilities.RenderingUtils;
import voltaic.prefab.utilities.math.MathUtils;

public class RenderRancher
extends AbstractTileRenderer<TileRancher> {
    public RenderRancher(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void render(TileRancher rancher, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        double progress = 0.0;
        if (((ComponentElectrodynamic)rancher.getComponent(IComponentType.Electrodynamic)).getJoulesStored() >= AssemblyLineConfig.INSTANCE.RANCHER_USAGE.getAsDouble()) {
            progress = (double)(System.currentTimeMillis() % 100L) / 100.0 * 40.0;
        }
        BakedModel ibakedmodel = Minecraft.getInstance().getModelManager().getModel(AssemblyLineClientRegister.MODEL_RANCHERLEFT);
        matrixStackIn.pushPose();
        RenderingUtils.prepareRotationalTileModel((BlockEntity)rancher, (PoseStack)matrixStackIn);
        matrixStackIn.mulPose(MathUtils.rotQuaternionDeg((float)0.0f, (float)0.0f, (float)90.0f));
        matrixStackIn.translate(0.5625, 0.1875, 0.15625);
        matrixStackIn.mulPose(MathUtils.rotQuaternionDeg((float)((float)(-progress) - 50.0f), (float)0.0f, (float)0.0f));
        RenderingUtils.renderModel((BakedModel)ibakedmodel, (BlockEntity)rancher, (RenderType)RenderType.solid(), (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)combinedLightIn, (int)combinedOverlayIn);
        matrixStackIn.popPose();
        ibakedmodel = Minecraft.getInstance().getModelManager().getModel(AssemblyLineClientRegister.MODEL_RANCHERRIGHT);
        matrixStackIn.pushPose();
        RenderingUtils.prepareRotationalTileModel((BlockEntity)rancher, (PoseStack)matrixStackIn);
        matrixStackIn.mulPose(MathUtils.rotQuaternionDeg((float)0.0f, (float)0.0f, (float)90.0f));
        matrixStackIn.translate(0.0625, 0.1875, -0.15625);
        matrixStackIn.mulPose(MathUtils.rotQuaternionDeg((float)((float)progress + 50.0f), (float)0.0f, (float)0.0f));
        RenderingUtils.renderModel((BakedModel)ibakedmodel, (BlockEntity)rancher, (RenderType)RenderType.solid(), (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)combinedLightIn, (int)combinedOverlayIn);
        matrixStackIn.popPose();
    }
}

